/*
 * Decompiled with CFR 0.152.
 */
package netmatch.qtool;

import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.swing.PScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import netmatch.algorithm.Common;
import netmatch.algorithm.GraphLoader;
import netmatch.help.netMatchQuickHelp;
import netmatch.qtool.ExampleFileFilter;
import netmatch.qtool.IQueryRecipient;
import netmatch.qtool.InvalidSIFException;
import netmatch.qtool.Network;
import netmatch.qtool.QCanvas;
import netmatch.qtool.QEdge;
import netmatch.qtool.QLoop;
import netmatch.qtool.QNode;
import netmatch.qtool.QPath;
import netmatch.qtool.QPopupMenu;

public class QToolFrame
extends JFrame
implements ActionListener,
WindowListener {
    static final Color EDGE_COLOR = new Color(77, 77, 255);
    private QCanvas canvas;
    public JTextArea infoArea;
    private JTextField statusBar;
    private JButton[] pButtons;
    private JButton[] sButtons;
    private Border originalBorder;
    private EtchedBorder selBorder;
    private IQueryRecipient recipient;
    private String queryName = "";
    boolean isModif;
    private String title;
    public ImageIcon[] icons;
    public ImageIcon[] structures;
    public ImageIcon[] menu;
    private String LastDirectory;
    private int counter;
    private boolean isSaved;
    public QPopupMenu popup;

    public QToolFrame(String title, IQueryRecipient recipient, ImageIcon[] icons, ImageIcon[] structures, ImageIcon[] menu) {
        int i;
        this.recipient = recipient;
        this.title = title;
        this.icons = icons;
        this.menu = menu;
        this.structures = structures;
        this.setIconImage(menu[15].getImage());
        this.isModif = false;
        this.getContentPane().setLayout(new BorderLayout());
        this.setTitle(title + " - new query");
        this.setSize(800, 600);
        this.addWindowListener(this);
        JPanel leftPanel = new JPanel();
        leftPanel.setPreferredSize(new Dimension(160, 200));
        leftPanel.setLayout(new BorderLayout());
        JPanel palettePanel = new JPanel();
        GridLayout paletteLayout = new GridLayout(4, 2);
        paletteLayout.setHgap(3);
        paletteLayout.setVgap(3);
        palettePanel.setLayout(paletteLayout);
        palettePanel.setBorder(new TitledBorder("Choose one:"));
        palettePanel.setName("Components");
        String[] names = new String[]{"Select", "Move", "Node", "Loop", "Edge", "Path", "ZoomIn", "ZoomOut"};
        String[] tooltip = new String[]{"Select", "Move", "Add Node", "Add Loop", "Add Edge", "Add Path", "Zoom In", "Zoom Out"};
        this.selBorder = new EtchedBorder(0, Color.blue, Color.blue);
        BListener bListener = new BListener();
        this.pButtons = new JButton[tooltip.length];
        for (i = 0; i < this.pButtons.length; ++i) {
            this.pButtons[i] = icons[i] != null ? new JButton("", icons[i + 1]) : new JButton("");
            this.pButtons[i].setName(names[i]);
            this.pButtons[i].setToolTipText(tooltip[i]);
            this.pButtons[i].addActionListener(bListener);
            this.pButtons[i].setFocusable(false);
        }
        if (this.pButtons.length > 0) {
            this.originalBorder = this.pButtons[0].getBorder();
        }
        for (i = 0; i < this.pButtons.length; ++i) {
            palettePanel.add(this.pButtons[i]);
        }
        this.pButtons[0].setBorder(this.selBorder);
        JPanel structurePanel = new JPanel();
        GridLayout strLayout = new GridLayout(structures.length, 1);
        strLayout.setVgap(4);
        structurePanel.setLayout(strLayout);
        this.sButtons = new JButton[5];
        this.sButtons[0] = new JButton(structures[0]);
        this.sButtons[0].setName("TreeChain");
        this.sButtons[0].setToolTipText("Three Chain");
        this.sButtons[0].addActionListener(bListener);
        structurePanel.add(this.sButtons[0]);
        this.sButtons[1] = new JButton(structures[1]);
        this.sButtons[1].setName("FeedForwardLoop");
        this.sButtons[1].setToolTipText("Feed Forward Loop");
        this.sButtons[1].addActionListener(bListener);
        structurePanel.add(this.sButtons[1]);
        this.sButtons[2] = new JButton(structures[2]);
        this.sButtons[2].setName("Bi-Parallel");
        this.sButtons[2].setToolTipText("Bi-Parallel");
        this.sButtons[2].addActionListener(bListener);
        structurePanel.add(this.sButtons[2]);
        this.sButtons[3] = new JButton(structures[3]);
        this.sButtons[3].setName("Bi-Fan");
        this.sButtons[3].setToolTipText("Bi-Fan");
        this.sButtons[3].addActionListener(bListener);
        structurePanel.add(this.sButtons[3]);
        this.sButtons[4] = new JButton(structures[4]);
        this.sButtons[4].setName("MtoN-Fan");
        this.sButtons[4].setToolTipText("m to n");
        this.sButtons[4].addActionListener(bListener);
        structurePanel.add(this.sButtons[4]);
        structurePanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        JScrollPane p = new JScrollPane();
        p.getViewport().add(structurePanel);
        JTabbedPane tabbedPane = new JTabbedPane(1);
        tabbedPane.addTab("Palette", null, palettePanel, "");
        tabbedPane.addTab("Motifs", null, p, "");
        JPanel m = new JPanel(new GridLayout(2, 1, 3, 3));
        m.add(tabbedPane);
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new BorderLayout());
        infoPanel.setBorder(new TitledBorder("Info:"));
        this.infoArea = new JTextArea();
        this.infoArea.setEditable(false);
        this.infoArea.setMinimumSize(new Dimension(160, 130));
        this.infoArea.setFont(new Font("SansSerif", 0, 12));
        this.infoArea.setBorder(new EtchedBorder());
        infoPanel.add((Component)this.infoArea, "Center");
        infoPanel.setMinimumSize(new Dimension(160, 160));
        m.add(infoPanel);
        leftPanel.add((Component)m, "Center");
        JButton pass = new JButton("<html>Pass Query<br> to NetMatch</html>", menu[4]);
        pass.setToolTipText("<html>Clicking on this button the query<br> will be uploaded to NetMatch main windows.</html>");
        pass.addActionListener(this);
        pass.setActionCommand("Pass query to NetMatch");
        leftPanel.add((Component)pass, "South");
        this.getContentPane().add((Component)leftPanel, "West");
        this.statusBar = new JTextField();
        this.statusBar.setBackground(SystemColor.control);
        this.statusBar.setEditable(false);
        this.statusBar.setForeground(Color.BLACK);
        this.statusBar.setBorder(new EtchedBorder());
        this.getContentPane().add((Component)this.statusBar, "South");
        JPanel menubar = new JPanel(new BorderLayout());
        JMenuBar bar = this.createMainMenu();
        menubar.add((Component)bar, "North");
        menubar.add((Component)this.createToolBar(), "South");
        this.getContentPane().add((Component)menubar, "North");
        this.canvas = new QCanvas(this);
        this.getContentPane().add((Component)((Object)this.canvas), "Center");
        PScrollPane scrollPane = new PScrollPane((Component)((Object)this.canvas));
        this.getContentPane().add((Component)scrollPane);
        this.popup = new QPopupMenu(this);
        this.setupMode(0);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 2 - this.getWidth() / 2, screenSize.height / 2 - this.getHeight() / 2);
        this.LastDirectory = ".";
        this.counter = 1;
        this.isSaved = false;
        this.updateStatus();
        this.setVisible(true);
    }

    private JToolBar createToolBar() {
        JToolBar toolbar = new JToolBar();
        JButton b1 = new JButton(this.menu[0]);
        b1.setToolTipText("New query");
        b1.addActionListener(this);
        b1.setActionCommand("New query");
        toolbar.add(b1);
        b1 = new JButton(this.menu[1]);
        b1.setToolTipText("Load query");
        b1.addActionListener(this);
        b1.setActionCommand("Load query...");
        toolbar.add(b1);
        b1 = new JButton(this.menu[2]);
        b1.setToolTipText("Save query");
        b1.addActionListener(this);
        b1.setActionCommand("Save query");
        toolbar.add(b1);
        b1 = new JButton(this.menu[3]);
        b1.setToolTipText("Change query name");
        b1.addActionListener(this);
        b1.setActionCommand("Change query name");
        toolbar.add(b1);
        b1 = new JButton(this.menu[5]);
        b1.setToolTipText("Exit");
        b1.addActionListener(this);
        b1.setActionCommand("Exit");
        toolbar.add(b1);
        toolbar.addSeparator();
        b1 = new JButton(this.menu[6]);
        b1.setToolTipText("Clear");
        b1.addActionListener(this);
        b1.setActionCommand("Clear");
        toolbar.add(b1);
        toolbar.addSeparator();
        b1 = new JButton(this.menu[20]);
        b1.setToolTipText("Quick Help");
        b1.addActionListener(this);
        b1.setActionCommand("Quick Help");
        toolbar.add(b1);
        return toolbar;
    }

    public void setTitleModif() {
        if (!this.queryName.equals("")) {
            this.setTitle(this.title + " - " + this.getShortName(this.queryName) + "*");
        } else {
            this.setTitle(this.title + " - new query*");
        }
    }

    private String getNetworkName(String fullName) {
        int lastP = fullName.lastIndexOf(46);
        int lastS = fullName.lastIndexOf(92);
        return lastP == -1 || lastP < lastS ? fullName.substring(lastS + 1) : fullName.substring(lastS + 1, lastP);
    }

    private String getShortName(String fullName) {
        int lastS = fullName.lastIndexOf(92);
        return fullName.substring(lastS + 1);
    }

    private String getNameWithoutExt(String fullName) {
        int lastP = fullName.lastIndexOf(46);
        int lastS = fullName.lastIndexOf(92);
        return lastP == -1 || lastP < lastS ? fullName : fullName.substring(0, lastP);
    }

    private String addSIFExt(String fullName) {
        return this.getNameWithoutExt(fullName) + ".sif";
    }

    private String addNAExt(String fullName) {
        return this.getNameWithoutExt(fullName) + ".NA";
    }

    private String addEAExt(String fullName) {
        return this.getNameWithoutExt(fullName) + ".EA";
    }

    private void SaveAs() {
        JFileChooser c = new JFileChooser();
        ExampleFileFilter filter = new ExampleFileFilter("sif", "SIF network");
        c.addChoosableFileFilter(filter);
        c.setCurrentDirectory(new File(this.LastDirectory));
        int rVal = c.showSaveDialog(this);
        if (rVal == 0) {
            this.queryName = c.getSelectedFile().getAbsolutePath();
            this.queryName = this.addSIFExt(this.queryName);
            this.saveNetwork(this.queryName);
            this.setTitle(this.title + " - " + this.getShortName(this.queryName));
            this.LastDirectory = c.getSelectedFile().getAbsolutePath();
        }
    }

    public void actionPerformed(ActionEvent e) {
        int rVal;
        ExampleFileFilter filter;
        JFileChooser c;
        String command = e.getActionCommand();
        if (command.equals("Load query...")) {
            this.check();
            this.queryName = "";
            this.isModif = false;
            this.setTitle(this.title + " - new query");
            Network.clean(this.canvas.getNodeLayerReference(), this.canvas.getEdgeLayerReference());
            c = new JFileChooser();
            c.setCurrentDirectory(new File(this.LastDirectory));
            filter = new ExampleFileFilter("sif", "SIF network");
            c.addChoosableFileFilter(filter);
            rVal = c.showOpenDialog(this);
            if (rVal == 0) {
                this.queryName = c.getSelectedFile().getAbsolutePath();
                this.loadNetwork(c.getSelectedFile().getAbsolutePath());
                this.setTitle(this.title + " - " + this.getShortName(this.queryName));
                this.LastDirectory = c.getSelectedFile().getAbsolutePath();
                this.isSaved = true;
            }
        }
        if (command.equals("Load node attributes...")) {
            c = new JFileChooser();
            c.setCurrentDirectory(new File(this.LastDirectory));
            filter = new ExampleFileFilter("NA", "SIF Node Attributes");
            c.addChoosableFileFilter(filter);
            rVal = c.showOpenDialog(this);
            if (rVal == 0) {
                this.loadNodeAttributes(c.getSelectedFile().getAbsolutePath());
                this.LastDirectory = c.getSelectedFile().getAbsolutePath();
                this.isModif = true;
                this.setTitleModif();
            }
        }
        if (command.equals("Load edge attributes...")) {
            c = new JFileChooser();
            c.setCurrentDirectory(new File(this.LastDirectory));
            filter = new ExampleFileFilter("EA", "SIF Edge Attributes");
            c.addChoosableFileFilter(filter);
            rVal = c.showOpenDialog(this);
            if (rVal == 0) {
                this.loadEdgeAttributes(c.getSelectedFile().getAbsolutePath());
                this.LastDirectory = c.getSelectedFile().getAbsolutePath();
                this.isModif = true;
                this.setTitleModif();
            }
        }
        if (command.equals("New query")) {
            this.check();
            this.queryName = "";
            this.setTitle(this.title + " - new query");
            this.isModif = false;
            Network.clean(this.canvas.getNodeLayerReference(), this.canvas.getEdgeLayerReference());
            this.isSaved = false;
            this.updateStatus();
        } else if (command.equals("Save query")) {
            if (this.canvas.getNodeLayerReference().getAllNodes().size() > 1) {
                if (this.queryName.equals("")) {
                    this.SaveAs();
                } else {
                    this.saveNetwork(this.queryName);
                    this.setTitle(this.title + " - " + this.getShortName(this.queryName));
                }
                this.isModif = false;
            }
        } else if (command.equals("Save query as...")) {
            if (this.canvas.getNodeLayerReference().getAllNodes().size() > 1) {
                this.SaveAs();
            }
            this.isModif = false;
        } else if (command.equals("Save node attributes as...")) {
            if (this.canvas.getNodeLayerReference().getAllNodes().size() > 1) {
                c = new JFileChooser();
                filter = new ExampleFileFilter("NA", "SIF Node Attributes");
                c.addChoosableFileFilter(filter);
                c.setCurrentDirectory(new File(this.LastDirectory));
                rVal = c.showSaveDialog(this);
                if (rVal == 0) {
                    this.saveNodeAttributes(this.addNAExt(c.getSelectedFile().getAbsolutePath()));
                    this.LastDirectory = c.getSelectedFile().getAbsolutePath();
                }
            }
        } else if (command.equals("Save edge attributes as...")) {
            if (this.canvas.getNodeLayerReference().getAllNodes().size() > 1) {
                c = new JFileChooser();
                filter = new ExampleFileFilter("EA", "SIF Edge Attributes");
                c.addChoosableFileFilter(filter);
                c.setCurrentDirectory(new File(this.LastDirectory));
                rVal = c.showSaveDialog(this);
                if (rVal == 0) {
                    this.saveEdgeAttributes(this.addEAExt(c.getSelectedFile().getAbsolutePath()));
                    this.LastDirectory = c.getSelectedFile().getAbsolutePath();
                }
            }
        } else if (command.equals("Change query name")) {
            String name = JOptionPane.showInputDialog(this, (Object)"Enter a name for query:");
            if (name != null) {
                this.queryName = name;
                this.setTitle(this.title + " - " + this.getShortName(this.queryName));
                this.isSaved = false;
            }
        } else if (command.equals("Pass query to NetMatch")) {
            if (this.canvas.getNodeLayerReference().getAllNodes().size() > 1) {
                this.passOptions();
            }
        } else if (command.equals("Clear")) {
            Network.clean(this.canvas.getNodeLayerReference(), this.canvas.getEdgeLayerReference());
            this.updateStatus();
            this.isModif = false;
        } else if (command.equals("Quick Help")) {
            netMatchQuickHelp h = new netMatchQuickHelp("NetMatch Quick Help", this.menu[15]);
            h.setVisible(true);
        } else if (command.equals("Exit")) {
            this.exit();
        }
    }

    private void check() {
        if (this.isModif) {
            String nn = this.queryName.equals("") ? "new query" : this.getShortName(this.queryName);
            int r = JOptionPane.showConfirmDialog(this, "Do you want to save " + nn, "Graph Editor", 0);
            if (r == 0) {
                if (!this.isSaved) {
                    this.SaveAs();
                } else {
                    this.saveNetwork(this.queryName);
                }
            }
        }
    }

    private void saveNetwork(String fullName) {
        try {
            FileWriter writer = new FileWriter(fullName);
            Network.saveStructure(writer, this.canvas);
            String name = this.getNameWithoutExt(fullName);
            writer = new FileWriter(name + ".NA");
            Network.saveNodeAttr(writer, this.canvas.getNodeLayerReference());
            writer = new FileWriter(name + ".EA");
            Network.saveEdgeAttr(writer, this.canvas.getEdgeLayerReference());
            this.isSaved = true;
        }
        catch (IOException e) {
            System.err.println("Can't open the file: " + fullName);
        }
    }

    private void saveNodeAttributes(String fullName) {
        try {
            FileWriter writer = new FileWriter(fullName);
            Network.saveNodeAttr(writer, this.canvas.getNodeLayerReference());
        }
        catch (IOException e) {
            System.err.println("Can't open the file: " + fullName);
        }
    }

    private void saveEdgeAttributes(String fullName) {
        try {
            FileWriter writer = new FileWriter(fullName);
            Network.saveEdgeAttr(writer, this.canvas.getEdgeLayerReference());
        }
        catch (IOException e) {
            System.err.println("Can't open the file: " + fullName);
        }
    }

    private boolean loadNetwork(String fullName) {
        FileReader reader;
        Network.clean(this.canvas.getNodeLayerReference(), this.canvas.getEdgeLayerReference());
        try {
            reader = new FileReader(fullName);
            Network.loadStructure(reader, this.canvas);
            this.updateStatus();
        }
        catch (FileNotFoundException e) {
            System.err.println("Can't open the file: " + fullName);
        }
        catch (InvalidSIFException e) {
            System.err.println("Network structure file: " + fullName + "\n" + e.getMessage());
        }
        String name = this.getNameWithoutExt(fullName);
        try {
            reader = new FileReader(name + ".NA");
            Network.loadNodeAttr(reader, this.canvas.getNodeLayerReference());
        }
        catch (FileNotFoundException e) {
        }
        catch (InvalidSIFException e) {
            System.err.println("Node labels file: " + name + "\n" + e.getMessage());
        }
        try {
            reader = new FileReader(name + ".EA");
            Network.loadEdgeLoopAttr(reader, this.canvas.getEdgeLayerReference());
        }
        catch (FileNotFoundException e) {
        }
        catch (InvalidSIFException e) {
            System.err.println("Edge labels file: " + name + "\n" + e.getMessage());
        }
        return true;
    }

    private void loadNodeAttributes(String fullName) {
        try {
            FileReader reader = new FileReader(fullName);
            Network.loadNodeAttr(reader, this.canvas.getNodeLayerReference());
        }
        catch (FileNotFoundException e) {
        }
        catch (InvalidSIFException e) {
            System.err.println("Node labels file: " + fullName + "\n" + e.getMessage());
        }
    }

    private void loadEdgeAttributes(String fullName) {
        try {
            FileReader reader = new FileReader(fullName);
            Network.loadEdgeLoopAttr(reader, this.canvas.getEdgeLayerReference());
        }
        catch (FileNotFoundException e) {
        }
        catch (InvalidSIFException e) {
            System.err.println("Node labels file: " + fullName + "\n" + e.getMessage());
        }
    }

    private GraphLoader loadGraphFromQTool(PLayer nodeLayer, PLayer edgeLayer) throws Exception {
        PNode candNode;
        Hashtable<String, Integer> names = new Hashtable<String, Integer>();
        int i = 0;
        int id = 0;
        this.recipient.clearPaths();
        this.recipient.setQueryApproximate(false);
        GraphLoader loader = new GraphLoader(null);
        Iterator it = nodeLayer.getAllNodes().iterator();
        while (it.hasNext()) {
            candNode = (PNode)it.next();
            if (!(candNode instanceof QNode)) continue;
            QNode node = (QNode)candNode;
            String name1 = node.getId();
            String name1Attr = node.getAttr();
            if (names.containsKey(name1)) continue;
            names.put(name1, new Integer(i++));
            loader.InsertNode(name1Attr, id++, false);
        }
        it = edgeLayer.getAllNodes().iterator();
        while (it.hasNext()) {
            String name2;
            String name1;
            QNode dest;
            QNode source;
            String type;
            PPath edge;
            candNode = (PNode)it.next();
            if (candNode instanceof QEdge) {
                edge = (QEdge)candNode;
                type = edge.getAttr();
                source = edge.getSource();
                dest = edge.getTarget();
                name1 = source.getId();
                name2 = dest.getId();
                loader.InsertEdge((Integer)names.get(name1), (Integer)names.get(name2), type, false);
                if (Common.DIRECTED) continue;
                loader.InsertEdge((Integer)names.get(name2), (Integer)names.get(name1), type, false);
                continue;
            }
            if (candNode instanceof QLoop) {
                edge = (QLoop)candNode;
                type = edge.getAttr();
                QNode node = edge.getOwner();
                String name12 = node.getId();
                String name22 = name12 + "[SELFEDGE]";
                String name1Attr = node.getAttr();
                String name2Attr = name1Attr + "[SELFEDGE]";
                if (!names.containsKey(name22)) {
                    names.put(name22, new Integer(i++));
                    loader.InsertNode(name2Attr, id++, true);
                }
                loader.InsertEdge((Integer)names.get(name12), (Integer)names.get(name22), type, true);
                if (Common.DIRECTED) continue;
                loader.InsertEdge((Integer)names.get(name22), (Integer)names.get(name12), type, true);
                continue;
            }
            if (!(candNode instanceof QPath)) continue;
            this.recipient.setQueryApproximate(true);
            QPath p = (QPath)candNode;
            type = p.getAttr();
            source = p.getSource();
            dest = p.getTarget();
            name1 = source.getId();
            name2 = dest.getId();
            Integer index1 = (Integer)names.get(name1);
            Integer index2 = (Integer)names.get(name2);
            this.recipient.addQPath(index1 + "," + index2 + "," + type);
        }
        return loader;
    }

    private JMenuBar createMainMenu() {
        JMenu[] menus = new JMenu[]{new JMenu("Query"), new JMenu("Edit")};
        JMenuItem[] editItems = new JMenuItem[]{new JMenuItem("Clear", this.menu[13])};
        JMenuBar jm = new JMenuBar();
        JMenuItem item = new JMenuItem("New query", this.menu[7]);
        item.addActionListener(this);
        menus[0].add(item);
        JMenu loadMenu = new JMenu("Load");
        loadMenu.setIcon(this.menu[8]);
        item = new JMenuItem("Load query...");
        item.addActionListener(this);
        loadMenu.add(item);
        item = new JMenuItem("Load node attributes...");
        item.addActionListener(this);
        loadMenu.add(item);
        item = new JMenuItem("Load edge attributes...");
        item.addActionListener(this);
        loadMenu.add(item);
        menus[0].add(loadMenu);
        JMenu saveAsMenu = new JMenu("Save As...");
        saveAsMenu.setIcon(this.menu[9]);
        item = new JMenuItem("Save query as...");
        item.addActionListener(this);
        saveAsMenu.add(item);
        item = new JMenuItem("Save node attributes as...");
        item.addActionListener(this);
        saveAsMenu.add(item);
        item = new JMenuItem("Save edge attributes as...");
        item.addActionListener(this);
        saveAsMenu.add(item);
        menus[0].add(saveAsMenu);
        item = new JMenuItem("Save query", this.menu[9]);
        item.addActionListener(this);
        menus[0].add(item);
        item = new JMenuItem("Change query name", this.menu[10]);
        item.addActionListener(this);
        menus[0].add(item);
        item = new JMenuItem("Pass query to NetMatch", this.menu[11]);
        item.addActionListener(this);
        menus[0].add(item);
        menus[0].addSeparator();
        item = new JMenuItem("Exit", this.menu[12]);
        item.addActionListener(this);
        menus[0].add(item);
        this.addItemsToMenu(menus[1], editItems);
        for (int i = 0; i < menus.length; ++i) {
            jm.add(menus[i]);
        }
        return jm;
    }

    private void addItemsToMenu(JMenu menu, JMenuItem[] items) {
        for (int i = 0; i < items.length; ++i) {
            items[i].addActionListener(this);
            menu.add(items[i]);
        }
    }

    private void setupMode(int i) {
        switch (i) {
            case 0: {
                this.canvas.setupSelectorMode();
                break;
            }
            case 1: {
                this.canvas.setupMoveMode();
                break;
            }
            case 2: {
                this.canvas.setupNodeCreatorMode();
                break;
            }
            case 3: {
                this.canvas.setupLoopCreatorMode();
                break;
            }
            case 4: {
                this.canvas.setupEdgeCreatorMode();
                break;
            }
            case 5: {
                this.canvas.setupPathCreatorMode();
            }
        }
    }

    public void exit() {
        if (this.isModif) {
            String nn = this.queryName.equals("") ? "new query" : this.getShortName(this.queryName);
            int r = JOptionPane.showConfirmDialog(this, "Do you want to save " + nn, "Graph Editor", 0);
            if (r == 0) {
                if (!this.isSaved) {
                    this.SaveAs();
                } else {
                    this.saveNetwork(this.queryName);
                }
            }
        }
        this.isModif = false;
        this.recipient.deattachRecipient();
        this.setVisible(false);
        this.dispose();
    }

    public void windowClosing(WindowEvent e) {
        this.exit();
    }

    void updateStatus() {
        this.statusBar.setText("Nodes: " + Network.nCount + " Edges: " + Network.eCount + " Paths: " + Network.pCount + " Loops: " + Network.lCount + "\n");
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    private void passOptions() {
        if (this.queryName.equals("")) {
            this.queryName = "unnamed_" + this.counter++ + ".sif";
        }
        Object[] message = new Object[7];
        message[0] = "Your query, named \"" + this.getShortName(this.queryName) + "\", is now available in the main NetMatch window. Please choose one of the following options:";
        ButtonGroup g = new ButtonGroup();
        JRadioButton c1 = new JRadioButton("Close editor and go back to NetMatch.", true);
        JRadioButton c2 = new JRadioButton("Draw another query.", false);
        JRadioButton c3 = new JRadioButton("Leave editor open for later query editing.", false);
        g.add(c1);
        g.add(c2);
        g.add(c3);
        JCheckBox s = new JCheckBox("Save query in a file.");
        s.setSelected(true);
        message[1] = c1;
        message[2] = c2;
        message[3] = c3;
        message[4] = new JLabel(" ");
        message[5] = new JLabel(" ");
        message[6] = s;
        Object[] options = new String[]{"Ok", "Cancel"};
        int val = JOptionPane.showOptionDialog(this, message, "NetMatch", -1, 1, null, options, options[0]);
        if (val != 1) {
            if (s.isSelected()) {
                if (!this.isSaved) {
                    this.SaveAs();
                } else {
                    this.saveNetwork(this.queryName);
                }
                this.isModif = false;
                this.setTitle(this.title + " - " + this.getShortName(this.queryName));
            }
            if (this.recipient != null) {
                try {
                    GraphLoader gg = this.loadGraphFromQTool(this.canvas.getNodeLayerReference(), this.canvas.getEdgeLayerReference());
                    this.recipient.addQueryStructure(this.getNetworkName(this.queryName), gg);
                }
                catch (Exception ex) {
                    System.err.println("Unable to create NetMatch network!");
                }
            }
            if (c1.isSelected()) {
                this.recipient.deattachRecipient();
                this.setVisible(false);
                this.dispose();
            } else if (c2.isSelected()) {
                this.queryName = "";
                this.setTitle(this.title + " - new query");
                this.isModif = false;
                Network.clean(this.canvas.getNodeLayerReference(), this.canvas.getEdgeLayerReference());
                this.updateStatus();
            }
        }
    }

    class BListener
    implements ActionListener {
        BListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int i;
            JButton bt = (JButton)e.getSource();
            if (bt.getName().equals("ZoomIn")) {
                Point2D center = QToolFrame.this.canvas.getCamera().getViewBounds().getCenter2D();
                QToolFrame.this.canvas.getCamera().scaleViewAboutPoint(2.0, center.getX(), center.getY());
                return;
            }
            if (bt.getName().equals("ZoomOut")) {
                Point2D center = QToolFrame.this.canvas.getCamera().getViewBounds().getCenter2D();
                QToolFrame.this.canvas.getCamera().scaleViewAboutPoint(0.5, center.getX(), center.getY());
                return;
            }
            for (i = 0; i < QToolFrame.this.pButtons.length; ++i) {
                QToolFrame.this.pButtons[i].setBorder(QToolFrame.this.originalBorder);
                if (QToolFrame.this.pButtons[i] != bt) continue;
                bt.setBorder(QToolFrame.this.selBorder);
                QToolFrame.this.setupMode(i);
            }
            for (i = 0; i < QToolFrame.this.sButtons.length; ++i) {
                QToolFrame.this.sButtons[i].setBorder(QToolFrame.this.originalBorder);
                if (QToolFrame.this.sButtons[i] != bt) continue;
                bt.setBorder(QToolFrame.this.selBorder);
                QToolFrame.this.canvas.setupStructure(i);
            }
        }
    }
}

