/*
 * Decompiled with CFR 0.152.
 */
package netmatch.qtool;

import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import netmatch.qtool.Network;
import netmatch.qtool.QEdge;
import netmatch.qtool.QElement;
import netmatch.qtool.QLoop;
import netmatch.qtool.QPath;
import netmatch.qtool.QText;

public class QNode
extends PPath
implements PropertyChangeListener,
QElement {
    public static final int NODE_INIT_WIDTH = 30;
    public static final int NODE_INIT_HEIGHT = 30;
    static final Color SELECTED_NODE_COLOR = new Color(255, 255, 0);
    static final Color NODE_COLOR = new Color(255, 153, 153);
    private String id;
    private String attr = "?";
    private QText text;
    private ArrayList edges = new ArrayList();
    private ArrayList paths = new ArrayList();
    private ArrayList loops = new ArrayList();

    public QNode(float x, float y, String id) {
        super((Shape)new Ellipse2D.Float(x - 15.0f, y - 15.0f, 30.0f, 30.0f));
        this.id = id;
        this.setPaint(NODE_COLOR);
        this.text = new QText(this, this.attr);
        this.addPropertyChangeListener("fullBounds", this);
    }

    public String getId() {
        return this.id;
    }

    public boolean isSingle() {
        return this.loops.size() + this.edges.size() + this.paths.size() == 0;
    }

    public ArrayList getEdges() {
        return this.edges;
    }

    public ArrayList getPaths() {
        return this.paths;
    }

    public void addToLayer(PLayer layer) {
        layer.addChild((PNode)this);
        layer.addChild((PNode)this.text);
    }

    public void delete(PLayer nodeLayer, PLayer edgeLayer) {
        int i;
        nodeLayer.removeChild((PNode)this.text);
        for (i = 0; i < this.loops.size(); ++i) {
            edgeLayer.removeChild((PNode)((QLoop)this.loops.get(i)));
            --Network.lCount;
        }
        for (i = 0; i < this.edges.size(); ++i) {
            QEdge edge = (QEdge)this.edges.get(i);
            if (edge.getSource() == this) {
                edge.getTarget().removeEdge(edge);
            } else {
                edge.getSource().removeEdge(edge);
            }
            --Network.eCount;
        }
        for (i = 0; i < this.edges.size(); ++i) {
            edgeLayer.removeChild((PNode)((QEdge)this.edges.get(i)));
        }
        for (i = 0; i < this.paths.size(); ++i) {
            QPath path = (QPath)this.paths.get(i);
            if (path.getSource() == this) {
                path.getTarget().removePath(path);
            } else {
                path.getSource().removePath(path);
            }
            --Network.pCount;
        }
        for (i = 0; i < this.paths.size(); ++i) {
            edgeLayer.removeChild((PNode)((QPath)this.paths.get(i)));
        }
        nodeLayer.removeChild((PNode)this);
    }

    public String getInfo() {
        int degree = this.edges.size() + this.paths.size();
        return "Node:\nId: " + this.id + "\n" + "Attribute: " + this.attr + "\n" + "Degree: " + degree + "\n" + "Loops: " + this.loops.size() + "\n";
    }

    public void decorateSelect() {
        this.setPaint(SELECTED_NODE_COLOR);
    }

    public void undecorateSelect() {
        this.setPaint(NODE_COLOR);
    }

    public void addEdge(QEdge edge) {
        int val = 0;
        if (edge.getSource() == this) {
            val = this.calcValence(edge.getTarget());
        }
        this.edges.add(edge);
        if (edge.getSource() == this) {
            edge.setValence(val);
        }
    }

    public void removeEdge(QEdge edge) {
        if (!this.edges.contains(edge)) {
            return;
        }
        this.edges.remove(edge);
        if (edge.getSource() == this) {
            this.updateValence(edge.getTarget(), edge.getValence());
        }
        this.update();
    }

    public void addPath(QPath path) {
        int val = 0;
        if (path.getSource() == this) {
            val = this.calcValence(path.getTarget());
        }
        this.paths.add(path);
        if (path.getSource() == this) {
            path.setValence(val);
        }
    }

    public void removePath(QPath path) {
        if (!this.paths.contains(path)) {
            return;
        }
        this.paths.remove(path);
        if (path.getSource() == this) {
            this.updateValence(path.getTarget(), path.getValence());
        }
        this.update();
    }

    public void addLoop(QLoop loop) {
        int val = this.calcLoopValence();
        this.loops.add(loop);
        loop.setValence(val);
    }

    public void removeLoop(QLoop loop) {
        if (!this.loops.contains(loop)) {
            return;
        }
        this.loops.remove(loop);
        this.updateLoopValence(loop.getValence());
        this.update();
    }

    public void update() {
        int i;
        this.text.update();
        for (i = 0; i < this.loops.size(); ++i) {
            ((QLoop)this.loops.get(i)).update();
        }
        for (i = 0; i < this.edges.size(); ++i) {
            ((QEdge)this.edges.get(i)).update();
        }
        for (i = 0; i < this.paths.size(); ++i) {
            ((QPath)this.paths.get(i)).update();
        }
    }

    public void resizeToText() {
        double h = this.text.getFullBoundsReference().getHeight();
        double w = this.text.getFullBoundsReference().getWidth();
        if (this.getFullBoundsReference().getHeight() < h * 1.2) {
            this.setHeight(h * 1.2);
        }
        if (this.getFullBoundsReference().getWidth() < w * 1.2) {
            this.setWidth(w * 1.2);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.update();
    }

    public void setAttr(String attr) {
        this.attr = attr;
        this.text.setText(attr);
        this.resizeToText();
    }

    public String getAttr() {
        return this.attr;
    }

    private int calcValence(QNode target) {
        int i;
        int v = 0;
        for (i = 0; i < this.edges.size(); ++i) {
            QEdge edge = (QEdge)this.edges.get(i);
            if (edge.getTarget() != target && (edge.getTarget() != this || edge.getSource() != target)) continue;
            ++v;
        }
        for (i = 0; i < this.paths.size(); ++i) {
            QPath path = (QPath)this.paths.get(i);
            if (path.getTarget() != target && (path.getTarget() != this || path.getSource() != target)) continue;
            ++v;
        }
        return v;
    }

    private void updateValence(QNode target, int val) {
        int i;
        for (i = 0; i < this.edges.size(); ++i) {
            QEdge edge = (QEdge)this.edges.get(i);
            if (edge.getTarget() != target && (edge.getTarget() != this || edge.getSource() != target) || edge.getValence() <= val) continue;
            edge.setValence(edge.getValence() - 1);
        }
        for (i = 0; i < this.paths.size(); ++i) {
            QPath path = (QPath)this.paths.get(i);
            if (path.getTarget() != target && (path.getTarget() != this || path.getSource() != target) || path.getValence() <= val) continue;
            path.setValence(path.getValence() - 1);
        }
    }

    private int calcLoopValence() {
        return this.loops.size();
    }

    private void updateLoopValence(int val) {
        for (int i = 0; i < this.loops.size(); ++i) {
            QLoop loop = (QLoop)this.loops.get(i);
            if (loop.getValence() <= val) continue;
            loop.setValence(loop.getValence() - 1);
        }
    }
}

