/*
 * Decompiled with CFR 0.152.
 */
package netmatch.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.tree.DefaultMutableTreeNode;

public class netMatchHelp
extends JFrame
implements ActionListener,
WindowListener,
HyperlinkListener,
TreeSelectionListener {
    private final int WIDTH = 1000;
    private final int HEIGHT = 630;
    private JEditorPane editor;

    public static void main(String[] args) {
        netMatchHelp f = new netMatchHelp("NetMatch Help", null);
        f.setVisible(true);
    }

    public netMatchHelp(String title, ImageIcon img) {
        this.setTitle(title);
        if (img != null) {
            this.setIconImage(img.getImage());
        }
        this.addWindowListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel principale = new JPanel(new BorderLayout());
        principale.setPreferredSize(new Dimension(1000, 630));
        JMenuBar menuBar = this.createMenuBar();
        principale.add((Component)menuBar, "North");
        JPanel left = new JPanel(new BorderLayout());
        left.add((Component)this.createTree(), "Center");
        JPanel right = new JPanel(new BorderLayout());
        JScrollPane scroller = new JScrollPane();
        JViewport vp = scroller.getViewport();
        this.editor = this.createPage("resources/index.html");
        vp.add(this.editor);
        right.add((Component)scroller, "Center");
        JSplitPane splitPane = new JSplitPane(1, left, right);
        splitPane.setOneTouchExpandable(true);
        splitPane.setContinuousLayout(true);
        splitPane.setDividerLocation(200);
        principale.add((Component)splitPane, "Center");
        this.getContentPane().add((Component)principale, "Center");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 2 - this.getWidth() / 2, screenSize.height / 2 - this.getHeight() / 2);
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem i = new JMenuItem("Exit");
        i.addActionListener(this);
        fileMenu.add(i);
        menuBar.add(fileMenu);
        return menuBar;
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("Exit")) {
            this.processEvent(new WindowEvent(this, 201));
        }
    }

    public void windowClosing(WindowEvent e) {
        if (e.getSource() != this) {
            return;
        }
        Window window = e.getWindow();
        if (window.equals(this)) {
            this.setVisible(false);
            this.dispose();
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    private URL getPage(String page) {
        return this.getClass().getResource(page);
    }

    private JEditorPane createPage(String path) {
        URL url = this.getPage(path);
        try {
            if (url != null) {
                JEditorPane html = new JEditorPane(url);
                html.setEditable(false);
                html.addHyperlinkListener(this);
                return html;
            }
        }
        catch (IOException e) {
            System.err.println("Failed to laod:" + path);
        }
        return null;
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (e instanceof HTMLFrameHyperlinkEvent) {
                ((HTMLDocument)this.editor.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)e);
            } else {
                try {
                    this.editor.setPage(e.getURL());
                }
                catch (IOException ioe) {
                    System.out.println("IOE: " + ioe);
                }
            }
        }
    }

    public JScrollPane createTree() {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("NetMatch Help");
        DefaultMutableTreeNode introduction = new DefaultMutableTreeNode("Introduction");
        DefaultMutableTreeNode installation = new DefaultMutableTreeNode("Installation");
        DefaultMutableTreeNode usage = new DefaultMutableTreeNode("Usage");
        DefaultMutableTreeNode example = new DefaultMutableTreeNode("NetMatch by Example");
        DefaultMutableTreeNode bug = new DefaultMutableTreeNode("Bugs report");
        top.add(introduction);
        top.add(installation);
        top.add(usage);
        top.add(example);
        top.add(bug);
        DefaultMutableTreeNode loadNetwork = new DefaultMutableTreeNode("Load a Network/Query");
        DefaultMutableTreeNode loadQuery = new DefaultMutableTreeNode("NetMatch Options");
        DefaultMutableTreeNode run = new DefaultMutableTreeNode("View Results");
        DefaultMutableTreeNode draw = new DefaultMutableTreeNode("Query Drawing tool");
        DefaultMutableTreeNode wiz = new DefaultMutableTreeNode("Using wizard");
        usage.add(loadNetwork);
        usage.add(loadQuery);
        usage.add(run);
        usage.add(draw);
        usage.add(wiz);
        DefaultMutableTreeNode es1 = new DefaultMutableTreeNode("Example 1");
        DefaultMutableTreeNode es2 = new DefaultMutableTreeNode("Example 2");
        DefaultMutableTreeNode es3 = new DefaultMutableTreeNode("Example 3");
        example.add(es1);
        example.add(es2);
        example.add(es3);
        JTree tree = new JTree(top){

            public Insets getInsets() {
                return new Insets(5, 5, 5, 5);
            }
        };
        tree.addTreeSelectionListener(this);
        return new JScrollPane(tree);
    }

    public void valueChanged(TreeSelectionEvent e) {
        String n = e.getPath().getLastPathComponent().toString();
        try {
            if (n.equals("NetMatch Help")) {
                this.editor.setPage(this.getPage("resources/index.html"));
            } else if (n.equals("Introduction")) {
                this.editor.setPage(this.getPage("resources/introduction.html"));
            } else if (n.equals("Installation")) {
                this.editor.setPage(this.getPage("resources/installation.html"));
            } else if (n.equals("Load a Network/Query")) {
                this.editor.setPage(this.getPage("resources/network_load.html"));
            } else if (n.equals("NetMatch Options")) {
                this.editor.setPage(this.getPage("resources/network_option.html"));
            } else if (n.equals("View Results")) {
                this.editor.setPage(this.getPage("resources/network_view.html"));
            } else if (n.equals("Query Drawing tool")) {
                this.editor.setPage(this.getPage("resources/draw.html"));
            } else if (n.equals("Using wizard")) {
                this.editor.setPage(this.getPage("resources/wizard.html"));
            } else if (n.equals("Example 1")) {
                this.editor.setPage(this.getPage("resources/example.html"));
            } else if (n.equals("Example 2")) {
                this.editor.setPage(this.getPage("resources/example2.html"));
            } else if (n.equals("Example 3")) {
                this.editor.setPage(this.getPage("resources/example3.html"));
            } else if (n.equals("Bugs report")) {
                this.editor.setPage(this.getPage("resources/bugs.html"));
            }
        }
        catch (IOException ex) {
            System.err.println("Failed to load page!");
        }
    }
}

