/*
 * Decompiled with CFR 0.152.
 */
package csplugins.mcode;

public class MCODEParameterSet {
    public static String NETWORK = "network";
    public static String SELECTION = "selection";
    private String scope;
    private Integer[] selectedNodes;
    private boolean includeLoops;
    private int degreeCutoff;
    private int kCore;
    private boolean optimize;
    private int maxDepthFromStart;
    private double nodeScoreCutoff;
    private boolean fluff;
    private boolean haircut;
    private double fluffNodeDensityCutoff;
    private int defaultRowHeight;

    public MCODEParameterSet() {
        this.setDefaultParams();
        this.defaultRowHeight = 80;
    }

    public MCODEParameterSet(String string, Integer[] integerArray, boolean bl, int n, int n2, boolean bl2, int n3, double d, boolean bl3, boolean bl4, double d2) {
        this.setAllAlgorithmParams(string, integerArray, bl, n, n2, bl2, n3, d, bl3, bl4, d2);
        this.defaultRowHeight = 80;
    }

    public void setDefaultParams() {
        this.setAllAlgorithmParams(NETWORK, new Integer[0], false, 2, 2, false, 100, 0.2, false, true, 0.1);
    }

    public void setAllAlgorithmParams(String string, Integer[] integerArray, boolean bl, int n, int n2, boolean bl2, int n3, double d, boolean bl3, boolean bl4, double d2) {
        this.scope = string;
        this.selectedNodes = integerArray;
        this.includeLoops = bl;
        this.degreeCutoff = n;
        this.kCore = n2;
        this.optimize = bl2;
        this.maxDepthFromStart = n3;
        this.nodeScoreCutoff = d;
        this.fluff = bl3;
        this.haircut = bl4;
        this.fluffNodeDensityCutoff = d2;
    }

    public MCODEParameterSet copy() {
        MCODEParameterSet mCODEParameterSet = new MCODEParameterSet();
        mCODEParameterSet.setScope(this.scope);
        mCODEParameterSet.setSelectedNodes(this.selectedNodes);
        mCODEParameterSet.setIncludeLoops(this.includeLoops);
        mCODEParameterSet.setDegreeCutoff(this.degreeCutoff);
        mCODEParameterSet.setKCore(this.kCore);
        mCODEParameterSet.setOptimize(this.optimize);
        mCODEParameterSet.setMaxDepthFromStart(this.maxDepthFromStart);
        mCODEParameterSet.setNodeScoreCutoff(this.nodeScoreCutoff);
        mCODEParameterSet.setFluff(this.fluff);
        mCODEParameterSet.setHaircut(this.haircut);
        mCODEParameterSet.setFluffNodeDensityCutoff(this.fluffNodeDensityCutoff);
        mCODEParameterSet.setDefaultRowHeight(this.defaultRowHeight);
        return mCODEParameterSet;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String string) {
        this.scope = string;
    }

    public Integer[] getSelectedNodes() {
        return this.selectedNodes;
    }

    public void setSelectedNodes(Integer[] integerArray) {
        this.selectedNodes = integerArray;
    }

    public boolean isIncludeLoops() {
        return this.includeLoops;
    }

    public void setIncludeLoops(boolean bl) {
        this.includeLoops = bl;
    }

    public int getDegreeCutoff() {
        return this.degreeCutoff;
    }

    public void setDegreeCutoff(int n) {
        this.degreeCutoff = n;
    }

    public int getKCore() {
        return this.kCore;
    }

    public void setKCore(int n) {
        this.kCore = n;
    }

    public void setOptimize(boolean bl) {
        this.optimize = bl;
    }

    public boolean isOptimize() {
        return this.optimize;
    }

    public int getMaxDepthFromStart() {
        return this.maxDepthFromStart;
    }

    public void setMaxDepthFromStart(int n) {
        this.maxDepthFromStart = n;
    }

    public double getNodeScoreCutoff() {
        return this.nodeScoreCutoff;
    }

    public void setNodeScoreCutoff(double d) {
        this.nodeScoreCutoff = d;
    }

    public boolean isFluff() {
        return this.fluff;
    }

    public void setFluff(boolean bl) {
        this.fluff = bl;
    }

    public boolean isHaircut() {
        return this.haircut;
    }

    public void setHaircut(boolean bl) {
        this.haircut = bl;
    }

    public double getFluffNodeDensityCutoff() {
        return this.fluffNodeDensityCutoff;
    }

    public void setFluffNodeDensityCutoff(double d) {
        this.fluffNodeDensityCutoff = d;
    }

    public int getDefaultRowHeight() {
        return this.defaultRowHeight;
    }

    public void setDefaultRowHeight(int n) {
        this.defaultRowHeight = n;
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("   Network Scoring:" + string + "      Include Loops: " + this.includeLoops + "  Degree Cutoff: " + this.degreeCutoff + string);
        stringBuffer.append("   Cluster Finding:" + string + "      Node Score Cutoff: " + this.nodeScoreCutoff + "  Haircut: " + this.haircut + "  Fluff: " + this.fluff + (this.fluff ? "  Fluff Density Cutoff " + this.fluffNodeDensityCutoff : "") + "  K-Core: " + this.kCore + "  Max. Depth from Seed: " + this.maxDepthFromStart + string);
        return stringBuffer.toString();
    }
}

