/*
 * Decompiled with CFR 0.152.
 */
package csplugins.mcode;

import csplugins.mcode.MCODELoader;
import csplugins.mcode.NodeDistances;
import giny.model.Node;
import giny.view.GraphView;
import giny.view.NodeView;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class SpringEmbeddedLayouter {
    public static final int DEFAULT_NUM_LAYOUT_PASSES = 2;
    public static final double DEFAULT_AVERAGE_ITERATIONS_PER_NODE = 20.0;
    public static final double[] DEFAULT_NODE_DISTANCE_SPRING_SCALARS = new double[]{1.0, 1.0};
    public static final double DEFAULT_NODE_DISTANCE_STRENGTH_CONSTANT = 15.0;
    public static final double DEFAULT_NODE_DISTANCE_REST_LENGTH_CONSTANT = 200.0;
    public static final double DEFAULT_DISCONNECTED_NODE_DISTANCE_SPRING_STRENGTH = 0.05;
    public static final double DEFAULT_DISCONNECTED_NODE_DISTANCE_SPRING_REST_LENGTH = 2500.0;
    public static final double[] DEFAULT_ANTICOLLISION_SPRING_SCALARS = new double[]{0.0, 1.0};
    public static final double DEFAULT_ANTICOLLISION_SPRING_STRENGTH = 100.0;
    protected int numLayoutPasses = 2;
    protected double averageIterationsPerNode = 20.0;
    protected double[] nodeDistanceSpringScalars = DEFAULT_NODE_DISTANCE_SPRING_SCALARS;
    protected double nodeDistanceStrengthConstant = 15.0;
    protected double nodeDistanceRestLengthConstant = 200.0;
    protected double disconnectedNodeDistanceSpringStrength = 0.05;
    protected double disconnectedNodeDistanceSpringRestLength = 2500.0;
    protected double[][] nodeDistanceSpringStrengths;
    protected double[][] nodeDistanceSpringRestLengths;
    protected double[] anticollisionSpringScalars = DEFAULT_ANTICOLLISION_SPRING_SCALARS;
    protected double anticollisionSpringStrength = 100.0;
    protected GraphView graphView;
    protected int nodeCount;
    protected int edgeCount;
    protected int layoutPass;
    protected HashMap nodeIndexToMatrixIndexMap;
    protected TreeMap matrixIndexToNodeIndexMap;
    private boolean interrupted;

    public SpringEmbeddedLayouter() {
    }

    public SpringEmbeddedLayouter(GraphView graphView) {
        this.setGraphView(graphView);
        this.initializeSpringEmbeddedLayouter();
    }

    public void setGraphView(GraphView graphView) {
        this.graphView = graphView;
    }

    public GraphView getGraphView() {
        return this.graphView;
    }

    protected void initializeSpringEmbeddedLayouter() {
    }

    public void interruptDoLayout() {
        this.interrupted = true;
    }

    public void resetDoLayout() {
        this.interrupted = false;
    }

    public boolean doLayout(int n, int n2, double d, MCODELoader mCODELoader) {
        this.nodeCount = this.graphView.getNodeViewCount();
        this.edgeCount = this.graphView.getEdgeViewCount();
        this.nodeIndexToMatrixIndexMap = new HashMap();
        this.matrixIndexToNodeIndexMap = new TreeMap();
        Iterator iterator = this.graphView.getNodeViewsIterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            NodeView nodeView = (NodeView)iterator.next();
            this.nodeIndexToMatrixIndexMap.put(new Integer(nodeView.getRootGraphIndex()), new Integer(n3));
            this.matrixIndexToNodeIndexMap.put(new Integer(n3), new Integer(nodeView.getRootGraphIndex()));
            ++n3;
        }
        double d2 = 0.5 * (double)(this.nodeCount + this.edgeCount);
        double d3 = 0.001;
        int n4 = (int)((double)this.nodeCount * this.averageIterationsPerNode / (double)this.numLayoutPasses);
        List list = this.createPartialsList();
        PotentialEnergy potentialEnergy = new PotentialEnergy();
        PartialDerivatives partialDerivatives = null;
        double d4 = 0.0;
        this.layoutPass = 0;
        while (this.layoutPass < this.numLayoutPasses) {
            this.setupForLayoutPass();
            potentialEnergy.reset();
            list.clear();
            Iterator iterator2 = this.graphView.getNodeViewsIterator();
            while (iterator2.hasNext()) {
                NodeView nodeView = (NodeView)iterator2.next();
                PartialDerivatives partialDerivatives2 = new PartialDerivatives(nodeView);
                this.calculatePartials(partialDerivatives2, null, potentialEnergy, false);
                list.add(partialDerivatives2);
                if (partialDerivatives != null && !(partialDerivatives2.euclideanDistance > partialDerivatives.euclideanDistance)) continue;
                partialDerivatives = partialDerivatives2;
            }
            for (int i = 0; i < n4 && partialDerivatives.euclideanDistance >= d2; ++i) {
                if (this.interrupted) {
                    System.err.println("Interrupted: Layouter");
                    this.resetDoLayout();
                    return false;
                }
                partialDerivatives = this.moveNode(partialDerivatives, list, potentialEnergy);
                d += 100.0 * (1.0 / (double)(n4 * this.numLayoutPasses)) * ((double)n / (double)n2);
                if (mCODELoader == null) continue;
                mCODELoader.setProgress((int)d, "Laying out");
            }
            ++this.layoutPass;
        }
        this.resetDoLayout();
        return true;
    }

    protected void setupForLayoutPass() {
        this.setupNodeDistanceSprings();
    }

    protected void setupNodeDistanceSprings() {
        Object object2;
        if (this.layoutPass != 0) {
            return;
        }
        this.nodeDistanceSpringRestLengths = new double[this.nodeCount][this.nodeCount];
        this.nodeDistanceSpringStrengths = new double[this.nodeCount][this.nodeCount];
        if (this.nodeDistanceSpringScalars[this.layoutPass] == 0.0) {
            return;
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Collection collection = this.matrixIndexToNodeIndexMap.values();
        int n = 0;
        for (Object object2 : collection) {
            arrayList.add(n, this.graphView.getGraphPerspective().getNode(((Integer)object2).intValue()));
            ++n;
        }
        NodeDistances nodeDistances = new NodeDistances(arrayList, this.graphView.getGraphPerspective(), this.nodeIndexToMatrixIndexMap);
        object2 = nodeDistances.calculate();
        if (object2 == null) {
            return;
        }
        double d = this.nodeDistanceStrengthConstant;
        double d2 = this.nodeDistanceRestLengthConstant;
        for (int i = 0; i < this.nodeCount; ++i) {
            for (int j = i + 1; j < this.nodeCount; ++j) {
                this.nodeDistanceSpringRestLengths[i][j] = object2[i][j] == Integer.MAX_VALUE ? this.disconnectedNodeDistanceSpringRestLength : d2 * (double)object2[i][j];
                this.nodeDistanceSpringRestLengths[j][i] = this.nodeDistanceSpringRestLengths[i][j];
                this.nodeDistanceSpringStrengths[i][j] = object2[i][j] == Integer.MAX_VALUE ? this.disconnectedNodeDistanceSpringStrength : d / (double)(object2[i][j] * object2[i][j]);
                this.nodeDistanceSpringStrengths[j][i] = this.nodeDistanceSpringStrengths[i][j];
            }
        }
    }

    protected PartialDerivatives calculatePartials(PartialDerivatives partialDerivatives, List list, PotentialEnergy potentialEnergy, boolean bl) {
        partialDerivatives.reset();
        NodeView nodeView = partialDerivatives.getNodeView();
        int n = (Integer)this.nodeIndexToMatrixIndexMap.get(new Integer(nodeView.getRootGraphIndex()));
        double d = nodeView.getWidth();
        double d2 = nodeView.getXPosition();
        double d3 = nodeView.getYPosition();
        PartialDerivatives partialDerivatives2 = null;
        PartialDerivatives partialDerivatives3 = null;
        Iterator iterator = list == null ? this.graphView.getNodeViewsIterator() : list.iterator();
        while (iterator.hasNext()) {
            NodeView nodeView2;
            if (list == null) {
                nodeView2 = (NodeView)iterator.next();
            } else {
                partialDerivatives2 = (PartialDerivatives)iterator.next();
                nodeView2 = partialDerivatives2.getNodeView();
            }
            if (nodeView.getRootGraphIndex() == nodeView2.getRootGraphIndex()) continue;
            int n2 = (Integer)this.nodeIndexToMatrixIndexMap.get(new Integer(nodeView2.getRootGraphIndex()));
            double d4 = nodeView2.getWidth();
            double d5 = d2 - nodeView2.getXPosition();
            double d6 = d3 - nodeView2.getYPosition();
            double d7 = Math.sqrt(d5 * d5 + d6 * d6);
            double d8 = Math.pow(d7, 3.0);
            double d9 = d7 - (d + d4);
            double d10 = this.nodeDistanceSpringScalars[this.layoutPass] * (this.nodeDistanceSpringStrengths[n][n2] * (d5 - this.nodeDistanceSpringRestLengths[n][n2] * d5 / d7));
            if (!bl) {
                partialDerivatives.x += d10;
            }
            if (partialDerivatives2 != null) {
                d10 = this.nodeDistanceSpringScalars[this.layoutPass] * (this.nodeDistanceSpringStrengths[n2][n] * (-d5 - this.nodeDistanceSpringRestLengths[n2][n] * -d5 / d7));
                partialDerivatives2.x = bl ? (partialDerivatives2.x -= d10) : (partialDerivatives2.x += d10);
            }
            if (d9 < 0.0) {
                d10 = this.anticollisionSpringScalars[this.layoutPass] * (this.anticollisionSpringStrength * (d5 - (d + d4) * d5 / d7));
                if (!bl) {
                    partialDerivatives.x += d10;
                }
                if (partialDerivatives2 != null) {
                    d10 = this.anticollisionSpringScalars[this.layoutPass] * (this.anticollisionSpringStrength * (-d5 - (d + d4) * -d5 / d7));
                    partialDerivatives2.x = bl ? (partialDerivatives2.x -= d10) : (partialDerivatives2.x += d10);
                }
            }
            d10 = this.nodeDistanceSpringScalars[this.layoutPass] * (this.nodeDistanceSpringStrengths[n][n2] * (d6 - this.nodeDistanceSpringRestLengths[n][n2] * d6 / d7));
            if (!bl) {
                partialDerivatives.y += d10;
            }
            if (partialDerivatives2 != null) {
                d10 = this.nodeDistanceSpringScalars[this.layoutPass] * (this.nodeDistanceSpringStrengths[n2][n] * (-d6 - this.nodeDistanceSpringRestLengths[n2][n] * -d6 / d7));
                partialDerivatives2.y = bl ? (partialDerivatives2.y -= d10) : (partialDerivatives2.y += d10);
            }
            if (d9 < 0.0) {
                d10 = this.anticollisionSpringScalars[this.layoutPass] * (this.anticollisionSpringStrength * (d6 - (d + d4) * d6 / d7));
                if (!bl) {
                    partialDerivatives.y += d10;
                }
                if (partialDerivatives2 != null) {
                    d10 = this.anticollisionSpringScalars[this.layoutPass] * (this.anticollisionSpringStrength * (-d6 - (d + d4) * -d6 / d7));
                    partialDerivatives2.y = bl ? (partialDerivatives2.y -= d10) : (partialDerivatives2.y += d10);
                }
            }
            d10 = this.nodeDistanceSpringScalars[this.layoutPass] * (this.nodeDistanceSpringStrengths[n][n2] * (1.0 - this.nodeDistanceSpringRestLengths[n][n2] * (d6 * d6) / d8));
            if (bl) {
                if (partialDerivatives2 != null) {
                    partialDerivatives2.xx -= d10;
                }
            } else {
                partialDerivatives.xx += d10;
                if (partialDerivatives2 != null) {
                    partialDerivatives2.xx += d10;
                }
            }
            if (d9 < 0.0) {
                d10 = this.anticollisionSpringScalars[this.layoutPass] * (this.anticollisionSpringStrength * (1.0 - (d + d4) * (d6 * d6) / d8));
                if (bl) {
                    if (partialDerivatives2 != null) {
                        partialDerivatives2.xx -= d10;
                    }
                } else {
                    partialDerivatives.xx += d10;
                    if (partialDerivatives2 != null) {
                        partialDerivatives2.xx += d10;
                    }
                }
            }
            d10 = this.nodeDistanceSpringScalars[this.layoutPass] * (this.nodeDistanceSpringStrengths[n][n2] * (1.0 - this.nodeDistanceSpringRestLengths[n][n2] * (d5 * d5) / d8));
            if (bl) {
                if (partialDerivatives2 != null) {
                    partialDerivatives2.yy -= d10;
                }
            } else {
                partialDerivatives.yy += d10;
                if (partialDerivatives2 != null) {
                    partialDerivatives2.yy += d10;
                }
            }
            if (d9 < 0.0) {
                d10 = this.anticollisionSpringScalars[this.layoutPass] * (this.anticollisionSpringStrength * (1.0 - (d + d4) * (d5 * d5) / d8));
                if (bl) {
                    if (partialDerivatives2 != null) {
                        partialDerivatives2.yy -= d10;
                    }
                } else {
                    partialDerivatives.yy += d10;
                    if (partialDerivatives2 != null) {
                        partialDerivatives2.yy += d10;
                    }
                }
            }
            d10 = this.nodeDistanceSpringScalars[this.layoutPass] * (this.nodeDistanceSpringStrengths[n][n2] * (this.nodeDistanceSpringRestLengths[n][n2] * (d5 * d6) / d8));
            if (bl) {
                if (partialDerivatives2 != null) {
                    partialDerivatives2.xy -= d10;
                }
            } else {
                partialDerivatives.xy += d10;
                if (partialDerivatives2 != null) {
                    partialDerivatives2.xy += d10;
                }
            }
            if (d9 < 0.0) {
                d10 = this.anticollisionSpringScalars[this.layoutPass] * (this.anticollisionSpringStrength * ((d + d4) * (d5 * d6) / d8));
                if (bl) {
                    if (partialDerivatives2 != null) {
                        partialDerivatives2.xy -= d10;
                    }
                } else {
                    partialDerivatives.xy += d10;
                    if (partialDerivatives2 != null) {
                        partialDerivatives2.xy += d10;
                    }
                }
            }
            double d11 = d7 - this.nodeDistanceSpringRestLengths[n][n2];
            d10 = this.nodeDistanceSpringScalars[this.layoutPass] * (this.nodeDistanceSpringStrengths[n][n2] * (d11 * d11) / 2.0);
            if (bl) {
                if (partialDerivatives2 != null) {
                    potentialEnergy.totalEnergy -= d10;
                }
            } else {
                potentialEnergy.totalEnergy += d10;
                if (partialDerivatives2 != null) {
                    potentialEnergy.totalEnergy += d10;
                }
            }
            if (d9 < 0.0) {
                d10 = this.anticollisionSpringScalars[this.layoutPass] * (this.anticollisionSpringStrength * (d9 * d9) / 2.0);
                if (bl) {
                    if (partialDerivatives2 != null) {
                        potentialEnergy.totalEnergy -= d10;
                    }
                } else {
                    potentialEnergy.totalEnergy += d10;
                    if (partialDerivatives2 != null) {
                        potentialEnergy.totalEnergy += d10;
                    }
                }
            }
            if (partialDerivatives2 == null) continue;
            partialDerivatives2.euclideanDistance = Math.sqrt(partialDerivatives2.x * partialDerivatives2.x + partialDerivatives2.y * partialDerivatives2.y);
            if (partialDerivatives3 != null && !(partialDerivatives2.euclideanDistance > partialDerivatives3.euclideanDistance)) continue;
            partialDerivatives3 = partialDerivatives2;
        }
        if (!bl) {
            partialDerivatives.euclideanDistance = Math.sqrt(partialDerivatives.x * partialDerivatives.x + partialDerivatives.y * partialDerivatives.y);
        }
        if (partialDerivatives3 == null || partialDerivatives.euclideanDistance > partialDerivatives3.euclideanDistance) {
            partialDerivatives3 = partialDerivatives;
        }
        return partialDerivatives3;
    }

    protected PartialDerivatives moveNode(PartialDerivatives partialDerivatives, List list, PotentialEnergy potentialEnergy) {
        NodeView nodeView = partialDerivatives.getNodeView();
        PartialDerivatives partialDerivatives2 = new PartialDerivatives(partialDerivatives);
        this.calculatePartials(partialDerivatives, list, potentialEnergy, true);
        this.simpleMoveNode(partialDerivatives2);
        return this.calculatePartials(partialDerivatives, list, potentialEnergy, false);
    }

    protected void simpleMoveNode(PartialDerivatives partialDerivatives) {
        NodeView nodeView = partialDerivatives.getNodeView();
        double d = partialDerivatives.xx * partialDerivatives.yy - partialDerivatives.xy * partialDerivatives.xy;
        double d2 = (-partialDerivatives.x * partialDerivatives.yy - -partialDerivatives.y * partialDerivatives.xy) / d;
        double d3 = (-partialDerivatives.y * partialDerivatives.xx - -partialDerivatives.x * partialDerivatives.xy) / d;
        Point2D point2D = nodeView.getOffset();
        nodeView.setOffset(point2D.getX() + d2, point2D.getY() + d3);
    }

    protected List createPartialsList() {
        return new ArrayList();
    }

    class PotentialEnergy {
        public double totalEnergy = 0.0;

        PotentialEnergy() {
        }

        public void reset() {
            this.totalEnergy = 0.0;
        }
    }

    class PartialDerivatives {
        protected NodeView nodeView;
        public double x;
        public double y;
        public double xx;
        public double yy;
        public double xy;
        public double euclideanDistance;

        public PartialDerivatives(NodeView nodeView) {
            this.nodeView = nodeView;
        }

        public PartialDerivatives(PartialDerivatives partialDerivatives) {
            this.nodeView = partialDerivatives.getNodeView();
            this.copyFrom(partialDerivatives);
        }

        public void reset() {
            this.x = 0.0;
            this.y = 0.0;
            this.xx = 0.0;
            this.yy = 0.0;
            this.xy = 0.0;
            this.euclideanDistance = 0.0;
        }

        public NodeView getNodeView() {
            return this.nodeView;
        }

        public void copyFrom(PartialDerivatives partialDerivatives) {
            this.x = partialDerivatives.x;
            this.y = partialDerivatives.y;
            this.xx = partialDerivatives.xx;
            this.yy = partialDerivatives.yy;
            this.xy = partialDerivatives.xy;
            this.euclideanDistance = partialDerivatives.euclideanDistance;
        }

        public String toString() {
            return "PartialDerivatives( \"" + this.getNodeView() + "\", x=" + this.x + ", y=" + this.y + ", xx=" + this.xx + ", yy=" + this.yy + ", xy=" + this.xy + ", euclideanDistance=" + this.euclideanDistance + " )";
        }
    }
}

