/*
 * Decompiled with CFR 0.152.
 */
package csplugins.mcode;

import csplugins.mcode.MonitorableTask;
import csplugins.mcode.SwingWorker;
import cytoscape.Cytoscape;
import giny.model.Edge;
import giny.model.GraphPerspective;
import giny.model.Node;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeDistances
implements MonitorableTask {
    public static final int INFINITY = Integer.MAX_VALUE;
    protected List nodesList;
    protected GraphPerspective perspective;
    protected int[][] distances;
    protected boolean directed;
    protected int currentProgress;
    protected int lengthOfTask;
    protected String statusMessage;
    protected boolean done;
    protected boolean canceled;
    protected HashMap nodeIndexToMatrixIndexMap;

    public NodeDistances(List list, int[][] nArray, GraphPerspective graphPerspective) {
        this(list, nArray, graphPerspective, false);
    }

    public NodeDistances(List list, int[][] nArray, GraphPerspective graphPerspective, boolean bl) {
        this.perspective = graphPerspective;
        this.nodesList = list;
        this.distances = nArray == null ? (Object)new int[this.nodesList.size()][] : nArray;
        this.directed = bl;
    }

    public NodeDistances(List list, GraphPerspective graphPerspective, HashMap hashMap) {
        this.nodesList = list;
        this.nodeIndexToMatrixIndexMap = hashMap;
        this.perspective = graphPerspective;
        this.distances = new int[list.size()][];
        this.directed = false;
    }

    @Override
    public int getCurrentProgress() {
        return this.currentProgress;
    }

    @Override
    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    @Override
    public String getTaskDescription() {
        return "Calculating Node Distances";
    }

    @Override
    public String getCurrentStatusMessage() {
        return this.statusMessage;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public void stop() {
        this.canceled = true;
        this.statusMessage = null;
    }

    @Override
    public boolean wasCanceled() {
        return this.canceled;
    }

    public int[][] calculate() {
        Object object;
        int n;
        Node node;
        this.currentProgress = 0;
        this.lengthOfTask = this.distances.length;
        this.done = false;
        this.canceled = false;
        Node[] nodeArray = new Node[this.nodesList.size()];
        Integer[] integerArray = new Integer[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            node = (Node)this.nodesList.get(i);
            if (node == null) continue;
            n = (Integer)this.nodeIndexToMatrixIndexMap.get(new Integer(node.getRootGraphIndex()));
            if (n < 0 || n >= nodeArray.length) {
                System.err.println("WARNING: GraphNode \"" + node + "\" has an index value that is out of range: " + n + ".  Graph indices should be maintained such " + "that no index is unused.");
                return null;
            }
            if (nodeArray[n] != null) {
                System.err.println("WARNING: GraphNode \"" + node + "\" has an index value ( " + n + " ) that is the same as " + "that of another GraphNode ( \"" + nodeArray[n] + "\" ).  Graph indices should be maintained such " + "that indices are unique.");
                return null;
            }
            nodeArray[n] = node;
            object = new Integer(n);
            integerArray[n] = object;
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        object = new boolean[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            if (this.canceled) {
                this.distances = null;
                return this.distances;
            }
            node = nodeArray[i];
            if (node == null) {
                if (this.distances[i] == null) {
                    this.distances[i] = new int[nodeArray.length];
                }
                Arrays.fill(this.distances[i], Integer.MAX_VALUE);
                continue;
            }
            if (this.distances[i] == null) {
                this.distances[i] = new int[nodeArray.length];
            }
            Arrays.fill(this.distances[i], Integer.MAX_VALUE);
            this.distances[i][i] = 0;
            Arrays.fill(object, false);
            linkedList.add(integerArray[i]);
            while (!linkedList.isEmpty()) {
                if (this.canceled) {
                    this.distances = null;
                    return this.distances;
                }
                n = (Integer)linkedList.removeFirst();
                if (object[n]) continue;
                object[n] = true;
                Node node2 = nodeArray[n];
                int n2 = this.distances[i][n];
                if (n < i) {
                    for (int j = 0; j < nodeArray.length; ++j) {
                        int n3;
                        if (this.distances[n][j] == Integer.MAX_VALUE || (n3 = n2 + this.distances[n][j]) > this.distances[i][j]) continue;
                        if (this.distances[n][j] == 1) {
                            object[j] = true;
                        }
                        this.distances[i][j] = n3;
                    }
                    continue;
                }
                Collection<Node> collection = this.getNeighbors(node2);
                for (Node node3 : collection) {
                    if (this.canceled) {
                        this.distances = null;
                        return this.distances;
                    }
                    int n4 = (Integer)this.nodeIndexToMatrixIndexMap.get(new Integer(node3.getRootGraphIndex()));
                    if (nodeArray[n4] == null) {
                        this.distances[i][n4] = Integer.MAX_VALUE;
                        continue;
                    }
                    if (object[n4]) continue;
                    int n5 = this.distances[i][n4];
                    if (n2 == Integer.MAX_VALUE || n5 <= n2 + 1) continue;
                    this.distances[i][n4] = n2 + 1;
                    linkedList.addLast(integerArray[n4]);
                }
            }
            ++this.currentProgress;
            double d = this.currentProgress * 100 / this.lengthOfTask;
            this.statusMessage = "Completed " + d + "%.";
        }
        this.done = true;
        this.currentProgress = this.lengthOfTask;
        return this.distances;
    }

    public int[][] getDistances() {
        return this.distances;
    }

    private Collection<Node> getNeighbors(Node node) {
        HashSet<Node> hashSet = new HashSet<Node>();
        int[] nArray = this.perspective.getAdjacentEdgeIndicesArray(node.getRootGraphIndex(), true, true, true);
        if (nArray == null || nArray.length == 0) {
            return hashSet;
        }
        int n = node.getRootGraphIndex();
        for (int i = 0; i < nArray.length; ++i) {
            Edge edge = Cytoscape.getRootGraph().getEdge(nArray[i]);
            if (edge.getSource().getRootGraphIndex() != n) {
                hashSet.add(edge.getSource());
                continue;
            }
            if (edge.getTarget().getRootGraphIndex() == n) continue;
            hashSet.add(edge.getTarget());
        }
        return hashSet;
    }

    @Override
    public void start(boolean bl) {
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                return new NodeDistancesTask();
            }
        };
        swingWorker.start();
        if (bl) {
            swingWorker.get();
        }
    }

    class NodeDistancesTask {
        NodeDistancesTask() {
            NodeDistances.this.calculate();
        }
    }
}

