/*
 * Decompiled with CFR 0.152.
 */
package csplugins.mcode;

import csplugins.mcode.MCODEAlgorithm;
import csplugins.mcode.MCODECluster;
import csplugins.mcode.MCODELoader;
import csplugins.mcode.SpringEmbeddedLayouter;
import cytoscape.CyNetwork;
import giny.model.GraphPerspective;
import giny.model.Node;
import giny.view.EdgeView;
import giny.view.GraphView;
import giny.view.NodeView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import javax.swing.JOptionPane;
import phoebe.PGraphView;

public class MCODEUtil {
    private static boolean INTERRUPTED = false;
    private static Image placeHolderImage = null;

    public static Image convertNetworkToImage(MCODELoader mCODELoader, MCODECluster mCODECluster, int n, int n2, SpringEmbeddedLayouter springEmbeddedLayouter, boolean bl) {
        NodeView nodeView;
        int n3 = 20;
        int n4 = 5;
        int n5 = 75;
        int n6 = n3 + n4;
        if (bl) {
            n6 += n5;
        }
        double d = 0.0;
        PGraphView pGraphView = new PGraphView(mCODECluster.getGPCluster());
        Iterator iterator = pGraphView.getNodeViewsIterator();
        while (iterator.hasNext()) {
            if (INTERRUPTED) {
                System.err.println("Interrupted: Node Setup");
                if (springEmbeddedLayouter != null) {
                    springEmbeddedLayouter.resetDoLayout();
                }
                MCODEUtil.resetLoading();
                return null;
            }
            nodeView = (NodeView)iterator.next();
            String string = nodeView.getNode().getIdentifier();
            nodeView.getLabel().setText(string);
            nodeView.setWidth(40.0);
            nodeView.setHeight(40.0);
            if (mCODECluster.getSeedNode().intValue() == nodeView.getRootGraphIndex()) {
                nodeView.setShape(6);
            } else {
                nodeView.setShape(2);
            }
            nodeView.setUnselectedPaint((Paint)Color.RED);
            nodeView.setBorderPaint((Paint)Color.BLACK);
            if (mCODECluster.getPGView() != null && mCODECluster.getPGView().getNodeView(nodeView.getNode().getRootGraphIndex()) != null) {
                nodeView.setXPosition(mCODECluster.getPGView().getNodeView(nodeView.getNode().getRootGraphIndex()).getXPosition());
                nodeView.setYPosition(mCODECluster.getPGView().getNodeView(nodeView.getNode().getRootGraphIndex()).getYPosition());
            } else {
                nodeView.setXPosition(pGraphView.getCanvas().getLayer().getGlobalFullBounds().getWidth() * Math.random());
                nodeView.setYPosition((pGraphView.getCanvas().getLayer().getGlobalFullBounds().getHeight() + 100.0) * Math.random());
                if (!bl) {
                    d /= (double)((n6 += n5) / (n6 - n5));
                    bl = true;
                }
            }
            if (mCODELoader == null) continue;
            mCODELoader.setProgress((int)(d += 100.0 * (1.0 / (double)pGraphView.nodeCount()) * ((double)n3 / (double)n6)), "Setup: nodes");
        }
        iterator = pGraphView.getEdgeViewsIterator();
        while (iterator.hasNext()) {
            if (INTERRUPTED) {
                System.err.println("Interrupted: Edge Setup");
                if (springEmbeddedLayouter != null) {
                    springEmbeddedLayouter.resetDoLayout();
                }
                MCODEUtil.resetLoading();
                return null;
            }
            nodeView = (EdgeView)iterator.next();
            nodeView.setUnselectedPaint((Paint)Color.BLUE);
            nodeView.setTargetEdgeEnd(5);
            nodeView.setTargetEdgeEndPaint((Paint)Color.CYAN);
            nodeView.setSourceEdgeEndPaint((Paint)Color.CYAN);
            nodeView.setStroke((Stroke)new BasicStroke(5.0f));
            if (mCODELoader == null) continue;
            mCODELoader.setProgress((int)(d += 100.0 * (1.0 / (double)pGraphView.edgeCount()) * ((double)n4 / (double)n6)), "Setup: edges");
        }
        if (bl) {
            if (springEmbeddedLayouter == null) {
                springEmbeddedLayouter = new SpringEmbeddedLayouter();
            }
            springEmbeddedLayouter.setGraphView((GraphView)pGraphView);
            if (!springEmbeddedLayouter.doLayout(n5, n6, d, mCODELoader)) {
                MCODEUtil.resetLoading();
                return null;
            }
        }
        Image image = pGraphView.getCanvas().getLayer().toImage(n2, n, null);
        double d2 = pGraphView.getCanvas().getLayer().getFullBounds().width;
        if (pGraphView.getCanvas().getLayer().getFullBounds().height > d2) {
            d2 = pGraphView.getCanvas().getLayer().getFullBounds().height;
        }
        if (pGraphView.getNodeViewCount() >= 1) {
            mCODECluster.setPGView(pGraphView);
        }
        springEmbeddedLayouter.resetDoLayout();
        MCODEUtil.resetLoading();
        return image;
    }

    public static void interruptLoading() {
        INTERRUPTED = true;
    }

    public static void resetLoading() {
        INTERRUPTED = false;
    }

    public static Image getPlaceHolderImage(int n, int n2) {
        if (placeHolderImage == null) {
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
            int n3 = 10;
            graphics2D.setFont(new Font("Arial", 0, n3));
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Font font = graphics2D.getFont();
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            String string = "Too big to show";
            n2 = 20;
            graphics2D.setColor(Color.WHITE);
            graphics2D.drawString(string, n / 2 - fontMetrics.stringWidth(string) / 2 - 1, n2 / 2 + n3 / 2 - 1);
            graphics2D.drawString(string, n / 2 - fontMetrics.stringWidth(string) / 2 - 1, n2 / 2 + n3 / 2 + 1);
            graphics2D.drawString(string, n / 2 - fontMetrics.stringWidth(string) / 2 + 1, n2 / 2 + n3 / 2 - 1);
            graphics2D.drawString(string, n / 2 - fontMetrics.stringWidth(string) / 2 + 1, n2 / 2 + n3 / 2 + 1);
            graphics2D.setColor(Color.RED);
            graphics2D.drawString(string, n / 2 - fontMetrics.stringWidth(string) / 2, n2 / 2 + n3 / 2);
            placeHolderImage = bufferedImage;
        }
        return placeHolderImage;
    }

    public static GraphPerspective convertClusterToNetwork(ArrayList arrayList, CyNetwork cyNetwork) {
        int[] nArray = MCODEUtil.convertIntArrayList2array(arrayList);
        GraphPerspective graphPerspective = cyNetwork.createGraphPerspective(nArray);
        return graphPerspective;
    }

    public static MCODECluster[] sortClusters(MCODECluster[] mCODEClusterArray) {
        Arrays.sort(mCODEClusterArray, new Comparator(){

            public int compare(Object object, Object object2) {
                double d;
                double d2 = ((MCODECluster)object).getClusterScore();
                if (d2 == (d = ((MCODECluster)object2).getClusterScore())) {
                    return 0;
                }
                if (d2 < d) {
                    return 1;
                }
                return -1;
            }
        });
        return mCODEClusterArray;
    }

    private static int[] convertIntArrayList2array(ArrayList arrayList) {
        int[] nArray = new int[arrayList.size()];
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            nArray[n] = (Integer)iterator.next();
            ++n;
        }
        return nArray;
    }

    public static StringBuffer getNodeNameList(GraphPerspective graphPerspective) {
        Iterator iterator = graphPerspective.nodesIterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            stringBuffer.append(node.getIdentifier());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer;
    }

    public static boolean exportMCODEResults(MCODEAlgorithm mCODEAlgorithm, MCODECluster[] mCODEClusterArray, CyNetwork cyNetwork, String string) {
        if (mCODEAlgorithm == null || mCODEClusterArray == null || cyNetwork == null || string == null) {
            return false;
        }
        String string2 = System.getProperty("line.separator");
        try {
            File file = new File(string);
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write("MCODE Plugin Results" + string2);
            fileWriter.write("Date: " + DateFormat.getDateTimeInstance().format(new Date()) + string2 + string2);
            fileWriter.write("Parameters:" + string2 + mCODEAlgorithm.getParams().toString() + string2);
            fileWriter.write("Cluster\tScore (Density*#Nodes)\tNodes\tEdges\tNode IDs" + string2);
            for (int i = 0; i < mCODEClusterArray.length; ++i) {
                GraphPerspective graphPerspective = mCODEClusterArray[i].getGPCluster();
                fileWriter.write(i + 1 + "\t");
                NumberFormat numberFormat = NumberFormat.getInstance();
                numberFormat.setMaximumFractionDigits(3);
                fileWriter.write(numberFormat.format(mCODEClusterArray[i].getClusterScore()) + "\t");
                fileWriter.write(graphPerspective.getNodeCount() + "\t");
                fileWriter.write(graphPerspective.getEdgeCount() + "\t");
                fileWriter.write(MCODEUtil.getNodeNameList(graphPerspective).toString() + string2);
            }
            fileWriter.close();
            return true;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, iOException.toString(), "Error Writing to \"" + string + "\"", 0);
            return false;
        }
    }
}

