/*
 * Decompiled with CFR 0.152.
 */
package csplugins.mcode;

import csplugins.mcode.JMultiLineToolTip;
import csplugins.mcode.MCODECollapsablePanel;
import csplugins.mcode.MCODECurrentParameters;
import csplugins.mcode.MCODEMainPanelAction;
import csplugins.mcode.MCODEParameterSet;
import csplugins.mcode.MCODEResultsPanel;
import csplugins.mcode.MCODEScoreAndFindAction;
import csplugins.mcode.MCODEVisualStyle;
import csplugins.mcode.MCODEVisualStyleAction;
import cytoscape.Cytoscape;
import cytoscape.view.CytoscapeDesktop;
import cytoscape.view.cytopanels.CytoPanel;
import cytoscape.view.cytopanels.CytoPanelListener;
import cytoscape.view.cytopanels.CytoPanelState;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToolTip;

public class MCODEMainPanel
extends JPanel {
    MCODEParameterSet currentParamsCopy;
    MCODEMainPanelAction trigger;
    MCODEVisualStyle MCODEVS;
    DecimalFormat decFormat;
    MCODECollapsablePanel clusterFindingPanel;
    MCODECollapsablePanel customizeClusterFindingPanel;
    JPanel clusterFindingContent;
    JPanel customizeClusterFindingContent;
    JCheckBox includeLoopsCheckBox;
    JFormattedTextField degreeCutOffFormattedTextField;
    JFormattedTextField kCoreFormattedTextField;
    JFormattedTextField nodeScoreCutoffFormattedTextField;
    JRadioButton optimizeOption;
    JRadioButton customizeOption;
    JCheckBox preprocessCheckBox;
    JCheckBox haircutCheckBox;
    JCheckBox fluffCheckBox;
    JFormattedTextField fluffNodeDensityCutOffFormattedTextField;
    JFormattedTextField maxDepthFormattedTextField;

    public MCODEMainPanel(MCODEMainPanelAction mCODEMainPanelAction, MCODEVisualStyle mCODEVisualStyle) {
        this.trigger = mCODEMainPanelAction;
        this.MCODEVS = mCODEVisualStyle;
        this.setLayout(new BorderLayout());
        this.currentParamsCopy = MCODECurrentParameters.getInstance().getParamsCopy(null);
        this.currentParamsCopy.setDefaultParams();
        this.decFormat = new DecimalFormat();
        this.decFormat.setParseIntegerOnly(true);
        CytoscapeDesktop cytoscapeDesktop = Cytoscape.getDesktop();
        CytoPanel cytoPanel = cytoscapeDesktop.getCytoPanel(3);
        cytoPanel.addCytoPanelListener((CytoPanelListener)new MCODEVisualStyleAction(cytoPanel, mCODEVisualStyle));
        JPanel jPanel = this.createScopePanel();
        MCODECollapsablePanel mCODECollapsablePanel = this.createAdvancedOptionsPanel();
        JPanel jPanel2 = this.createBottomPanel();
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)mCODECollapsablePanel, "North");
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel3, "Center");
        this.add((Component)jPanel2, "South");
        this.clusterFindingPanel.getContentPane().remove(this.clusterFindingContent);
        this.clusterFindingPanel.getContentPane().add((Component)this.customizeClusterFindingContent, "North");
    }

    private JPanel createScopePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder("Find Cluster(s)"));
        JRadioButton jRadioButton = new JRadioButton("in Whole Network", this.currentParamsCopy.getScope().equals(MCODEParameterSet.NETWORK));
        JRadioButton jRadioButton2 = new JRadioButton("from Selection", this.currentParamsCopy.getScope().equals(MCODEParameterSet.SELECTION));
        jRadioButton.setActionCommand(MCODEParameterSet.NETWORK);
        jRadioButton2.setActionCommand(MCODEParameterSet.SELECTION);
        jRadioButton.addActionListener(new ScopeAction());
        jRadioButton2.addActionListener(new ScopeAction());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        jPanel.add(jRadioButton);
        jPanel.add(jRadioButton2);
        return jPanel;
    }

    private MCODECollapsablePanel createAdvancedOptionsPanel() {
        MCODECollapsablePanel mCODECollapsablePanel = new MCODECollapsablePanel("Advanced Options");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        MCODECollapsablePanel mCODECollapsablePanel2 = this.createNetworkScoringPanel();
        this.clusterFindingPanel = this.createClusterFindingPanel();
        jPanel.add(mCODECollapsablePanel2);
        jPanel.add(this.clusterFindingPanel);
        mCODECollapsablePanel.getContentPane().add((Component)jPanel, "North");
        return mCODECollapsablePanel;
    }

    private MCODECollapsablePanel createNetworkScoringPanel() {
        MCODECollapsablePanel mCODECollapsablePanel = new MCODECollapsablePanel("Network Scoring");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        JLabel jLabel = new JLabel("Include Loops");
        this.includeLoopsCheckBox = new JCheckBox(){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        this.includeLoopsCheckBox.addItemListener(new IncludeLoopsCheckBoxAction());
        String string = "Self-edges may increase a\nnode's score slightly";
        this.includeLoopsCheckBox.setToolTipText(string);
        this.includeLoopsCheckBox.setSelected(this.currentParamsCopy.isIncludeLoops());
        JPanel jPanel2 = new JPanel(){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setToolTipText(string);
        jPanel2.add((Component)jLabel, "West");
        jPanel2.add((Component)this.includeLoopsCheckBox, "East");
        JLabel jLabel2 = new JLabel("Degree Cutoff");
        this.degreeCutOffFormattedTextField = new JFormattedTextField(this.decFormat){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        this.degreeCutOffFormattedTextField.setColumns(3);
        this.degreeCutOffFormattedTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        String string2 = "Sets the minimum number of\nedges for a node to be scored.";
        this.degreeCutOffFormattedTextField.setToolTipText(string2);
        this.degreeCutOffFormattedTextField.setText(new Integer(this.currentParamsCopy.getDegreeCutoff()).toString());
        JPanel jPanel3 = new JPanel(){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setToolTipText(string2);
        jPanel3.add((Component)jLabel2, "West");
        jPanel3.add((Component)this.degreeCutOffFormattedTextField, "East");
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        mCODECollapsablePanel.getContentPane().add((Component)jPanel, "North");
        return mCODECollapsablePanel;
    }

    private MCODECollapsablePanel createClusterFindingPanel() {
        MCODECollapsablePanel mCODECollapsablePanel = new MCODECollapsablePanel("Cluster Finding");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.customizeOption = new JRadioButton("Customize", !this.currentParamsCopy.isOptimize());
        this.optimizeOption = new JRadioButton("Optimize", this.currentParamsCopy.isOptimize());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.customizeOption);
        buttonGroup.add(this.optimizeOption);
        this.customizeOption.addActionListener(new ClusterFindingAction());
        this.optimizeOption.addActionListener(new ClusterFindingAction());
        this.customizeClusterFindingPanel = this.createCustomizeClusterFindingPanel(this.customizeOption);
        MCODECollapsablePanel mCODECollapsablePanel2 = this.createOptimizeClusterFindingPanel(this.optimizeOption);
        jPanel.add(this.customizeClusterFindingPanel);
        jPanel.add(mCODECollapsablePanel2);
        this.clusterFindingContent = jPanel;
        mCODECollapsablePanel.getContentPane().add((Component)jPanel, "North");
        return mCODECollapsablePanel;
    }

    private MCODECollapsablePanel createCustomizeClusterFindingPanel(JRadioButton jRadioButton) {
        MCODECollapsablePanel mCODECollapsablePanel = new MCODECollapsablePanel(jRadioButton);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JLabel jLabel = new JLabel("Node Score Cutoff");
        this.nodeScoreCutoffFormattedTextField = new JFormattedTextField(new DecimalFormat("0.000")){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        this.nodeScoreCutoffFormattedTextField.setColumns(3);
        this.nodeScoreCutoffFormattedTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        String string = "Sets the acceptable score deviance from\nthe seed node's score for expanding a cluster\n(most influental parameter for cluster size).";
        this.nodeScoreCutoffFormattedTextField.setToolTipText(string);
        this.nodeScoreCutoffFormattedTextField.setText(new Double(this.currentParamsCopy.getNodeScoreCutoff()).toString());
        JPanel jPanel2 = new JPanel(new BorderLayout()){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        jPanel2.setToolTipText(string);
        jPanel2.add((Component)jLabel, "West");
        jPanel2.add((Component)this.nodeScoreCutoffFormattedTextField, "East");
        JLabel jLabel2 = new JLabel("K-Core");
        this.kCoreFormattedTextField = new JFormattedTextField(this.decFormat){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        this.kCoreFormattedTextField.setColumns(3);
        this.kCoreFormattedTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        String string2 = "Filters out clusters lacking a\nmaximally inter-connected core\nof at least k edges per node.";
        this.kCoreFormattedTextField.setToolTipText(string2);
        this.kCoreFormattedTextField.setText(new Integer(this.currentParamsCopy.getKCore()).toString());
        JPanel jPanel3 = new JPanel(new BorderLayout()){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        jPanel3.setToolTipText(string2);
        jPanel3.add((Component)jLabel2, "West");
        jPanel3.add((Component)this.kCoreFormattedTextField, "East");
        JLabel jLabel3 = new JLabel("Haircut");
        this.haircutCheckBox = new JCheckBox(){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        this.haircutCheckBox.addItemListener(new HaircutCheckBoxAction());
        String string3 = "Remove singly connected\nnodes from clusters.";
        this.haircutCheckBox.setToolTipText(string3);
        this.haircutCheckBox.setSelected(this.currentParamsCopy.isHaircut());
        JPanel jPanel4 = new JPanel(new BorderLayout()){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        jPanel4.setToolTipText(string3);
        jPanel4.add((Component)jLabel3, "West");
        jPanel4.add((Component)this.haircutCheckBox, "East");
        JLabel jLabel4 = new JLabel("Fluff");
        this.fluffCheckBox = new JCheckBox(){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        this.fluffCheckBox.addItemListener(new FluffCheckBoxAction());
        String string4 = "Expand core cluster by one\nneighbour shell (applied\nafter the optional haircut).";
        this.fluffCheckBox.setToolTipText(string4);
        this.fluffCheckBox.setSelected(this.currentParamsCopy.isFluff());
        JPanel jPanel5 = new JPanel(new BorderLayout()){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        jPanel5.setToolTipText(string4);
        jPanel5.add((Component)jLabel4, "West");
        jPanel5.add((Component)this.fluffCheckBox, "East");
        JLabel jLabel5 = new JLabel("   Node Density Cutoff");
        this.fluffNodeDensityCutOffFormattedTextField = new JFormattedTextField(new DecimalFormat("0.000")){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        this.fluffNodeDensityCutOffFormattedTextField.setColumns(3);
        this.fluffNodeDensityCutOffFormattedTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        String string5 = "Limits fluffing by setting the acceptable\nnode density deviance from the core cluster\ndensity (allows clusters' edges to overlap).";
        this.fluffNodeDensityCutOffFormattedTextField.setToolTipText(string5);
        this.fluffNodeDensityCutOffFormattedTextField.setText(new Double(this.currentParamsCopy.getFluffNodeDensityCutoff()).toString());
        JPanel jPanel6 = new JPanel(new BorderLayout()){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        jPanel6.setToolTipText(string5);
        jPanel6.add((Component)jLabel5, "West");
        jPanel6.add((Component)this.fluffNodeDensityCutOffFormattedTextField, "East");
        jPanel6.setVisible(this.currentParamsCopy.isFluff());
        JLabel jLabel6 = new JLabel("Max. Depth");
        this.maxDepthFormattedTextField = new JFormattedTextField(this.decFormat){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        this.maxDepthFormattedTextField.setColumns(3);
        this.maxDepthFormattedTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        String string6 = "Limits the cluster size by setting the\nmaximum search distance from a seed\nnode (100 virtually means no limit).";
        this.maxDepthFormattedTextField.setToolTipText(string6);
        this.maxDepthFormattedTextField.setText(new Integer(this.currentParamsCopy.getMaxDepthFromStart()).toString());
        JPanel jPanel7 = new JPanel(new BorderLayout()){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        jPanel7.setToolTipText(string6);
        jPanel7.add((Component)jLabel6, "West");
        jPanel7.add((Component)this.maxDepthFormattedTextField, "East");
        jPanel.add(jPanel4);
        jPanel.add(jPanel5);
        jPanel.add(jPanel6);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(jPanel7);
        this.customizeClusterFindingContent = jPanel;
        mCODECollapsablePanel.getContentPane().add((Component)jPanel, "North");
        return mCODECollapsablePanel;
    }

    private MCODECollapsablePanel createOptimizeClusterFindingPanel(JRadioButton jRadioButton) {
        MCODECollapsablePanel mCODECollapsablePanel = new MCODECollapsablePanel(jRadioButton);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JLabel jLabel = new JLabel("Benchmark file location");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jLabel, "West");
        JFormattedTextField jFormattedTextField = new JFormattedTextField();
        JButton jButton = new JButton("Browse...");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jFormattedTextField, "Center");
        jPanel3.add((Component)jButton, "East");
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        mCODECollapsablePanel.getContentPane().add((Component)jPanel, "North");
        return mCODECollapsablePanel;
    }

    private JPanel createBottomPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        JButton jButton = new JButton("Analyze");
        jButton.addActionListener(new MCODEScoreAndFindAction(this.currentParamsCopy, this.MCODEVS));
        JButton jButton2 = new JButton("Close MCODE");
        jButton2.addActionListener(new CloseAction(this));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        return jPanel;
    }

    private class FluffCheckBoxAction
    implements ItemListener {
        private FluffCheckBoxAction() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 2) {
                MCODEMainPanel.this.currentParamsCopy.setFluff(false);
            } else {
                MCODEMainPanel.this.currentParamsCopy.setFluff(true);
            }
            MCODEMainPanel.this.fluffNodeDensityCutOffFormattedTextField.getParent().setVisible(MCODEMainPanel.this.currentParamsCopy.isFluff());
        }
    }

    private class HaircutCheckBoxAction
    implements ItemListener {
        private HaircutCheckBoxAction() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 2) {
                MCODEMainPanel.this.currentParamsCopy.setHaircut(false);
            } else {
                MCODEMainPanel.this.currentParamsCopy.setHaircut(true);
            }
        }
    }

    private class FormattedTextFieldAction
    implements PropertyChangeListener {
        private FormattedTextFieldAction() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JFormattedTextField jFormattedTextField = (JFormattedTextField)propertyChangeEvent.getSource();
            String string = "The value you have entered is invalid.\n";
            boolean bl = false;
            if (jFormattedTextField == MCODEMainPanel.this.degreeCutOffFormattedTextField) {
                Number number = (Number)MCODEMainPanel.this.degreeCutOffFormattedTextField.getValue();
                if (number != null && number.intValue() > 1) {
                    MCODEMainPanel.this.currentParamsCopy.setDegreeCutoff(number.intValue());
                } else {
                    jFormattedTextField.setValue(new Integer(2));
                    string = string + "The degree cutoff must be greater than 1.";
                    bl = true;
                }
            } else if (jFormattedTextField == MCODEMainPanel.this.nodeScoreCutoffFormattedTextField) {
                Number number = (Number)MCODEMainPanel.this.nodeScoreCutoffFormattedTextField.getValue();
                if (number != null && number.doubleValue() >= 0.0 && number.doubleValue() <= 1.0) {
                    MCODEMainPanel.this.currentParamsCopy.setNodeScoreCutoff(number.doubleValue());
                } else {
                    jFormattedTextField.setValue(new Double(MCODEMainPanel.this.currentParamsCopy.getNodeScoreCutoff()));
                    string = string + "The node score cutoff must be between 0 and 1.";
                    bl = true;
                }
            } else if (jFormattedTextField == MCODEMainPanel.this.kCoreFormattedTextField) {
                Number number = (Number)MCODEMainPanel.this.kCoreFormattedTextField.getValue();
                if (number != null && number.intValue() > 1) {
                    MCODEMainPanel.this.currentParamsCopy.setKCore(number.intValue());
                } else {
                    jFormattedTextField.setValue(new Integer(2));
                    string = string + "The K-Core must be greater than 1.";
                    bl = true;
                }
            } else if (jFormattedTextField == MCODEMainPanel.this.maxDepthFormattedTextField) {
                Number number = (Number)MCODEMainPanel.this.maxDepthFormattedTextField.getValue();
                if (number != null && number.intValue() > 0) {
                    MCODEMainPanel.this.currentParamsCopy.setMaxDepthFromStart(number.intValue());
                } else {
                    jFormattedTextField.setValue(new Integer(1));
                    string = string + "The maximum depth must be greater than 0.";
                    bl = true;
                }
            } else if (jFormattedTextField == MCODEMainPanel.this.fluffNodeDensityCutOffFormattedTextField) {
                Number number = (Number)MCODEMainPanel.this.fluffNodeDensityCutOffFormattedTextField.getValue();
                if (number != null && number.doubleValue() >= 0.0 && number.doubleValue() <= 1.0) {
                    MCODEMainPanel.this.currentParamsCopy.setFluffNodeDensityCutoff(number.doubleValue());
                } else {
                    jFormattedTextField.setValue(new Double(MCODEMainPanel.this.currentParamsCopy.getFluffNodeDensityCutoff()));
                    string = string + "The fluff node density cutoff must be between 0 and 1.";
                    bl = true;
                }
            }
            if (bl) {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), string, "Parameter out of bounds", 2);
            }
        }
    }

    private class IncludeLoopsCheckBoxAction
    implements ItemListener {
        private IncludeLoopsCheckBoxAction() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 2) {
                MCODEMainPanel.this.currentParamsCopy.setIncludeLoops(false);
            } else {
                MCODEMainPanel.this.currentParamsCopy.setIncludeLoops(true);
            }
        }
    }

    private class CloseAction
    extends AbstractAction {
        MCODEMainPanel mainPanel;
        MCODEResultsPanel component;

        CloseAction(MCODEMainPanel mCODEMainPanel2) {
            this.mainPanel = mCODEMainPanel2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CytoscapeDesktop cytoscapeDesktop = Cytoscape.getDesktop();
            boolean bl = true;
            CytoPanel cytoPanel = cytoscapeDesktop.getCytoPanel(3);
            for (int i = cytoPanel.getCytoPanelComponentCount() - 1; i >= 0; --i) {
                cytoPanel.setSelectedIndex(i);
                Component component = cytoPanel.getSelectedComponent();
                if (!(component instanceof MCODEResultsPanel)) continue;
                this.component = (MCODEResultsPanel)component;
                String string = this.component.getResultTitle();
                String string2 = "You are about to dispose of " + string + ".\nDo you wish to continue?";
                int n = JOptionPane.showOptionDialog((Component)Cytoscape.getDesktop(), new Object[]{string2}, "Confirm", 0, 3, null, null, null);
                if (n == 0) {
                    cytoPanel.remove(component);
                    MCODECurrentParameters.removeResultParams(string);
                    continue;
                }
                bl = false;
            }
            if (cytoPanel.getCytoPanelComponentCount() == 0) {
                cytoPanel.setState(CytoPanelState.HIDE);
            }
            if (bl) {
                cytoPanel = cytoscapeDesktop.getCytoPanel(7);
                cytoPanel.remove((Component)this.mainPanel);
                MCODEMainPanel.this.trigger.setOpened(false);
            }
        }
    }

    private class ClusterFindingAction
    extends AbstractAction {
        private ClusterFindingAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (MCODEMainPanel.this.optimizeOption.isSelected()) {
                MCODEMainPanel.this.currentParamsCopy.setOptimize(true);
            } else {
                MCODEMainPanel.this.currentParamsCopy.setOptimize(false);
            }
        }
    }

    private class ScopeAction
    extends AbstractAction {
        private ScopeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            MCODEMainPanel.this.currentParamsCopy.setScope(string);
        }
    }
}

