/*
 * Decompiled with CFR 0.152.
 */
package csplugins.mcode;

import csplugins.mcode.MCODEAlgorithm;
import csplugins.mcode.SpringEmbeddedLayouter;
import cytoscape.CyNetwork;
import giny.model.GraphPerspective;
import giny.model.Node;
import giny.view.EdgeView;
import giny.view.GraphView;
import giny.view.NodeView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import javax.swing.JOptionPane;
import phoebe.PGraphView;

public class MCODEUtil {
    public static Image convertNetworkToImage(GraphPerspective graphPerspective, int n, int n2) {
        NodeView nodeView;
        PGraphView pGraphView = new PGraphView(graphPerspective);
        Iterator iterator = pGraphView.getNodeViewsIterator();
        while (iterator.hasNext()) {
            nodeView = (NodeView)iterator.next();
            String string = nodeView.getNode().getIdentifier();
            nodeView.getLabel().setText(string);
            nodeView.setWidth(40.0);
            nodeView.setHeight(40.0);
            nodeView.setShape(2);
            nodeView.setUnselectedPaint((Paint)Color.red);
            nodeView.setBorderPaint((Paint)Color.black);
            nodeView.setXPosition(pGraphView.getCanvas().getLayer().getGlobalFullBounds().getWidth() * Math.random());
            nodeView.setYPosition((pGraphView.getCanvas().getLayer().getGlobalFullBounds().getHeight() + 100.0) * Math.random());
        }
        iterator = pGraphView.getEdgeViewsIterator();
        while (iterator.hasNext()) {
            nodeView = (EdgeView)iterator.next();
            nodeView.setUnselectedPaint((Paint)Color.blue);
            nodeView.setTargetEdgeEnd(5);
            nodeView.setTargetEdgeEndPaint((Paint)Color.CYAN);
            nodeView.setSourceEdgeEndPaint((Paint)Color.CYAN);
            nodeView.setStroke((Stroke)new BasicStroke(5.0f));
        }
        SpringEmbeddedLayouter springEmbeddedLayouter = new SpringEmbeddedLayouter((GraphView)pGraphView);
        springEmbeddedLayouter.doLayout();
        Image image = pGraphView.getCanvas().getLayer().toImage(n2, n, null);
        double d = pGraphView.getCanvas().getLayer().getFullBounds().width;
        if (pGraphView.getCanvas().getLayer().getFullBounds().height > d) {
            d = pGraphView.getCanvas().getLayer().getFullBounds().height;
        }
        return image;
    }

    public static GraphPerspective convertComplexToNetwork(ArrayList arrayList, CyNetwork cyNetwork) {
        int[] nArray = MCODEUtil.convertIntArrayList2array(arrayList);
        GraphPerspective graphPerspective = cyNetwork.createGraphPerspective(nArray);
        return graphPerspective;
    }

    public static GraphPerspective[] convertComplexListToSortedNetworkList(ArrayList arrayList, CyNetwork cyNetwork, final MCODEAlgorithm mCODEAlgorithm) {
        GraphPerspective[] graphPerspectiveArray = new GraphPerspective[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            graphPerspectiveArray[i] = MCODEUtil.convertComplexToNetwork((ArrayList)arrayList.get(i), cyNetwork);
        }
        Arrays.sort(graphPerspectiveArray, new Comparator(){

            public int compare(Object object, Object object2) {
                double d;
                double d2 = mCODEAlgorithm.scoreComplex((GraphPerspective)object);
                if (d2 == (d = mCODEAlgorithm.scoreComplex((GraphPerspective)object2))) {
                    return 0;
                }
                if (d2 < d) {
                    return 1;
                }
                return -1;
            }
        });
        return graphPerspectiveArray;
    }

    private static int[] convertIntArrayList2array(ArrayList arrayList) {
        int[] nArray = new int[arrayList.size()];
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            nArray[n] = (Integer)iterator.next();
            ++n;
        }
        return nArray;
    }

    public static StringBuffer getNodeNameList(GraphPerspective graphPerspective) {
        Iterator iterator = graphPerspective.nodesIterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            stringBuffer.append(node.getIdentifier());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer;
    }

    public static boolean saveMCODEResults(MCODEAlgorithm mCODEAlgorithm, ArrayList arrayList, CyNetwork cyNetwork, String string) {
        if (mCODEAlgorithm == null || arrayList == null || cyNetwork == null || string == null) {
            return false;
        }
        String string2 = System.getProperty("line.separator");
        try {
            File file = new File(string);
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write("MCODE Plugin Results" + string2);
            fileWriter.write("Date: " + DateFormat.getDateTimeInstance().format(new Date()) + string2 + string2);
            fileWriter.write("Parameters:" + string2 + mCODEAlgorithm.getParams().toString() + string2);
            fileWriter.write("Complex\tScore (Density*#Proteins)\tProteins\tInteractions\tProtein names" + string2);
            GraphPerspective[] graphPerspectiveArray = MCODEUtil.convertComplexListToSortedNetworkList(arrayList, cyNetwork, mCODEAlgorithm);
            for (int i = 0; i < graphPerspectiveArray.length; ++i) {
                GraphPerspective graphPerspective = graphPerspectiveArray[i];
                fileWriter.write(i + 1 + "\t");
                NumberFormat numberFormat = NumberFormat.getInstance();
                numberFormat.setMaximumFractionDigits(3);
                fileWriter.write(numberFormat.format(mCODEAlgorithm.scoreComplex(graphPerspective)) + "\t");
                fileWriter.write(graphPerspective.getNodeCount() + "\t");
                fileWriter.write(graphPerspective.getEdgeCount() + "\t");
                fileWriter.write(MCODEUtil.getNodeNameList(graphPerspective).toString() + string2);
            }
            fileWriter.close();
            return true;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, iOException.toString(), "Error Writing to \"" + string + "\"", 0);
            return false;
        }
    }
}

