/*
 * Decompiled with CFR 0.152.
 */
package csplugins.mcode;

import csplugins.mcode.MCODECurrentParameters;
import csplugins.mcode.MCODEParameterSet;
import cytoscape.CyNetwork;
import cytoscape.task.TaskMonitor;
import giny.model.GraphPerspective;
import giny.model.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

public class MCODEAlgorithm {
    private boolean cancelled = false;
    private TaskMonitor taskMonitor = null;
    private HashMap nodeInfoHashMap = null;
    private TreeMap nodeScoreSortedMap = null;
    private MCODEParameterSet params = MCODECurrentParameters.getInstance().getParamsCopy();
    private long lastScoreTime;
    private long lastFindTime;

    public MCODEAlgorithm() {
    }

    public MCODEAlgorithm(TaskMonitor taskMonitor) {
        this();
        this.taskMonitor = taskMonitor;
    }

    public long getLastScoreTime() {
        return this.lastScoreTime;
    }

    public long getLastFindTime() {
        return this.lastFindTime;
    }

    public MCODEParameterSet getParams() {
        return this.params;
    }

    public void setCancelled(boolean bl) {
        this.cancelled = bl;
    }

    public void scoreGraph(CyNetwork cyNetwork) {
        String string = "MCODEAlgorithm.MCODEAlgorithm";
        if (cyNetwork == null) {
            System.err.println("In " + string + ": inputNetwork was null.");
            return;
        }
        long l = System.currentTimeMillis();
        this.nodeInfoHashMap = new HashMap(cyNetwork.getNodeCount());
        this.nodeScoreSortedMap = new TreeMap(new Comparator(){

            public int compare(Object object, Object object2) {
                double d;
                double d2 = (Double)object;
                if (d2 == (d = ((Double)object2).doubleValue())) {
                    return 0;
                }
                if (d2 < d) {
                    return 1;
                }
                return -1;
            }
        });
        NodeInfo nodeInfo = null;
        int n = 0;
        Iterator iterator = cyNetwork.nodesIterator();
        while (iterator.hasNext() && !this.cancelled) {
            ArrayList arrayList;
            Node node = (Node)iterator.next();
            nodeInfo = this.calcNodeInfo(cyNetwork, node.getRootGraphIndex());
            this.nodeInfoHashMap.put(new Integer(node.getRootGraphIndex()), nodeInfo);
            double d = this.scoreNode(nodeInfo);
            cyNetwork.setNodeAttributeValue(node, "MCODE_SCORE", (Object)new Double(d));
            if (this.nodeScoreSortedMap.containsKey(new Double(d))) {
                arrayList = (ArrayList)this.nodeScoreSortedMap.get(new Double(d));
                arrayList.add(new Integer(node.getRootGraphIndex()));
            } else {
                arrayList = new ArrayList();
                arrayList.add(new Integer(node.getRootGraphIndex()));
                this.nodeScoreSortedMap.put(new Double(d), arrayList);
            }
            if (this.taskMonitor == null) continue;
            this.taskMonitor.setPercentCompleted(++n * 100 / cyNetwork.getNodeCount());
        }
        long l2 = System.currentTimeMillis();
        this.lastScoreTime = l2 - l;
    }

    public ArrayList findComplexes(CyNetwork cyNetwork) {
        String string = "MCODEAlgorithm.findComplexes";
        if (cyNetwork == null) {
            System.err.println("In " + string + ": inputNetwork was null.");
            return null;
        }
        if (this.nodeInfoHashMap == null || this.nodeScoreSortedMap == null) {
            System.err.println("In " + string + ": nodeInfoHashMap or nodeScoreSortedMap was null.");
            return null;
        }
        long l = System.currentTimeMillis();
        HashMap hashMap = new HashMap();
        int n = 0;
        Collection collection = this.nodeScoreSortedMap.values();
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ArrayList arrayList2 = (ArrayList)iterator.next();
            for (int i = 0; i < arrayList2.size(); ++i) {
                ArrayList arrayList3;
                Integer n2 = (Integer)arrayList2.get(i);
                if (hashMap.containsKey(n2) || (arrayList3 = this.getComplexCore(n2, hashMap)).size() <= 0) continue;
                if (!arrayList3.contains(n2)) {
                    arrayList3.add(n2);
                }
                int[] nArray = new int[arrayList3.size()];
                for (int j = 0; j < arrayList3.size(); ++j) {
                    int n3;
                    nArray[j] = n3 = ((Integer)arrayList3.get(j)).intValue();
                }
                GraphPerspective graphPerspective = cyNetwork.createGraphPerspective(nArray);
                if (this.filterComplex(graphPerspective)) continue;
                if (this.params.isHaircut()) {
                    this.haircutComplex(graphPerspective, arrayList3, (GraphPerspective)cyNetwork);
                }
                if (this.params.isFluff()) {
                    this.fluffComplexBoundary(arrayList3, hashMap);
                }
                arrayList.add(arrayList3);
            }
            if (this.taskMonitor != null) {
                this.taskMonitor.setPercentCompleted(++n * 100 / this.nodeScoreSortedMap.size());
            }
            if (!this.cancelled) continue;
        }
        long l2 = System.currentTimeMillis();
        this.lastFindTime = l2 - l;
        return arrayList;
    }

    private double scoreNode(NodeInfo nodeInfo) {
        nodeInfo.score = nodeInfo.numNodeNeighbors > this.params.getDegreeCutOff() ? nodeInfo.coreDensity * (double)nodeInfo.coreLevel : 0.0;
        return nodeInfo.score;
    }

    public double scoreComplex(GraphPerspective graphPerspective) {
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        n = graphPerspective.getNodeCount();
        d = this.calcDensity(graphPerspective, true);
        d2 = d * (double)n;
        return d2;
    }

    private NodeInfo calcNodeInfo(CyNetwork cyNetwork, int n) {
        int[] nArray;
        String string = "MCODEAlgorithm.calcNodeInfo";
        if (cyNetwork == null) {
            System.err.println("In " + string + ": gpInputGraph was null.");
            return null;
        }
        int[] nArray2 = cyNetwork.neighborsArray(n);
        if (nArray2.length < 2) {
            NodeInfo nodeInfo = new NodeInfo();
            if (nArray2.length == 1) {
                nodeInfo.coreLevel = 1;
                nodeInfo.coreDensity = 1.0;
                nodeInfo.density = 1.0;
            }
            return nodeInfo;
        }
        Arrays.sort(nArray2);
        if (Arrays.binarySearch(nArray2, n) < 0) {
            nArray = new int[nArray2.length + 1];
            System.arraycopy(nArray2, 0, nArray, 1, nArray2.length);
            nArray[0] = n;
        } else {
            nArray = nArray2;
        }
        GraphPerspective graphPerspective = cyNetwork.createGraphPerspective(nArray);
        if (graphPerspective == null) {
            System.err.println("In " + string + ": gpNodeNeighborhood was null.");
            return null;
        }
        NodeInfo nodeInfo = new NodeInfo();
        if (graphPerspective != null) {
            nodeInfo.density = this.calcDensity(graphPerspective, this.params.isIncludeLoops());
        }
        nodeInfo.numNodeNeighbors = nArray.length;
        GraphPerspective graphPerspective2 = null;
        Integer n2 = null;
        Object[] objectArray = this.getHighestKCore(graphPerspective);
        n2 = (Integer)objectArray[0];
        graphPerspective2 = (GraphPerspective)objectArray[1];
        nodeInfo.coreLevel = n2;
        if (graphPerspective2 != null) {
            nodeInfo.coreDensity = this.calcDensity(graphPerspective2, this.params.isIncludeLoops());
        }
        nodeInfo.nodeNeighbors = nArray;
        return nodeInfo;
    }

    private ArrayList getComplexCore(Integer n, HashMap hashMap) {
        ArrayList arrayList = new ArrayList();
        this.getComplexCoreInternal(n, hashMap, ((NodeInfo)this.nodeInfoHashMap.get((Object)n)).score, 1, arrayList);
        return arrayList;
    }

    private boolean getComplexCoreInternal(Integer n, HashMap hashMap, double d, int n2, ArrayList arrayList) {
        if (hashMap.containsKey(n)) {
            return true;
        }
        if (n2 > this.params.getMaxDepthFromStart()) {
            return true;
        }
        int n3 = 0;
        hashMap.put(n, new Boolean(true));
        for (n3 = 0; n3 < ((NodeInfo)this.nodeInfoHashMap.get((Object)n)).numNodeNeighbors; ++n3) {
            Integer n4 = new Integer(((NodeInfo)this.nodeInfoHashMap.get((Object)n)).nodeNeighbors[n3]);
            if (hashMap.containsKey(n4) || !(((NodeInfo)this.nodeInfoHashMap.get((Object)n4)).score >= d - d * this.params.getNodeScoreCutOff())) continue;
            if (!arrayList.contains(n4)) {
                arrayList.add(n4);
            }
            this.getComplexCoreInternal(n4, hashMap, d, n2 + 1, arrayList);
        }
        return true;
    }

    private boolean fluffComplexBoundary(ArrayList arrayList, HashMap hashMap) {
        int n = 0;
        int n2 = 0;
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        HashMap<Integer, Boolean> hashMap2 = new HashMap<Integer, Boolean>();
        for (int i = 0; i < arrayList.size(); ++i) {
            n = (Integer)arrayList.get(i);
            for (int j = 0; j < ((NodeInfo)this.nodeInfoHashMap.get((Object)new Integer((int)n))).numNodeNeighbors; ++j) {
                n2 = ((NodeInfo)this.nodeInfoHashMap.get((Object)new Integer((int)n))).nodeNeighbors[j];
                if (hashMap.containsKey(new Integer(n2)) || hashMap2.containsKey(new Integer(n2))) continue;
                Integer n3 = new Integer(n2);
                if (!(((NodeInfo)this.nodeInfoHashMap.get((Object)n3)).density > this.params.getFluffNodeDensityCutOff())) continue;
                arrayList2.add(new Integer(n2));
                hashMap2.put(new Integer(n2), new Boolean(true));
            }
        }
        if (arrayList2.size() > 0) {
            arrayList.addAll(arrayList2.subList(0, arrayList2.size()));
        }
        return true;
    }

    private boolean filterComplex(GraphPerspective graphPerspective) {
        if (graphPerspective == null) {
            return true;
        }
        GraphPerspective graphPerspective2 = this.getKCore(graphPerspective, 2);
        return graphPerspective2 == null;
    }

    private boolean haircutComplex(GraphPerspective graphPerspective, ArrayList arrayList, GraphPerspective graphPerspective2) {
        GraphPerspective graphPerspective3 = this.getKCore(graphPerspective, 2);
        if (graphPerspective3 != null) {
            arrayList.clear();
            int[] nArray = graphPerspective3.getNodeIndicesArray();
            for (int i = 0; i < nArray.length; ++i) {
                arrayList.add(new Integer(graphPerspective2.getRootGraphNodeIndex(nArray[i])));
            }
        }
        return true;
    }

    public double calcDensity(GraphPerspective graphPerspective, boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        double d = 0.0;
        String string = "MCODEAlgorithm.calcDensity";
        if (graphPerspective == null) {
            System.err.println("In " + string + ": gpInputGraph was null.");
            return -1.0;
        }
        if (bl) {
            Iterator iterator = graphPerspective.nodesIterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                if (!graphPerspective.isNeighbor(node, node)) continue;
                ++n3;
            }
            n = graphPerspective.getNodeCount() * graphPerspective.getNodeCount();
            n2 = graphPerspective.getEdgeCount() - n3;
        } else {
            n = graphPerspective.getNodeCount() * graphPerspective.getNodeCount();
            n2 = graphPerspective.getEdgeCount();
        }
        d = (double)n2 / (double)n;
        return d;
    }

    public GraphPerspective getKCore(GraphPerspective graphPerspective, int n) {
        String string = "MCODEAlgorithm.getKCore";
        if (graphPerspective == null) {
            System.err.println("In " + string + ": gpInputGraph was null.");
            return null;
        }
        boolean bl = true;
        GraphPerspective graphPerspective2 = null;
        while (true) {
            Object object;
            int n2 = 0;
            ArrayList<Integer> arrayList = new ArrayList<Integer>(graphPerspective.getNodeCount());
            Iterator iterator = graphPerspective.nodesIterator();
            while (iterator.hasNext()) {
                object = (Node)iterator.next();
                if (graphPerspective.getDegree(object) >= n) {
                    arrayList.add(new Integer(object.getRootGraphIndex()));
                    continue;
                }
                ++n2;
            }
            if (n2 <= 0 && !bl) break;
            object = new int[arrayList.size()];
            int n3 = 0;
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                object[n3] = (Node)((Integer)iterator2.next());
                ++n3;
            }
            graphPerspective2 = graphPerspective.createGraphPerspective((int[])object);
            if (graphPerspective2.getNodeCount() == 0) {
                return null;
            }
            graphPerspective = graphPerspective2;
            if (!bl) continue;
            bl = false;
        }
        return graphPerspective2;
    }

    public Object[] getHighestKCore(GraphPerspective graphPerspective) {
        String string = "MCODEAlgorithm.getHighestKCore";
        if (graphPerspective == null) {
            System.err.println("In " + string + ": gpInputGraph was null.");
            return null;
        }
        int n = 1;
        GraphPerspective graphPerspective2 = null;
        GraphPerspective graphPerspective3 = null;
        while ((graphPerspective2 = this.getKCore(graphPerspective, n)) != null) {
            graphPerspective = graphPerspective2;
            graphPerspective3 = graphPerspective2;
            ++n;
        }
        Integer n2 = new Integer(n - 1);
        Object[] objectArray = new Object[]{n2, graphPerspective3};
        return objectArray;
    }

    private class NodeInfo {
        double density = 0.0;
        int numNodeNeighbors = 0;
        int[] nodeNeighbors;
        int coreLevel = 0;
        double coreDensity = 0.0;
        double score;
    }
}

