/*
 * Decompiled with CFR 0.152.
 */
package csplugins.mcode;

import csplugins.mcode.MCODEAlgorithm;
import csplugins.mcode.MCODECurrentParameters;
import csplugins.mcode.MCODEUtil;
import cytoscape.CyNetwork;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import giny.model.GraphPerspective;
import java.awt.Image;
import java.util.ArrayList;

public class MCODEScoreAndFindTask
implements Task {
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;
    private CyNetwork network = null;
    private MCODEAlgorithm alg = null;
    private ArrayList clusters = null;
    private Image[] imageList = null;
    private boolean completedSuccessfully = false;

    public MCODEScoreAndFindTask(CyNetwork cyNetwork) {
        this.network = cyNetwork;
    }

    public void run() {
        if (this.taskMonitor == null) {
            throw new IllegalStateException("Task Monitor is not set.");
        }
        try {
            this.alg = new MCODEAlgorithm(this.taskMonitor);
            this.taskMonitor.setPercentCompleted(0);
            this.taskMonitor.setStatus("Scoring Network (Step 1 of 3)");
            this.alg.scoreGraph(this.network);
            if (this.interrupted) {
                this.network.putClientData("MCODE_running", (Object)new Boolean(false));
                return;
            }
            System.err.println("Network was scored in " + this.alg.getLastScoreTime() + " ms.");
            this.taskMonitor.setPercentCompleted(0);
            this.taskMonitor.setStatus("Finding Clusters (Step 2 of 3)");
            this.clusters = this.alg.findComplexes(this.network);
            if (this.interrupted) {
                this.network.putClientData("MCODE_running", (Object)new Boolean(false));
                return;
            }
            this.network.putClientData("MCODE_alg", (Object)this.alg);
            this.taskMonitor.setPercentCompleted(0);
            this.taskMonitor.setStatus("Drawing Results (Step 3 of 3)");
            GraphPerspective[] graphPerspectiveArray = MCODEUtil.convertComplexListToSortedNetworkList(this.clusters, this.network, this.alg);
            this.imageList = new Image[this.clusters.size()];
            int n = MCODECurrentParameters.getInstance().getParamsCopy().getDefaultRowHeight();
            for (int i = 0; i < graphPerspectiveArray.length; ++i) {
                if (this.interrupted) {
                    this.network.putClientData("MCODE_running", (Object)new Boolean(false));
                    return;
                }
                this.imageList[i] = MCODEUtil.convertNetworkToImage(graphPerspectiveArray[i], n, n);
                this.taskMonitor.setPercentCompleted(i * 100 / graphPerspectiveArray.length);
            }
            this.completedSuccessfully = true;
        }
        catch (Exception exception) {
            this.network.putClientData("MCODE_running", (Object)new Boolean(false));
            this.taskMonitor.setException((Throwable)exception, "MCODE cancelled");
        }
    }

    public boolean isCompletedSuccessfully() {
        return this.completedSuccessfully;
    }

    public ArrayList getClusters() {
        return this.clusters;
    }

    public Image[] getImageList() {
        return this.imageList;
    }

    public void halt() {
        this.interrupted = true;
        this.alg.setCancelled(true);
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) throws IllegalThreadStateException {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("MCODE Network Cluster Detection");
    }
}

