/*
 * Decompiled with CFR 0.152.
 */
package csplugins.mcode;

import csplugins.mcode.JMultiLineToolTip;
import csplugins.mcode.MCODEAlgorithm;
import csplugins.mcode.MCODEUtil;
import csplugins.mcode.SwingWorker;
import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.actions.GinyUtils;
import cytoscape.view.CyNetworkView;
import giny.model.GraphPerspective;
import giny.model.Node;
import giny.util.SpringEmbeddedLayouter;
import giny.view.GraphView;
import giny.view.NodeView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolTip;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import phoebe.PGraphView;

public class MCODEResultsDialog
extends JDialog {
    MCODEResultsDialog parentDialog = this;
    protected JTable table;
    JScrollPane scrollPane;
    protected MCODEResultsTableModel model;
    protected final int defaultRowHeight = 80;
    protected final int preferredTableHeight = 240;
    protected int preferredTableWidth = 0;
    protected boolean openAsNewChild = false;
    protected GraphPerspective[] gpComplexArray;
    CyNetwork originalInputNetwork;
    CyNetworkView originalInputNetworkView;
    HashMap hmNetworkNames;
    MCODEAlgorithm alg;

    public MCODEResultsDialog(Frame frame, ArrayList arrayList, CyNetwork cyNetwork, Image[] imageArray) {
        super(frame, "MCODE Results Summary", false);
        this.originalInputNetwork = cyNetwork;
        this.alg = (MCODEAlgorithm)cyNetwork.getClientData("MCODE_alg");
        this.originalInputNetworkView = Cytoscape.getNetworkView((String)cyNetwork.getIdentifier());
        this.hmNetworkNames = new HashMap();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.model = new MCODEResultsTableModel(cyNetwork, arrayList, imageArray);
        this.table = new JTable(this.model){

            public String getToolTipText(MouseEvent mouseEvent) {
                String string = null;
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                int n3 = this.convertColumnIndexToModel(n2);
                if (n3 == 2) {
                    String string2 = (String)this.getValueAt(n, n2);
                    String string3 = null;
                    String string4 = null;
                    int n4 = 0;
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string5 = stringTokenizer.nextToken();
                        if (n4 == 0) {
                            string3 = string5;
                        } else if (n4 == 1) {
                            string4 = string5;
                        }
                        ++n4;
                    }
                    string = "Complex has " + string3 + " nodes and " + string4 + " edges.";
                }
                return string;
            }
        };
        this.table.setRowHeight(80);
        this.initColumnSizes(this.table);
        this.table.setPreferredScrollableViewportSize(new Dimension(this.preferredTableWidth, 240));
        this.table.setSelectionMode(0);
        this.table.setDefaultRenderer(String.class, new CenterAndBoldRenderer());
        this.table.setDefaultRenderer(StringBuffer.class, new JTextAreaRenderer());
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.addListSelectionListener(new TableRowSelectionHandler());
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.getViewport().setBackground(Color.WHITE);
        jPanel.add((Component)this.scrollPane, "Center");
        JPanel jPanel2 = new JPanel();
        JCheckBox jCheckBox = new JCheckBox("Create a new child network.", false){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        jCheckBox.addItemListener(new newWindowCheckBoxAction());
        jCheckBox.setToolTipText("If checked, will create a new child network of the selected complex.\nIf not checked, will just select complexes in the main window.");
        jPanel2.add((Component)jCheckBox, "West");
        JButton jButton = new JButton("Save");
        jButton.addActionListener(new SaveAction(this, arrayList, cyNetwork));
        jButton.setToolTipText("Save result summary to a file");
        jPanel2.add((Component)jButton, "Center");
        JButton jButton2 = new JButton("Done");
        jButton2.addActionListener(new OKAction(this));
        jPanel2.add((Component)jButton2, "East");
        jPanel.add((Component)jPanel2, "South");
        this.setContentPane(jPanel);
    }

    private void initColumnSizes(JTable jTable) {
        TableColumn tableColumn = null;
        for (int i = 0; i < 5; ++i) {
            tableColumn = jTable.getColumnModel().getColumn(i);
            if (i == 0 || i == 1 || i == 2) {
                tableColumn.sizeWidthToFit();
            } else if (i == 3) {
                tableColumn.setPreferredWidth(100);
            } else if (i == 4) {
                tableColumn.setPreferredWidth(80);
            }
            this.preferredTableWidth += tableColumn.getPreferredWidth();
        }
    }

    private class JTextAreaRenderer
    extends JTextArea
    implements TableCellRenderer {
        public JTextAreaRenderer() {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setEditable(false);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            StringBuffer stringBuffer = (StringBuffer)object;
            this.setText(stringBuffer.toString());
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            int n3 = jTable.getRowHeight(n);
            this.setSize(jTable.getColumnModel().getColumn(n2).getWidth(), n3);
            int n4 = (int)this.getPreferredSize().getHeight();
            if (n3 < n4) {
                jTable.setRowHeight(n, n4);
            } else if (n3 > n4 && n3 != 80) {
                jTable.setRowHeight(n, 80);
            }
            return this;
        }
    }

    private class CenterAndBoldRenderer
    extends DefaultTableCellRenderer {
        private CenterAndBoldRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            component.setFont(new Font(this.getFont().getFontName(), 1, 14));
            this.setHorizontalAlignment(0);
            return component;
        }
    }

    private class TableRowSelectionHandler
    implements ListSelectionListener {
        private TableRowSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (!listSelectionModel.isSelectionEmpty()) {
                Object object;
                Object object2;
                int n = listSelectionModel.getMinSelectionIndex();
                GraphPerspective graphPerspective = MCODEResultsDialog.this.gpComplexArray[n];
                if (MCODEResultsDialog.this.originalInputNetworkView != null) {
                    GinyUtils.deselectAllNodes((GraphView)MCODEResultsDialog.this.originalInputNetworkView);
                    object2 = graphPerspective.nodesList();
                    for (int i = 0; i < object2.size(); ++i) {
                        object = (Node)object2.get(i);
                        if (!MCODEResultsDialog.this.originalInputNetwork.containsNode(object)) continue;
                        NodeView nodeView = MCODEResultsDialog.this.originalInputNetworkView.getNodeView(object);
                        nodeView.setSelected(true);
                    }
                    if (!MCODEResultsDialog.this.openAsNewChild) {
                        Cytoscape.getDesktop().setFocus(MCODEResultsDialog.this.originalInputNetworkView.getIdentifier());
                    }
                } else if (!MCODEResultsDialog.this.openAsNewChild) {
                    JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "You must have a network view created to select nodes.");
                }
                if (MCODEResultsDialog.this.openAsNewChild) {
                    object2 = NumberFormat.getInstance();
                    ((NumberFormat)object2).setMaximumFractionDigits(3);
                    String string = "Complex " + (n + 1) + " Score: " + ((NumberFormat)object2).format(MCODEResultsDialog.this.alg.scoreComplex(graphPerspective));
                    object = (String)MCODEResultsDialog.this.hmNetworkNames.get(new Integer(n + 1));
                    if (object != null) {
                        Cytoscape.getDesktop().setFocus((String)object);
                    } else {
                        SwingWorker swingWorker = new SwingWorker(this, graphPerspective, string, n){
                            private final /* synthetic */ GraphPerspective val$gpComplex;
                            private final /* synthetic */ String val$title;
                            private final /* synthetic */ int val$selectedRow;
                            private final /* synthetic */ TableRowSelectionHandler this$1;
                            {
                                this.this$1 = tableRowSelectionHandler;
                                this.val$gpComplex = graphPerspective;
                                this.val$title = string;
                                this.val$selectedRow = n;
                            }

                            public Object construct() {
                                CyNetwork cyNetwork = Cytoscape.createNetwork((int[])this.val$gpComplex.getNodeIndicesArray(), (int[])this.val$gpComplex.getEdgeIndicesArray(), (String)this.val$title, (CyNetwork)TableRowSelectionHandler.access$300((TableRowSelectionHandler)this.this$1).originalInputNetwork);
                                TableRowSelectionHandler.access$300((TableRowSelectionHandler)this.this$1).hmNetworkNames.put(new Integer(this.val$selectedRow + 1), cyNetwork.getIdentifier());
                                PGraphView pGraphView = (PGraphView)Cytoscape.createNetworkView((CyNetwork)cyNetwork);
                                Iterator iterator = pGraphView.getNodeViewsIterator();
                                while (iterator.hasNext()) {
                                    NodeView nodeView = (NodeView)iterator.next();
                                    nodeView.setXPosition(pGraphView.getCanvas().getLayer().getGlobalFullBounds().getWidth() * Math.random());
                                    nodeView.setYPosition((pGraphView.getCanvas().getLayer().getGlobalFullBounds().getHeight() + 100.0) * Math.random());
                                }
                                iterator = new SpringEmbeddedLayouter((GraphView)pGraphView);
                                iterator.doLayout();
                                pGraphView.fitContent();
                                return null;
                            }
                        };
                        swingWorker.start();
                    }
                }
            }
        }

        static /* synthetic */ MCODEResultsDialog access$300(TableRowSelectionHandler tableRowSelectionHandler) {
            return tableRowSelectionHandler.MCODEResultsDialog.this;
        }
    }

    private class newWindowCheckBoxAction
    implements ItemListener {
        private newWindowCheckBoxAction() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            MCODEResultsDialog.this.openAsNewChild = itemEvent.getStateChange() != 2;
        }
    }

    private class SaveAction
    extends AbstractAction {
        private JDialog popup;
        private ArrayList complexes;
        private CyNetwork network;

        SaveAction(JDialog jDialog, ArrayList arrayList, CyNetwork cyNetwork) {
            super("");
            this.popup = jDialog;
            this.complexes = arrayList;
            this.network = cyNetwork;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = Cytoscape.getCytoscapeObj().getCurrentDirectory();
            JFileChooser jFileChooser = new JFileChooser(file);
            if (jFileChooser.showSaveDialog(this.popup) == 0) {
                String string = jFileChooser.getSelectedFile().toString();
                file = jFileChooser.getCurrentDirectory();
                Cytoscape.getCytoscapeObj().setCurrentDirectory(file);
                MCODEUtil.saveMCODEResults(MCODEResultsDialog.this.alg, this.complexes, this.network, string);
            }
        }
    }

    private class OKAction
    extends AbstractAction {
        private JDialog dialog;

        OKAction(JDialog jDialog) {
            super("");
            this.dialog = jDialog;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MCODEResultsDialog.this.originalInputNetwork.putClientData("MCODE_running", (Object)new Boolean(false));
            this.dialog.dispose();
        }
    }

    private class MCODEResultsTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{"Rank", "Score", "Size", "Names", "Complex"};
        Object[][] data;

        public MCODEResultsTableModel(CyNetwork cyNetwork, ArrayList arrayList, Image[] imageArray) {
            MCODEResultsDialog.this.gpComplexArray = MCODEUtil.convertComplexListToSortedNetworkList(arrayList, cyNetwork, MCODEResultsDialog.this.alg);
            this.data = new Object[MCODEResultsDialog.this.gpComplexArray.length][this.columnNames.length];
            for (int i = 0; i < MCODEResultsDialog.this.gpComplexArray.length; ++i) {
                GraphPerspective graphPerspective = MCODEResultsDialog.this.gpComplexArray[i];
                this.data[i][0] = new String(new Integer(i + 1).toString());
                NumberFormat numberFormat = NumberFormat.getInstance();
                numberFormat.setMaximumFractionDigits(3);
                this.data[i][1] = numberFormat.format(MCODEResultsDialog.this.alg.scoreComplex(graphPerspective));
                this.data[i][2] = new String(graphPerspective.getNodeCount() + "," + graphPerspective.getEdgeCount());
                this.data[i][3] = MCODEUtil.getNodeNameList(graphPerspective);
                Image image = imageArray != null ? imageArray[i] : MCODEUtil.convertNetworkToImage(graphPerspective, 80, 80);
                this.data[i][4] = new ImageIcon(image);
            }
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }
}

