/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.services.app;

import java.awt.datatransfer.Transferable;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.freehep.application.Application;
import org.freehep.application.services.FileAccess;
import org.freehep.application.services.ServiceManager;
import org.freehep.application.services.app.AppFileAccess;

public class AppServiceManager
implements ServiceManager {
    private PrinterJob pj;
    protected Application app = Application.getApplication();

    public PageFormat getDefaultPage() {
        if (this.pj == null) {
            this.pj = this.createPrintJob();
        }
        return this.pj.defaultPage();
    }

    public PageFormat showPageFormatDialog(PageFormat page) {
        if (this.pj == null) {
            this.pj = this.createPrintJob();
        }
        return this.pj.pageDialog(page);
    }

    public boolean print(Printable painter) {
        if (this.pj == null) {
            this.pj = this.createPrintJob();
        }
        this.pj.setPrintable(painter);
        return this.print();
    }

    public boolean print(Pageable document) {
        if (this.pj == null) {
            this.pj = this.createPrintJob();
        }
        this.pj.setPageable(document);
        return this.print();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean print() {
        if (!this.pj.printDialog()) {
            return false;
        }
        try {
            try {
                this.pj.print();
                Object var2_1 = null;
                this.pj = null;
                return true;
            }
            catch (PrinterException p) {
                Object var2_2 = null;
                this.pj = null;
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.pj = null;
            throw throwable;
        }
    }

    private PrinterJob createPrintJob() {
        return PrinterJob.getPrinterJob();
    }

    private String userPrefFile() {
        return this.app.getAppProperties().getProperty("userPrefDir");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadUserPreferences(Properties props) {
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.userPrefFile()));
            try {
                props.load(in);
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                ((InputStream)in).close();
                throw throwable;
            }
            {
                Object var3_6 = null;
                ((InputStream)in).close();
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void storeUserPreferences(Properties props) {
        try {
            File parent;
            File f = new File(this.userPrefFile());
            if (!f.exists() && !(parent = f.getParentFile()).exists()) {
                parent.mkdirs();
            }
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.userPrefFile()));
            try {
                props.store(out, String.valueOf(this.app.getAppName()) + " User Properties");
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                ((OutputStream)out).close();
                throw throwable;
            }
            {
                Object var4_7 = null;
                ((OutputStream)out).close();
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public FileAccess openFileDialog(FileFilter[] filters, FileFilter defaultFilter, String key) {
        String dir;
        JFileChooser dlg = new JFileChooser();
        Properties user = this.app.getUserProperties();
        if (key != null && (dir = user.getProperty(key)) != null) {
            dlg.setCurrentDirectory(new File(dir));
        }
        if (filters != null) {
            int i = 0;
            while (i < filters.length) {
                dlg.addChoosableFileFilter(filters[i]);
                ++i;
            }
        }
        if (defaultFilter != null) {
            dlg.setFileFilter(defaultFilter);
        }
        if (dlg.showOpenDialog(this.app) == 0) {
            File file = dlg.getSelectedFile();
            if (key != null) {
                user.setProperty(key, file.getAbsolutePath());
            }
            return new AppFileAccess(file);
        }
        return null;
    }

    public FileAccess saveFileAsDialog(FileFilter[] filters, FileFilter defaultFilter, String key, InputStream in) {
        String dir;
        JFileChooser dlg = new JFileChooser();
        Properties user = this.app.getUserProperties();
        if (key != null && (dir = user.getProperty(key)) != null) {
            dlg.setCurrentDirectory(new File(dir));
        }
        if (filters != null) {
            int i = 0;
            while (i < filters.length) {
                dlg.addChoosableFileFilter(filters[i]);
                ++i;
            }
        }
        if (defaultFilter != null) {
            dlg.setFileFilter(defaultFilter);
        }
        if (dlg.showSaveDialog(this.app) == 0) {
            File file = dlg.getSelectedFile();
            if (key != null) {
                user.setProperty(key, file.getAbsolutePath());
            }
            return new AppFileAccess(file);
        }
        return null;
    }

    public boolean isAvailable(String part) {
        return true;
    }

    public boolean makeAvailable(String part) {
        return true;
    }

    public Transferable getClipboardContents() {
        return this.app.getToolkit().getSystemClipboard().getContents(null);
    }

    public void setClipboardContents(Transferable contents) {
        this.app.getToolkit().getSystemClipboard().setContents(contents, null);
    }
}

