/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings;

import cytoscape.Cytoscape;
import cytoscape.visual.mappings.MappingUtil;
import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class MappingUtilTest
extends TestCase {
    public MappingUtilTest(String name) {
        super(name);
    }

    public void testGetNodeAttributeType() throws Exception {
        MappingUtilTest.assertEquals((String)"non-existent attr ", (byte)-1, (byte)MappingUtil.getAttributeType("node", "mappingUtilTest"));
        Cytoscape.getNodeAttributes().setAttribute("id", "mappingUtilTest", "test");
        MappingUtilTest.assertEquals((String)"string attr ", (byte)4, (byte)MappingUtil.getAttributeType("node", "mappingUtilTest"));
        Cytoscape.getNodeAttributes().setAttribute("id", "mappingUtilTest2", 20);
        MappingUtilTest.assertEquals((String)"int attr ", (byte)3, (byte)MappingUtil.getAttributeType("node", "mappingUtilTest2"));
        Cytoscape.getNodeAttributes().setAttribute("id", "mappingUtilTest3", 20.5);
        MappingUtilTest.assertEquals((String)"float attr ", (byte)2, (byte)MappingUtil.getAttributeType("node", "mappingUtilTest3"));
        Cytoscape.getNodeAttributes().setAttribute("id", "mappingUtilTest4", true);
        MappingUtilTest.assertEquals((String)"bool attr ", (byte)1, (byte)MappingUtil.getAttributeType("node", "mappingUtilTest4"));
        ArrayList<String> l = new ArrayList<String>();
        l.add("asdf");
        Cytoscape.getNodeAttributes().setListAttribute("id", "mappingUtilTest5", l);
        MappingUtilTest.assertEquals((String)"list attr ", (byte)-2, (byte)MappingUtil.getAttributeType("node", "mappingUtilTest5"));
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("a", "b");
        Cytoscape.getNodeAttributes().setMapAttribute("id", "mappingUtilTest6", m);
        MappingUtilTest.assertEquals((String)"map attr ", (byte)-3, (byte)MappingUtil.getAttributeType("node", "mappingUtilTest6"));
        MappingUtilTest.assertEquals((String)"wrong base key", (byte)-1, (byte)MappingUtil.getAttributeType("junk", "mappingUtilTest2"));
    }

    public void testGetEdgeAttributeType() throws Exception {
        MappingUtilTest.assertEquals((String)"non-existent attr ", (byte)-1, (byte)MappingUtil.getAttributeType("edge", "mappingUtilTest"));
        Cytoscape.getEdgeAttributes().setAttribute("id", "mappingUtilTest", "test");
        MappingUtilTest.assertEquals((String)"string attr ", (byte)4, (byte)MappingUtil.getAttributeType("edge", "mappingUtilTest"));
        Cytoscape.getEdgeAttributes().setAttribute("id", "mappingUtilTest2", 20);
        MappingUtilTest.assertEquals((String)"int attr ", (byte)3, (byte)MappingUtil.getAttributeType("edge", "mappingUtilTest2"));
        Cytoscape.getEdgeAttributes().setAttribute("id", "mappingUtilTest3", 20.5);
        MappingUtilTest.assertEquals((String)"float attr ", (byte)2, (byte)MappingUtil.getAttributeType("edge", "mappingUtilTest3"));
        Cytoscape.getEdgeAttributes().setAttribute("id", "mappingUtilTest4", true);
        MappingUtilTest.assertEquals((String)"bool attr ", (byte)1, (byte)MappingUtil.getAttributeType("edge", "mappingUtilTest4"));
        ArrayList<String> l = new ArrayList<String>();
        l.add("asdf");
        Cytoscape.getEdgeAttributes().setListAttribute("id", "mappingUtilTest5", l);
        MappingUtilTest.assertEquals((String)"list attr ", (byte)-2, (byte)MappingUtil.getAttributeType("edge", "mappingUtilTest5"));
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("a", "b");
        Cytoscape.getEdgeAttributes().setMapAttribute("id", "mappingUtilTest6", m);
        MappingUtilTest.assertEquals((String)"map attr ", (byte)-3, (byte)MappingUtil.getAttributeType("edge", "mappingUtilTest6"));
        MappingUtilTest.assertEquals((String)"string attr ", (byte)-1, (byte)MappingUtil.getAttributeType("junk", "mappingUtilTest2"));
    }

    public void testParseObject() {
        Object o = null;
        o = MappingUtil.parseObjectType("1", (byte)3);
        MappingUtilTest.assertTrue((String)"int ", (boolean)(o instanceof Integer));
        o = null;
        o = MappingUtil.parseObjectType("1.75", (byte)2);
        MappingUtilTest.assertTrue((String)"double ", (boolean)(o instanceof Double));
        o = null;
        o = MappingUtil.parseObjectType("false", (byte)1);
        MappingUtilTest.assertTrue((String)"boolean ", (boolean)(o instanceof Boolean));
        o = null;
        o = MappingUtil.parseObjectType("homer", (byte)4);
        MappingUtilTest.assertTrue((String)"string ", (boolean)(o instanceof String));
        o = null;
        o = MappingUtil.parseObjectType("homer", (byte)-3);
        MappingUtilTest.assertTrue((String)"map ", (boolean)(o instanceof String));
        o = null;
        o = MappingUtil.parseObjectType("homer", (byte)-2);
        MappingUtilTest.assertTrue((String)"list ", (boolean)(o instanceof String));
        o = null;
        o = MappingUtil.parseObjectType("homer", (byte)75);
        MappingUtilTest.assertTrue((String)"non-existent type 75 ", (boolean)(o instanceof String));
        o = null;
        boolean caught = false;
        try {
            o = MappingUtil.parseObjectType("homer", (byte)3);
        }
        catch (NumberFormatException n) {
            caught = true;
        }
        MappingUtilTest.assertTrue((String)"caught number format excpetion", (boolean)caught);
        o = null;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(MappingUtilTest.class));
    }
}

