/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class TextFileReader {
    String filename;
    BufferedReader bufferedReader;
    StringBuffer strbuf;

    public TextFileReader(String filename) {
        this.filename = filename;
        try {
            this.bufferedReader = new BufferedReader(new FileReader(filename));
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.strbuf = new StringBuffer();
    }

    public int read() {
        try {
            String newLineOfText;
            while ((newLineOfText = this.bufferedReader.readLine()) != null) {
                this.strbuf.append(newLineOfText + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
        return this.strbuf.length();
    }

    public String getText() {
        return new String(this.strbuf);
    }

    public static void main(String[] argv) {
        int argCount = argv.length;
        String fileToRead = argCount == 0 ? "TextFileReader.java" : argv[0];
        TextFileReader reader = new TextFileReader(fileToRead);
        int size = reader.read();
        System.out.println("size of text block: " + size);
        System.out.println(reader.getText());
    }
}

