/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings.continuous;

import cytoscape.visual.mappings.LegendTable;
import cytoscape.visual.mappings.continuous.ContinuousMappingPoint;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ContinuousLegend
extends JPanel {
    List points;
    Object obj;
    int width = 40;
    int height;
    int yoff = this.height = 40;

    public ContinuousLegend(String visualAttr, String dataAttr, List points, Object obj, byte b) {
        this.points = points;
        this.obj = obj;
        this.setBackground(Color.white);
        this.setLayout(new BoxLayout(this, 1));
        this.setAlignmentX(0.0f);
        this.add(new JLabel(visualAttr + " is continuously mapped to " + dataAttr));
        if (obj instanceof Color) {
            this.add(LegendTable.getHeader());
            this.add(this.getGradientPanel());
        } else {
            this.add(LegendTable.getHeader());
            this.add(this.getObjectPanel(b));
        }
    }

    private JPanel getGradientPanel() {
        JPanel holder = new JPanel();
        holder.setLayout(new GridLayout(1, 2));
        holder.setAlignmentX(0.0f);
        holder.setBackground(Color.white);
        JLabel grad = new JLabel(this.getColorGradientIcon());
        grad.setAlignmentX(0.0f);
        holder.add(grad);
        JLabel num = new JLabel(this.getNumberGradientIcon());
        num.setAlignmentX(0.0f);
        holder.add(num);
        return holder;
    }

    private ImageIcon getNumberGradientIcon() {
        int imageHeight = (this.points.size() + 1) * this.height;
        BufferedImage bi = new BufferedImage(this.width, imageHeight, 1);
        Graphics2D g2 = bi.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setPaint(Color.white);
        g2.fillRect(0, 0, this.width, imageHeight);
        g2.setPaint(Color.black);
        int yoff = (int)((float)g2.getFontMetrics().getMaxAscent() / 2.0f);
        ContinuousMappingPoint curr = null;
        for (int i = 0; i < this.points.size(); ++i) {
            curr = (ContinuousMappingPoint)this.points.get(i);
            g2.drawString(Double.toString(curr.getValue()), 0, (i + 1) * this.height + yoff);
        }
        return new ImageIcon(bi);
    }

    private ImageIcon getColorGradientIcon() {
        int imageHeight = (this.points.size() + 1) * this.height;
        BufferedImage bi = new BufferedImage(this.width, imageHeight, 1);
        Graphics2D g2 = bi.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setPaint(Color.white);
        g2.fillRect(0, 0, this.width, imageHeight);
        ContinuousMappingPoint curr = null;
        ContinuousMappingPoint next = null;
        Rectangle rect = new Rectangle(0, 0, this.width, this.height);
        for (int i = 0; i < this.points.size(); ++i) {
            curr = (ContinuousMappingPoint)this.points.get(i);
            next = i + 1 < this.points.size() ? (ContinuousMappingPoint)this.points.get(i + 1) : null;
            if (i == 0) {
                g2.setPaint((Color)curr.getRange().lesserValue);
                rect.setBounds(0, 0, this.width, this.height);
                g2.fill(rect);
            }
            if (next != null) {
                GradientPaint gp = new GradientPaint(0.0f, (i + 1) * this.height, (Color)curr.getRange().equalValue, 0.0f, (i + 2) * this.height, (Color)next.getRange().equalValue);
                g2.setPaint(gp);
                rect.setBounds(0, (i + 1) * this.height, this.width, this.height);
                g2.fill(rect);
                continue;
            }
            g2.setPaint((Color)curr.getRange().greaterValue);
            rect.setBounds(0, (i + 1) * this.height, this.width, this.height);
            g2.fill(rect);
        }
        return new ImageIcon(bi);
    }

    private JPanel getObjectPanel(byte b) {
        Object[][] data = new Object[this.points.size() + 2][2];
        ContinuousMappingPoint curr = null;
        for (int i = 0; i < this.points.size(); ++i) {
            curr = (ContinuousMappingPoint)this.points.get(i);
            if (i == 0) {
                data[i][0] = curr.getRange().lesserValue;
                data[i][1] = "< " + Double.toString(curr.getValue());
            }
            data[i + 1][0] = curr.getRange().equalValue;
            data[i + 1][1] = "= " + Double.toString(curr.getValue());
            if (i != this.points.size() - 1) continue;
            data[i + 2][0] = curr.getRange().greaterValue;
            data[i + 2][1] = "> " + Double.toString(curr.getValue());
        }
        LegendTable lt = new LegendTable(data, b);
        return lt;
    }
}

