/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.Cytoscape;
import cytoscape.data.writers.CytoscapeSessionWriter;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.io.File;

class SaveSessionTask
implements Task {
    private String fileName;
    private TaskMonitor taskMonitor;
    CytoscapeSessionWriter sw;

    SaveSessionTask(String fileName) {
        this.fileName = fileName;
        this.sw = new CytoscapeSessionWriter(fileName);
    }

    public void run() {
        this.taskMonitor.setStatus("Saving Cytoscape Session.\n\nIt may take a while.  Please wait...");
        this.taskMonitor.setPercentCompleted(-1);
        try {
            this.sw.writeSessionToDisk();
        }
        catch (Exception e) {
            this.taskMonitor.setException((Throwable)e, "Could not write session to the file: " + this.fileName);
        }
        this.taskMonitor.setPercentCompleted(100);
        this.taskMonitor.setStatus("Session successfully saved to:  " + this.fileName);
        File shortName = new File(this.fileName);
        Cytoscape.setCurrentSessionFileName(this.fileName);
        Cytoscape.getDesktop().setTitle("Cytoscape Desktop (Session: " + shortName.getName() + ")");
    }

    public void halt() {
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) throws IllegalThreadStateException {
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return "Saving Cytoscape Session";
    }
}

