/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain.inparanoid;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.baderlab.brain.DatabaseReference;
import org.baderlab.brain.inparanoid.Ortholog;

public class InparanoidDB {
    HashMap species2taxid = new HashMap();
    HashMap species2database = new HashMap();
    HashMap species2fullName = new HashMap();
    HashMap accession2orthologGroup = new HashMap();
    HashMap otherAccession2inparanoidAccession;

    public String getSpeciesFullName(String species) {
        return (String)this.species2fullName.get(species);
    }

    private void addOrtholog(DatabaseReference sourceOrtholog, Ortholog ortholog) {
        ArrayList hg = null;
        if (sourceOrtholog.equals(ortholog.getProteinID())) {
            return;
        }
        hg = this.accession2orthologGroup.containsKey(sourceOrtholog) ? (ArrayList)this.accession2orthologGroup.get(sourceOrtholog) : new ArrayList();
        hg.add(ortholog);
        this.accession2orthologGroup.put(sourceOrtholog, hg);
    }

    public void readInparanoidDataFile(File[] inparanoidDataFile, File speciesInfoFile, String speciesOfInterest) throws IOException {
        String[] lineSplit;
        BufferedReader br = new BufferedReader(new FileReader(speciesInfoFile));
        String line = null;
        while ((line = br.readLine()) != null) {
            lineSplit = line.split("\t");
            if (lineSplit.length != 4) continue;
            String species = lineSplit[0];
            String speciesFullName = lineSplit[1];
            int taxid = Integer.parseInt(lineSplit[2]);
            String datasource = lineSplit[3];
            this.species2taxid.put(species, new Integer(taxid));
            this.species2database.put(species, datasource);
            this.species2fullName.put(species, speciesFullName);
        }
        for (int i = 0; i < inparanoidDataFile.length; ++i) {
            File file = inparanoidDataFile[i];
            BufferedReader brData = new BufferedReader(new FileReader(file));
            ArrayList<Ortholog> orthologsInCluster = new ArrayList<Ortholog>();
            ArrayList<DatabaseReference> speciesOfInterestProteinsInCluster = new ArrayList<DatabaseReference>();
            int count = 0;
            int prevClusterID = -1;
            while ((line = brData.readLine()) != null) {
                ++count;
                lineSplit = line.split("\t");
                if (lineSplit.length < 5) {
                    throw new IOException("Inparanoid file" + file + " line " + count + " is too short. Expected at least 5 fields, but only found " + lineSplit.length + ".");
                }
                int clusterID = Integer.parseInt(lineSplit[0]);
                String species = lineSplit[2];
                String accession = lineSplit[4];
                Object taxidLookup = this.species2taxid.get(species);
                if (taxidLookup == null) {
                    throw new IllegalArgumentException("Wasn't able to find an NCBI taxonomy ID for species: " + species + ". Please check the species info file (" + speciesInfoFile.toString() + ") to make sure it is specified.");
                }
                int ncbiTaxID = (Integer)taxidLookup;
                DatabaseReference dbref = new DatabaseReference((String)this.species2database.get(species), accession);
                Ortholog ortholog = null;
                if (!species.equalsIgnoreCase(speciesOfInterest)) {
                    ortholog = new Ortholog(clusterID, ncbiTaxID, dbref);
                }
                if (count > 1 && clusterID != prevClusterID) {
                    if (speciesOfInterestProteinsInCluster.size() == 0) {
                        throw new RuntimeException("Wasn't able to find a species of interest in datafiles. Currently specified: " + speciesOfInterest + ".");
                    }
                    for (int j = 0; j < orthologsInCluster.size(); ++j) {
                        Ortholog clusterOrtholog = (Ortholog)orthologsInCluster.get(j);
                        for (int k = 0; k < speciesOfInterestProteinsInCluster.size(); ++k) {
                            DatabaseReference dbrefSpeciesOfInterest = (DatabaseReference)speciesOfInterestProteinsInCluster.get(k);
                            this.addOrtholog(dbrefSpeciesOfInterest, clusterOrtholog);
                        }
                    }
                    speciesOfInterestProteinsInCluster.clear();
                    orthologsInCluster.clear();
                }
                if (!species.equalsIgnoreCase(speciesOfInterest)) {
                    orthologsInCluster.add(ortholog);
                }
                if (species.equals(speciesOfInterest)) {
                    speciesOfInterestProteinsInCluster.add(dbref);
                }
                prevClusterID = clusterID;
            }
        }
    }

    public void readIDMappingFile(File idMappingFile) throws IOException {
        if (this.otherAccession2inparanoidAccession == null) {
            this.otherAccession2inparanoidAccession = new HashMap();
        }
        BufferedReader br = new BufferedReader(new FileReader(idMappingFile));
        String line = null;
        while ((line = br.readLine()) != null) {
            String[] lineSplit = line.split("\t");
            if (lineSplit.length != 2) continue;
            String id1 = lineSplit[0];
            DatabaseReference dbref1 = new DatabaseReference(id1);
            String id2 = lineSplit[1];
            DatabaseReference dbref2 = new DatabaseReference(id2);
            this.otherAccession2inparanoidAccession.put(dbref2, dbref1);
        }
    }

    public boolean isOrthologByAccession(DatabaseReference referenceAccession, DatabaseReference comparisonAccession) {
        ArrayList accAOrthoList = this.findOrthologList(referenceAccession);
        if (accAOrthoList == null) {
            return false;
        }
        for (int i = 0; i < accAOrthoList.size(); ++i) {
            Ortholog ortholog = (Ortholog)accAOrthoList.get(i);
            if (!ortholog.getProteinID().equals(comparisonAccession)) continue;
            return true;
        }
        return false;
    }

    private ArrayList findOrthologList(DatabaseReference accession) {
        ArrayList accessionOrthoList = null;
        if (this.accession2orthologGroup.containsKey(accession)) {
            accessionOrthoList = (ArrayList)this.accession2orthologGroup.get(accession);
        } else if (this.otherAccession2inparanoidAccession != null && this.otherAccession2inparanoidAccession.containsKey(accession) && this.accession2orthologGroup.containsKey(accession = (DatabaseReference)this.otherAccession2inparanoidAccession.get(accession))) {
            accessionOrthoList = (ArrayList)this.accession2orthologGroup.get(accession);
        }
        return accessionOrthoList;
    }
}

