/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.visual.Appearance;
import cytoscape.visual.Arrow;
import cytoscape.visual.BypassHelper;
import cytoscape.visual.LineType;
import cytoscape.visual.parsers.ArrowParser;
import cytoscape.visual.parsers.ColorParser;
import cytoscape.visual.parsers.FontParser;
import cytoscape.visual.parsers.LineTypeParser;
import cytoscape.visual.parsers.ObjectToString;
import giny.model.Edge;
import giny.view.EdgeView;
import giny.view.Label;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.Properties;

public class EdgeAppearance
implements Appearance,
Cloneable {
    static Font defaultFont = new Font(null, 0, 10);
    Color color = Color.BLACK;
    LineType lineType = LineType.LINE_1;
    Arrow sourceArrow = Arrow.NONE;
    Arrow targetArrow = Arrow.NONE;
    String label = "";
    String toolTip = "";
    Font font = defaultFont;
    Color labelColor = Color.BLACK;

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color c) {
        if (c != null) {
            this.color = c;
        }
    }

    public LineType getLineType() {
        return this.lineType;
    }

    public void setLineType(LineType lt) {
        if (lt != null) {
            this.lineType = lt;
        }
    }

    public Arrow getSourceArrow() {
        return this.sourceArrow;
    }

    public void setSourceArrow(Arrow a) {
        if (a != null) {
            this.sourceArrow = a;
        }
    }

    public Arrow getTargetArrow() {
        return this.targetArrow;
    }

    public void setTargetArrow(Arrow a) {
        if (a != null) {
            this.targetArrow = a;
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String s) {
        if (s != null) {
            this.label = s;
        }
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public void setToolTip(String s) {
        if (s != null) {
            this.toolTip = s;
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font f) {
        if (f != null) {
            this.font = f;
        }
    }

    public float getFontSize() {
        return this.font.getSize2D();
    }

    public void setFontSize(float f) {
        this.font = this.font.deriveFont(f);
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color c) {
        if (c != null) {
            this.labelColor = c;
        }
    }

    public void applyAppearance(EdgeView edgeView, boolean optimizer) {
        this.applyAppearance(edgeView);
    }

    public void applyAppearance(EdgeView edgeView) {
        Paint existingUnselectedPaint = edgeView.getUnselectedPaint();
        Color newUnselectedPaint = this.getColor();
        if (!((Object)newUnselectedPaint).equals(existingUnselectedPaint)) {
            edgeView.setUnselectedPaint((Paint)newUnselectedPaint);
        }
        Stroke existingStroke = edgeView.getStroke();
        Stroke newStroke = this.getLineType().getStroke();
        if (!newStroke.equals(existingStroke)) {
            edgeView.setStroke(newStroke);
        }
        int existingSourceEdge = edgeView.getSourceEdgeEnd();
        int newSourceEdge = this.getSourceArrow().getGinyArrow();
        if (newSourceEdge != existingSourceEdge) {
            edgeView.setSourceEdgeEnd(newSourceEdge);
        }
        int existingTargetEdge = edgeView.getTargetEdgeEnd();
        int newTargetEdge = this.getTargetArrow().getGinyArrow();
        if (newTargetEdge != existingTargetEdge) {
            edgeView.setTargetEdgeEnd(newTargetEdge);
        }
        Label label = edgeView.getLabel();
        String existingText = label.getText();
        String newText = this.getLabel();
        if (!newText.equals(existingText)) {
            label.setText(newText);
        }
        Font existingFont = label.getFont();
        Font newFont = this.getFont();
        if (!newFont.equals(existingFont)) {
            label.setFont(newFont);
        }
        Paint existingLabelColor = label.getTextPaint();
        Color newLabelColor = this.getLabelColor();
        if (!((Object)newLabelColor).equals(existingLabelColor)) {
            label.setTextPaint((Paint)newLabelColor);
        }
    }

    public void applyDefaultProperties(Properties eacProps, String baseKey) {
        Font f;
        Arrow a;
        LineType lt;
        Color c;
        String value = null;
        value = eacProps.getProperty(baseKey + ".defaultEdgeColor");
        if (value != null && (c = new ColorParser().parseColor(value)) != null) {
            this.setColor(c);
        }
        if ((value = eacProps.getProperty(baseKey + ".defaultEdgeLineType")) != null && (lt = new LineTypeParser().parseLineType(value)) != null) {
            this.setLineType(lt);
        }
        if ((value = eacProps.getProperty(baseKey + ".defaultEdgeSourceArrow")) != null && (a = new ArrowParser().parseArrow(value)) != null) {
            this.setSourceArrow(a);
        }
        if ((value = eacProps.getProperty(baseKey + ".defaultEdgeTargetArrow")) != null && (a = new ArrowParser().parseArrow(value)) != null) {
            this.setTargetArrow(a);
        }
        if ((value = eacProps.getProperty(baseKey + ".defaultEdgeLabel")) != null) {
            this.setLabel(value);
        }
        if ((value = eacProps.getProperty(baseKey + ".defaultEdgeToolTip")) != null) {
            this.setToolTip(value);
        }
        if ((value = eacProps.getProperty(baseKey + ".defaultEdgeFont")) != null && (f = new FontParser().parseFont(value)) != null) {
            this.setFont(f);
        }
        if ((value = eacProps.getProperty(baseKey + ".defaultEdgeLabelColor")) != null) {
            c = new ColorParser().parseColor(value);
            this.setLabelColor(c);
        }
    }

    public Properties getDefaultProperties(String baseKey) {
        String key = null;
        String value = null;
        Properties newProps = new Properties();
        key = baseKey + ".defaultEdgeColor";
        value = ObjectToString.getStringValue(this.getColor());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultEdgeLineType";
        value = ObjectToString.getStringValue(this.getLineType());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultEdgeSourceArrow";
        value = ObjectToString.getStringValue(this.getSourceArrow());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultEdgeTargetArrow";
        value = ObjectToString.getStringValue(this.getTargetArrow());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultEdgeLabel";
        value = ObjectToString.getStringValue(this.getLabel());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultEdgeToolTip";
        value = ObjectToString.getStringValue(this.getToolTip());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultEdgeFont";
        value = ObjectToString.getStringValue(this.getFont());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultLabelColor";
        value = ObjectToString.getStringValue(this.getLabelColor());
        newProps.setProperty(key, value);
        return newProps;
    }

    public String getDescription(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        String lineSep = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append(prefix + "EdgeColor = ").append(this.color).append(lineSep);
        String edgeLineTypeText = ObjectToString.getStringValue(this.lineType);
        sb.append(prefix + "EdgeLineType = ").append(edgeLineTypeText).append(lineSep);
        String sourceArrowText = ObjectToString.getStringValue(this.sourceArrow);
        sb.append(prefix + "EdgeSourceArrow = ").append(sourceArrowText).append(lineSep);
        String targetArrowText = ObjectToString.getStringValue(this.targetArrow);
        sb.append(prefix + "EdgeTargetArrow = ").append(targetArrowText).append(lineSep);
        sb.append(prefix + "EdgeLabel = ").append(this.label).append(lineSep);
        sb.append(prefix + "EdgeToolTip = ").append(this.toolTip).append(lineSep);
        sb.append(prefix + "EdgeFont = ").append(this.font).append(lineSep);
        sb.append(prefix + "EdgeLabelColor = ").append(this.labelColor).append(lineSep);
        return sb.toString();
    }

    public String getDescription() {
        return this.getDescription(null);
    }

    public Object get(byte type) {
        Object defaultObj = null;
        switch (type) {
            case 8: {
                defaultObj = this.getColor();
                break;
            }
            case 9: {
                defaultObj = this.getLineType();
                break;
            }
            case 10: {
                defaultObj = this.getSourceArrow();
                break;
            }
            case 11: {
                defaultObj = this.getTargetArrow();
                break;
            }
            case 12: {
                defaultObj = this.getLabel();
                break;
            }
            case 15: {
                defaultObj = this.getToolTip();
                break;
            }
            case 124: {
                defaultObj = this.getFont();
                break;
            }
            case 125: {
                defaultObj = new Double(this.getFont().getSize2D());
                break;
            }
            case 18: {
                defaultObj = this.getLabelColor();
            }
        }
        return defaultObj;
    }

    public void set(byte type, Object c) {
        switch (type) {
            case 8: {
                this.setColor((Color)c);
                break;
            }
            case 9: {
                this.setLineType((LineType)c);
                break;
            }
            case 10: {
                this.setSourceArrow((Arrow)c);
                break;
            }
            case 11: {
                this.setTargetArrow((Arrow)c);
                break;
            }
            case 12: {
                this.setLabel((String)c);
                break;
            }
            case 15: {
                this.setToolTip((String)c);
                break;
            }
            case 124: {
                this.setFont((Font)c);
                break;
            }
            case 125: {
                this.setFontSize(((Double)c).floatValue());
                break;
            }
            case 18: {
                this.setLabelColor((Color)c);
            }
        }
    }

    public void copy(EdgeAppearance ea) {
        this.setColor(ea.getColor());
        this.setLineType(ea.getLineType());
        this.setSourceArrow(ea.getSourceArrow());
        this.setTargetArrow(ea.getTargetArrow());
        this.setLabel(ea.getLabel());
        this.setToolTip(ea.getToolTip());
        this.setFont(ea.getFont());
        this.setLabelColor(ea.getLabelColor());
    }

    public Object clone() {
        EdgeAppearance ea = new EdgeAppearance();
        ea.copy(this);
        return ea;
    }

    public void applyBypass(Edge e) {
        if (e == null) {
            return;
        }
        String id = e.getIdentifier();
        CyAttributes attrs = Cytoscape.getEdgeAttributes();
        this.setColor(BypassHelper.getColorBypass(attrs, id, "edge.color"));
        this.setLineType((LineType)BypassHelper.getBypass(attrs, id, "edge.lineType", LineType.class));
        this.setSourceArrow((Arrow)BypassHelper.getBypass(attrs, id, "edge.sourceArrow", Arrow.class));
        this.setTargetArrow((Arrow)BypassHelper.getBypass(attrs, id, "edge.targetArrow", Arrow.class));
        this.setLabel((String)BypassHelper.getBypass(attrs, id, "edge.label", String.class));
        this.setToolTip((String)BypassHelper.getBypass(attrs, id, "edge.toolTip", String.class));
        this.setFont((Font)BypassHelper.getBypass(attrs, id, "edge.font", Font.class));
        Double d = (Double)BypassHelper.getBypass(attrs, id, "edge.fontSize", Double.class);
        if (d != null) {
            this.setFontSize(d.floatValue());
        }
        this.setLabelColor(BypassHelper.getColorBypass(attrs, id, "edge.labelColor"));
    }
}

