/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.view;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.actions.AlphabeticalSelectionAction;
import cytoscape.actions.BendSelectedEdgesAction;
import cytoscape.actions.BirdsEyeViewAction;
import cytoscape.actions.BookmarkAction;
import cytoscape.actions.CloneGraphInNewWindowAction;
import cytoscape.actions.CreateNetworkViewAction;
import cytoscape.actions.CytoPanelAction;
import cytoscape.actions.DeSelectAllEdgesAction;
import cytoscape.actions.DeSelectAllNodesAction;
import cytoscape.actions.DeselectAllAction;
import cytoscape.actions.DestroyNetworkAction;
import cytoscape.actions.DestroyNetworkViewAction;
import cytoscape.actions.ExitAction;
import cytoscape.actions.ExportAsGMLAction;
import cytoscape.actions.ExportAsGraphicsAction;
import cytoscape.actions.ExportAsInteractionsAction;
import cytoscape.actions.ExportAsXGMMLAction;
import cytoscape.actions.ExportEdgeAttributesAction;
import cytoscape.actions.ExportNodeAttributesAction;
import cytoscape.actions.ExportVizmapAction;
import cytoscape.actions.FitContentAction;
import cytoscape.actions.HelpAboutAction;
import cytoscape.actions.HelpContactHelpDeskAction;
import cytoscape.actions.HideSelectedEdgesAction;
import cytoscape.actions.HideSelectedNodesAction;
import cytoscape.actions.ImportEdgeAttributesAction;
import cytoscape.actions.ImportExpressionMatrixAction;
import cytoscape.actions.ImportGraphFileAction;
import cytoscape.actions.ImportNodeAttributesAction;
import cytoscape.actions.ImportVizmapAction;
import cytoscape.actions.InvertSelectedEdgesAction;
import cytoscape.actions.InvertSelectedNodesAction;
import cytoscape.actions.ListFromFileSelectionAction;
import cytoscape.actions.NewSessionAction;
import cytoscape.actions.NewWindowSelectedNodesEdgesAction;
import cytoscape.actions.NewWindowSelectedNodesOnlyAction;
import cytoscape.actions.OpenSessionAction;
import cytoscape.actions.PreferenceAction;
import cytoscape.actions.PrintAction;
import cytoscape.actions.ProxyServerAction;
import cytoscape.actions.SaveSessionAction;
import cytoscape.actions.SaveSessionAsAction;
import cytoscape.actions.SelectAllAction;
import cytoscape.actions.SelectAllEdgesAction;
import cytoscape.actions.SelectAllNodesAction;
import cytoscape.actions.SelectFirstNeighborsAction;
import cytoscape.actions.SelectionModeAction;
import cytoscape.actions.SetVisualPropertiesAction;
import cytoscape.actions.StraightenSelectedEdgesAction;
import cytoscape.actions.ToggleVisualMapperAction;
import cytoscape.actions.UnHideSelectedEdgesAction;
import cytoscape.actions.UnHideSelectedNodesAction;
import cytoscape.actions.ZoomAction;
import cytoscape.actions.ZoomSelectedAction;
import cytoscape.util.CytoscapeAction;
import cytoscape.util.CytoscapeMenuBar;
import cytoscape.util.CytoscapeToolBar;
import cytoscape.view.CyNetworkView;
import cytoscape.view.cytopanels.CytoPanel;
import giny.view.GraphViewChangeEvent;
import giny.view.GraphViewChangeListener;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class CyMenus
implements GraphViewChangeListener {
    boolean menusInitialized = false;
    CytoscapeMenuBar menuBar;
    JMenu fileMenu;
    JMenu loadSubMenu;
    JMenu saveSubMenu;
    JMenu newSubMenu;
    JMenu newSubMenu2;
    JMenu editMenu;
    JMenu viewMenu;
    JMenu viewSubMenu;
    JMenu selectMenu;
    JMenu displayNWSubMenu;
    JMenu layoutMenu;
    JMenu vizMenu;
    JMenu helpMenu;
    JMenu cytoPanelMenu;
    CytoscapeAction menuPrintAction;
    CytoscapeAction menuExportAction;
    CytoscapeAction menuSaveSessionAction;
    CytoscapeAction menuSaveSessionAsAction;
    CytoscapeAction menuOpenSessionAction;
    CytoscapeAction networkOverviewAction;
    JMenuItem vizMenuItem;
    JMenuItem vizMapperItem;
    JCheckBoxMenuItem cytoPanelWestItem;
    JCheckBoxMenuItem cytoPanelEastItem;
    JCheckBoxMenuItem cytoPanelSouthItem;
    JCheckBoxMenuItem networkOverviewItem;
    JMenuItem helpContentsMenuItem;
    JMenuItem helpAboutMenuItem;
    JMenuItem helpContactHelpDeskMenuItem;
    JButton openSessionButton;
    JButton saveButton;
    JButton zoomInButton;
    JButton zoomOutButton;
    JButton zoomSelectedButton;
    JButton zoomDisplayAllButton;
    JButton showAllButton;
    JButton hideSelectedButton;
    JButton annotationButton;
    JButton vizButton;
    JMenu opsMenu;
    CytoscapeToolBar toolBar;
    boolean nodesRequiredItemsEnabled;

    public CyMenus() {
        this.createMenuBar();
        this.toolBar = new CytoscapeToolBar();
    }

    public CytoscapeMenuBar getMenuBar() {
        return this.menuBar;
    }

    public JMenu getFileMenu() {
        return this.fileMenu;
    }

    public JMenu getLoadSubMenu() {
        return this.loadSubMenu;
    }

    public JMenu getSaveSubMenu() {
        return this.saveSubMenu;
    }

    public JMenu getEditMenu() {
        return this.editMenu;
    }

    public JMenu getViewMenu() {
        return this.viewMenu;
    }

    public JMenu getSelectMenu() {
        return this.selectMenu;
    }

    public JMenu getLayoutMenu() {
        return this.layoutMenu;
    }

    public JMenu getVizMenu() {
        return this.vizMenu;
    }

    public JMenu getHelpMenu() {
        return this.helpMenu;
    }

    public JMenu getOperationsMenu() {
        return this.opsMenu;
    }

    public JMenu getNewNetworkMenu() {
        return this.newSubMenu2;
    }

    public CytoscapeToolBar getToolBar() {
        return this.toolBar;
    }

    public void addAction(CytoscapeAction action) {
        this.addCytoscapeAction(action);
    }

    public void addAction(CytoscapeAction action, int index) {
        this.addCytoscapeAction(action, index);
    }

    public void addCytoscapeAction(CytoscapeAction action) {
        if (action.isInMenuBar()) {
            this.getMenuBar().addAction(action);
        }
        if (action.isInToolBar()) {
            this.getToolBar().addAction(action);
        }
    }

    public void addCytoscapeAction(CytoscapeAction action, int index) {
        if (action.isInMenuBar()) {
            this.getMenuBar().addAction(action, index);
        }
        if (action.isInToolBar()) {
            this.getToolBar().addAction(action);
        }
    }

    public void setVisualMapperItemsEnabled(boolean newState) {
        this.vizMenuItem.setEnabled(newState);
        this.vizButton.setEnabled(newState);
        this.vizMapperItem.setText(newState ? "Lock VizMapper\u2122" : "Unlock VizMapper\u2122");
    }

    public void setOverviewEnabled(boolean newState) {
        this.networkOverviewItem.setSelected(newState);
    }

    public void setNodesRequiredItemsEnabled() {
        boolean newState = Cytoscape.getCurrentNetwork().getNodeCount() > 0;
        newState = true;
        if (newState == this.nodesRequiredItemsEnabled) {
            return;
        }
        this.saveButton.setEnabled(newState);
        this.saveSubMenu.setEnabled(newState);
        this.menuPrintAction.setEnabled(newState);
        this.nodesRequiredItemsEnabled = newState;
    }

    public void graphViewChanged(GraphViewChangeEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CyMenus.this.setNodesRequiredItemsEnabled();
            }
        });
    }

    public JMenu getCytoPanelMenu() {
        return this.cytoPanelMenu;
    }

    public void initCytoPanelMenus() {
        CytoPanel cytoPanel = Cytoscape.getDesktop().getCytoPanel(7);
        this.cytoPanelWestItem = new JCheckBoxMenuItem(cytoPanel.getTitle());
        this.initCytoPanelMenuItem(cytoPanel, this.cytoPanelWestItem, true, true, "cytoPanelWest", 49);
        cytoPanel = Cytoscape.getDesktop().getCytoPanel(3);
        this.cytoPanelEastItem = new JCheckBoxMenuItem(cytoPanel.getTitle());
        this.initCytoPanelMenuItem(cytoPanel, this.cytoPanelEastItem, false, false, "cytoPanelEast", 51);
        cytoPanel = Cytoscape.getDesktop().getCytoPanel(5);
        this.cytoPanelSouthItem = new JCheckBoxMenuItem(cytoPanel.getTitle());
        this.initCytoPanelMenuItem(cytoPanel, this.cytoPanelSouthItem, false, false, "cytoPanelSouth", 50);
        this.menuBar.getMenu("View").add(new JSeparator());
        this.menuBar.getMenu("View.Desktop").add(this.cytoPanelWestItem);
        this.menuBar.getMenu("View.Desktop").add(this.cytoPanelSouthItem);
        this.menuBar.getMenu("View.Desktop").add(this.cytoPanelEastItem);
    }

    private void initCytoPanelMenuItem(CytoPanel cytoPanel, JCheckBoxMenuItem menuItem, boolean selected, boolean enabled, String mapObject, int keyCode) {
        CytoPanelAction cytoPanelAction = new CytoPanelAction(menuItem, cytoPanel);
        menuItem.addActionListener(cytoPanelAction);
        menuItem.setSelected(selected);
        menuItem.setEnabled(enabled);
        KeyStroke accel = KeyStroke.getKeyStroke(keyCode, 2);
        menuItem.setAccelerator(accel);
        menuItem.getInputMap(1).put(accel, mapObject);
        menuItem.getActionMap().put(mapObject, cytoPanelAction);
    }

    private void createMenuBar() {
        this.menuBar = new CytoscapeMenuBar();
        final JMenu f_fileMenu = this.fileMenu = this.menuBar.getMenu("File");
        this.fileMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuSelected(MenuEvent e) {
                CyNetworkView graphView = Cytoscape.getCurrentNetworkView();
                CyNetwork graph = Cytoscape.getCurrentNetwork();
                boolean inactive = false;
                if (graphView == null || graphView.nodeCount() == 0) {
                    inactive = true;
                }
                boolean networkExists = graph != null;
                MenuElement[] popup = f_fileMenu.getSubElements();
                if (popup[0] instanceof JPopupMenu) {
                    MenuElement[] submenus = ((JPopupMenu)popup[0]).getSubElements();
                    for (int i = 0; i < submenus.length; ++i) {
                        if (!(submenus[i] instanceof JMenuItem)) continue;
                        JMenuItem item = (JMenuItem)submenus[i];
                        if (item.getText().equals("Network As Graphics") || item.getText().equals("Print...")) {
                            item.setEnabled(!inactive);
                            continue;
                        }
                        if (!item.getText().equals("Save")) continue;
                        item.setEnabled(networkExists);
                    }
                }
            }
        });
        this.newSubMenu = this.menuBar.getMenu("File.New", 0);
        this.newSubMenu2 = this.menuBar.getMenu("File.New.Network");
        this.loadSubMenu = this.menuBar.getMenu("File.Import", 1);
        this.saveSubMenu = this.menuBar.getMenu("File.Export", 2);
        final JMenu f_editMenu = this.editMenu = this.menuBar.getMenu("Edit");
        this.editMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuSelected(MenuEvent e) {
                MenuElement[] popup;
                CyNetworkView graphView = Cytoscape.getCurrentNetworkView();
                boolean inactive = false;
                if (graphView == null || graphView.nodeCount() == 0) {
                    inactive = true;
                }
                if ((popup = f_editMenu.getSubElements())[0] instanceof JPopupMenu) {
                    MenuElement[] submenus = ((JPopupMenu)popup[0]).getSubElements();
                    for (int i = 0; i < submenus.length; ++i) {
                        if (!(submenus[i] instanceof JMenuItem)) continue;
                        JMenuItem item = (JMenuItem)submenus[i];
                        if (inactive && (item.getText().equals("Delete Selected Nodes and Edges") || item.getText().equals("Undo") || item.getText().equals("Redo") || item.getText().equals("Destroy Network") || item.getText().equals("Destroy View"))) {
                            item.setEnabled(false);
                        } else {
                            item.setEnabled(true);
                        }
                        if (!item.getText().equals("Connect Selected Nodes")) continue;
                        if (graphView.getSelectedNodes() != null && graphView.getSelectedNodes().size() > 1) {
                            item.setEnabled(true);
                            continue;
                        }
                        item.setEnabled(false);
                    }
                }
            }
        });
        this.viewMenu = this.menuBar.getMenu("View");
        this.viewMenu.setEnabled(true);
        this.viewMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuSelected(MenuEvent e) {
            }
        });
        final JMenu f_selectMenu = this.selectMenu = this.menuBar.getMenu("Select");
        this.selectMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuSelected(MenuEvent e) {
                MenuElement[] popup;
                CyNetwork graph = Cytoscape.getCurrentNetwork();
                boolean inactive = false;
                if (graph == null || graph.getNodeCount() == 0) {
                    inactive = true;
                }
                if ((popup = f_selectMenu.getSubElements())[0] instanceof JPopupMenu) {
                    MenuElement[] submenus = ((JPopupMenu)popup[0]).getSubElements();
                    for (int i = 0; i < submenus.length; ++i) {
                        if (!(submenus[i] instanceof JMenuItem)) continue;
                        if (inactive) {
                            ((JMenuItem)submenus[i]).setEnabled(false);
                            continue;
                        }
                        ((JMenuItem)submenus[i]).setEnabled(true);
                    }
                }
            }
        });
        final JMenu f_layoutMenu = this.layoutMenu = this.menuBar.getMenu("Layout");
        this.layoutMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuSelected(MenuEvent e) {
                MenuElement[] popup;
                CyNetworkView graphView = Cytoscape.getCurrentNetworkView();
                boolean inactive = false;
                if (graphView == null || graphView.nodeCount() == 0) {
                    inactive = true;
                }
                if ((popup = f_layoutMenu.getSubElements())[0] instanceof JPopupMenu) {
                    MenuElement[] submenus = ((JPopupMenu)popup[0]).getSubElements();
                    for (int i = 0; i < submenus.length; ++i) {
                        if (!(submenus[i] instanceof JMenuItem)) continue;
                        if (inactive) {
                            ((JMenuItem)submenus[i]).setEnabled(false);
                            continue;
                        }
                        ((JMenuItem)submenus[i]).setEnabled(true);
                    }
                }
            }
        });
        this.opsMenu = this.menuBar.getMenu("Plugins");
        this.helpMenu = this.menuBar.getMenu("Help");
    }

    public void initializeMenus() {
        if (!this.menusInitialized) {
            this.menusInitialized = true;
            this.fillMenuBar();
            this.fillToolBar();
            this.nodesRequiredItemsEnabled = false;
            this.saveButton.setEnabled(false);
            this.saveSubMenu.setEnabled(false);
            this.menuPrintAction.setEnabled(false);
            this.setNodesRequiredItemsEnabled();
        }
    }

    private void fillMenuBar() {
        this.addAction(new NewSessionAction());
        this.addAction(new NewWindowSelectedNodesOnlyAction());
        this.addAction(new NewWindowSelectedNodesEdgesAction());
        this.addAction(new ImportGraphFileAction(this));
        this.loadSubMenu.add(new JSeparator());
        this.addAction(new ImportNodeAttributesAction());
        this.addAction(new ImportEdgeAttributesAction());
        this.addAction(new ImportExpressionMatrixAction());
        this.loadSubMenu.add(new JSeparator());
        this.addAction(new ImportVizmapAction());
        this.addAction(new ExportAsXGMMLAction());
        this.addAction(new ExportAsGMLAction());
        this.addAction(new ExportAsInteractionsAction());
        this.addAction(new ExportNodeAttributesAction());
        this.addAction(new ExportEdgeAttributesAction());
        this.addAction(new ExportVizmapAction());
        this.addAction(new ExportAsGraphicsAction());
        this.fileMenu.add(new JSeparator());
        this.menuSaveSessionAction = new SaveSessionAction("Save");
        this.menuOpenSessionAction = new OpenSessionAction();
        this.menuSaveSessionAsAction = new SaveSessionAsAction("Save As...");
        this.menuOpenSessionAction.setPreferredIndex(1);
        this.menuSaveSessionAction.setPreferredIndex(2);
        this.menuSaveSessionAsAction.setPreferredIndex(3);
        this.addAction(this.menuOpenSessionAction);
        this.addAction(this.menuSaveSessionAction);
        this.addAction(this.menuSaveSessionAsAction);
        this.fileMenu.add((Component)new JSeparator(), 4);
        this.menuPrintAction = new PrintAction();
        this.addAction(this.menuPrintAction);
        this.addAction(new ExitAction());
        this.addAction(new CreateNetworkViewAction());
        this.addAction(new DestroyNetworkViewAction());
        this.addAction(new DestroyNetworkAction());
        this.editMenu.add(new JSeparator());
        this.addAction(new PreferenceAction());
        this.addAction(new BookmarkAction());
        this.addAction(new ProxyServerAction());
        this.selectMenu.add(new SelectionModeAction());
        this.addAction(new InvertSelectedNodesAction());
        this.addAction(new HideSelectedNodesAction());
        this.addAction(new UnHideSelectedNodesAction());
        this.addAction(new SelectAllNodesAction());
        this.addAction(new DeSelectAllNodesAction());
        this.addAction(new SelectFirstNeighborsAction());
        this.addAction(new AlphabeticalSelectionAction());
        this.addAction(new ListFromFileSelectionAction());
        this.addAction(new InvertSelectedEdgesAction());
        this.addAction(new HideSelectedEdgesAction());
        this.addAction(new UnHideSelectedEdgesAction());
        this.addAction(new SelectAllEdgesAction());
        this.addAction(new DeSelectAllEdgesAction());
        this.addAction(new BendSelectedEdgesAction());
        this.addAction(new StraightenSelectedEdgesAction());
        this.selectMenu.addSeparator();
        this.addAction(new CloneGraphInNewWindowAction());
        this.addAction(new SelectAllAction());
        this.addAction(new DeselectAllAction());
        this.selectMenu.addSeparator();
        this.layoutMenu.addSeparator();
        this.networkOverviewAction = new BirdsEyeViewAction();
        this.networkOverviewItem = new JCheckBoxMenuItem(this.networkOverviewAction);
        this.menuBar.getMenu("View").add(this.networkOverviewItem);
        ImageIcon vizmapperIcon = new ImageIcon(this.getClass().getResource("images/ximian/stock_file-with-objects-16.png"));
        this.vizMenuItem = new JMenuItem(new SetVisualPropertiesAction(vizmapperIcon));
        this.vizMapperItem = new JMenuItem(new ToggleVisualMapperAction());
        this.menuBar.getMenu("View").add(new JSeparator());
        this.menuBar.getMenu("View").add(this.vizMenuItem);
        this.menuBar.getMenu("View").add(this.vizMapperItem);
        this.helpAboutMenuItem = new JMenuItem(new HelpAboutAction());
        this.helpContentsMenuItem = new JMenuItem("Contents...", 67);
        this.helpContentsMenuItem.setAccelerator(KeyStroke.getKeyStroke("F1"));
        this.helpContactHelpDeskMenuItem = new JMenuItem(new HelpContactHelpDeskAction());
        this.helpMenu.add(this.helpContentsMenuItem);
        this.helpMenu.add(this.helpContactHelpDeskMenuItem);
        this.helpMenu.addSeparator();
        this.helpMenu.add(this.helpAboutMenuItem);
    }

    private void fillToolBar() {
        this.openSessionButton = this.toolBar.add(new OpenSessionAction(this, false));
        this.openSessionButton.setToolTipText("Open Session File...");
        this.openSessionButton.setIcon(new ImageIcon(this.getClass().getResource("images/ximian/stock_open.png")));
        this.openSessionButton.setBorderPainted(false);
        this.openSessionButton.setRolloverEnabled(true);
        this.saveButton = this.toolBar.add(new SaveSessionAction());
        this.saveButton.setToolTipText("Save Current Session As...");
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("images/ximian/stock_save.png")));
        this.saveButton.setBorderPainted(false);
        this.saveButton.setRolloverEnabled(true);
        this.saveButton.setEnabled(false);
        this.toolBar.addSeparator();
        final ZoomAction zoom_in = new ZoomAction(1.1);
        this.zoomInButton = new JButton();
        this.zoomInButton.setIcon(new ImageIcon(this.getClass().getResource("images/ximian/stock_zoom-in.png")));
        this.zoomInButton.setToolTipText("Zoom In");
        this.zoomInButton.setBorderPainted(false);
        this.zoomInButton.setRolloverEnabled(true);
        this.zoomInButton.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                zoom_in.zoom();
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                CyMenus.this.zoomInButton.setSelected(true);
            }

            public void mouseReleased(MouseEvent e) {
                CyMenus.this.zoomInButton.setSelected(false);
            }
        });
        final ZoomAction zoom_out = new ZoomAction(0.9);
        this.zoomOutButton = new JButton();
        this.zoomOutButton.setIcon(new ImageIcon(this.getClass().getResource("images/ximian/stock_zoom-out.png")));
        this.zoomOutButton.setToolTipText("Zoom Out");
        this.zoomOutButton.setBorderPainted(false);
        this.zoomOutButton.setRolloverEnabled(true);
        this.zoomOutButton.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                zoom_out.zoom();
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                CyMenus.this.zoomOutButton.setSelected(true);
            }

            public void mouseReleased(MouseEvent e) {
                CyMenus.this.zoomOutButton.setSelected(false);
            }
        });
        this.zoomOutButton.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.getWheelRotation() < 0) {
                    zoom_in.zoom();
                } else {
                    zoom_out.zoom();
                }
            }
        });
        this.zoomInButton.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.getWheelRotation() < 0) {
                    zoom_in.zoom();
                } else {
                    zoom_out.zoom();
                }
            }
        });
        this.toolBar.add(this.zoomOutButton);
        this.toolBar.add(this.zoomInButton);
        this.zoomSelectedButton = this.toolBar.add(new ZoomSelectedAction());
        this.zoomSelectedButton.setIcon(new ImageIcon(this.getClass().getResource("images/ximian/stock_zoom-object.png")));
        this.zoomSelectedButton.setToolTipText("Zoom Selected Region");
        this.zoomSelectedButton.setBorderPainted(false);
        this.zoomDisplayAllButton = this.toolBar.add(new FitContentAction());
        this.zoomDisplayAllButton.setIcon(new ImageIcon(this.getClass().getResource("images/ximian/stock_zoom-1.png")));
        this.zoomDisplayAllButton.setToolTipText("Zoom out to display all of current Network");
        this.zoomDisplayAllButton.setBorderPainted(false);
        this.toolBar.addSeparator();
        this.toolBar.addSeparator();
        this.vizButton = this.toolBar.add(new SetVisualPropertiesAction(false));
        this.vizButton.setIcon(new ImageIcon(this.getClass().getResource("images/ximian/stock_file-with-objects.png")));
        this.vizButton.setToolTipText("Set Visual Style");
        this.vizButton.setBorderPainted(false);
    }

    void initializeHelp(HelpBroker hb) {
        hb.enableHelp((Component)this.helpContentsMenuItem, "d0e1", null);
        this.helpContentsMenuItem.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(hb));
        JButton helpButton = new JButton();
        helpButton.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(hb));
        helpButton.setIcon(new ImageIcon(this.getClass().getResource("images/ximian/stock_help.png")));
        helpButton.setToolTipText("Help");
        helpButton.setBorderPainted(false);
        int numComponents = this.toolBar.getComponentCount();
        this.toolBar.add((Component)helpButton, numComponents - 1);
    }
}

