/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import cytoscape.AllTests;
import cytoscape.data.Interaction;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class InteractionTest
extends TestCase {
    public InteractionTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void test3ArgCtor() throws Exception {
        AllTests.standardOut("test3ArgCtor");
        String source = "YNL312W";
        String type = "pd";
        String target = "YPL111W";
        Interaction inter0 = new Interaction(source, target, type);
        InteractionTest.assertTrue((boolean)inter0.getSource().equals(source));
        InteractionTest.assertTrue((boolean)inter0.getType().equals(type));
        InteractionTest.assertTrue((inter0.numberOfTargets() == 1 ? 1 : 0) != 0);
        InteractionTest.assertTrue((boolean)inter0.getTargets()[0].equals(target));
    }

    public void test1ArgCtor() throws Exception {
        AllTests.standardOut("test1ArgCtor");
        String rawText0 = "YNL312W pp YPL111W";
        Interaction inter0 = new Interaction(rawText0);
        InteractionTest.assertTrue((boolean)inter0.getSource().equals("YNL312W"));
        InteractionTest.assertTrue((boolean)inter0.getType().equals("pp"));
        InteractionTest.assertTrue((inter0.numberOfTargets() == 1 ? 1 : 0) != 0);
        InteractionTest.assertTrue((boolean)inter0.getTargets()[0].equals("YPL111W"));
        String rawText1 = "YPL075W pd YDR050C YGR254W YHR174W";
        Interaction inter1 = new Interaction(rawText1);
        InteractionTest.assertTrue((boolean)inter1.getSource().equals("YPL075W"));
        InteractionTest.assertTrue((boolean)inter1.getType().equals("pd"));
        InteractionTest.assertTrue((inter1.numberOfTargets() == 3 ? 1 : 0) != 0);
        InteractionTest.assertTrue((boolean)inter1.getTargets()[0].equals("YDR050C"));
        InteractionTest.assertTrue((boolean)inter1.getTargets()[1].equals("YGR254W"));
        InteractionTest.assertTrue((boolean)inter1.getTargets()[2].equals("YHR174W"));
    }

    public void test1ArgCtorOnDegenerateFrom() throws Exception {
        AllTests.standardOut("test1ArgCtorOnDegenerateForm");
        String rawText0 = "YNL312W";
        Interaction inter0 = new Interaction(rawText0);
        InteractionTest.assertTrue((boolean)inter0.getSource().equals("YNL312W"));
        InteractionTest.assertTrue((inter0.getType() == null ? 1 : 0) != 0);
        InteractionTest.assertTrue((inter0.numberOfTargets() == 0 ? 1 : 0) != 0);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(InteractionTest.class));
    }
}

