/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.Cytoscape;
import cytoscape.view.CyNetworkView;
import cytoscape.view.CytoscapeDesktop;
import giny.model.GraphPerspective;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.undo.AbstractUndoableEdit;

public class DeleteSelectedAction
extends AbstractAction {
    CyNetworkView networkView;

    public DeleteSelectedAction(CyNetworkView networkView) {
        super("Delete Selected Nodes and Edges");
        this.networkView = networkView;
    }

    public void actionPerformed(ActionEvent e) {
        String callerID = "DeleteSelectedAction.actionPerformed";
        List nodes = this.networkView.getSelectedNodes();
        final List edges = this.networkView.getSelectedEdges();
        CyNetworkView view = this.networkView.getView();
        GraphPerspective perspective = view.getGraphPerspective();
        final int[] node_indicies = view.getSelectedNodeIndices();
        final int[] edge_indicies = view.getSelectedEdgeIndices();
        final List selected_nodeViews = view.getSelectedNodes();
        final List selected_edgeViews = view.getSelectedEdges();
        view.hideGraphObjects(selected_nodeViews);
        view.hideGraphObjects(selected_edgeViews);
        perspective.hideEdges(edge_indicies);
        perspective.hideNodes(node_indicies);
        this.networkView.redrawGraph(false, false);
        StringBuilder stringBuilder = new StringBuilder().append("adding undoableEdit to undoManager: ");
        Cytoscape.getDesktop();
        System.out.println(stringBuilder.append(CytoscapeDesktop.undo).toString());
        Cytoscape.getDesktop();
        CytoscapeDesktop.undo.addEdit(new AbstractUndoableEdit(){
            final String network_id;
            {
                this.network_id = DeleteSelectedAction.this.networkView.getNetwork().getIdentifier();
            }

            public String getPresentationName() {
                return "Remove";
            }

            public String getRedoPresentationName() {
                if (edges.size() == 0) {
                    return "Redo: Removed Nodes";
                }
                return "Redo: Removed Nodes and Edges";
            }

            public String getUndoPresentationName() {
                if (edges.size() == 0) {
                    return "Undo: Removed Nodes";
                }
                return "Undo: Removed Nodes and Edges";
            }

            public void redo() {
                super.redo();
                CyNetworkView view = DeleteSelectedAction.this.networkView.getView();
                GraphPerspective perspective = view.getGraphPerspective();
                view.hideGraphObjects(selected_nodeViews);
                view.hideGraphObjects(selected_edgeViews);
                perspective.hideEdges(edge_indicies);
                perspective.hideNodes(node_indicies);
            }

            public void undo() {
                super.undo();
                CyNetworkView view = DeleteSelectedAction.this.networkView.getView();
                GraphPerspective perspective = view.getGraphPerspective();
                view.showGraphObjects(selected_nodeViews);
                view.showGraphObjects(selected_edgeViews);
                perspective.restoreEdges(edge_indicies);
                perspective.restoreNodes(node_indicies);
            }
        });
        Cytoscape.firePropertyChange("NETWORK_MODIFIED", null, this.networkView.getNetwork());
    }
}

