/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.FontFactory;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.SpecialSymbol;

public class GreekList
extends List {
    public GreekList() {
        super(true);
        this.setGreekFont();
    }

    public GreekList(int n) {
        super(true, n);
        this.setGreekFont();
    }

    public GreekList(boolean bl, int n) {
        super(true, n);
        this.lowercase = bl;
        this.setGreekFont();
    }

    protected void setGreekFont() {
        float f = this.symbol.font().size();
        this.symbol.setFont(FontFactory.getFont("Symbol", f, 0));
    }

    public void setGreekLower(boolean bl) {
        this.lowercase = bl;
    }

    public boolean isGreekLower() {
        return this.lowercase;
    }

    public boolean add(Object object) {
        if (object instanceof ListItem) {
            ListItem listItem = (ListItem)object;
            int n = this.first + this.list.size();
            int[] nArray = GreekList.getGreekValue(n, this.lowercase);
            Chunk chunk = SpecialSymbol.get((char)nArray[0], this.symbol.font());
            for (int i = 1; i < nArray.length; ++i) {
                chunk.append(String.valueOf(SpecialSymbol.getCorrespondingSymbol((char)nArray[i])));
            }
            chunk.append(". ");
            listItem.setListSymbol(chunk);
            listItem.setIndentationLeft(this.symbolIndent, this.autoindent);
            listItem.setIndentationRight(0.0f);
            this.list.add(listItem);
        } else {
            if (object instanceof List) {
                List list = (List)object;
                list.setIndentationLeft(list.indentationLeft() + this.symbolIndent);
                --this.first;
                return this.list.add(list);
            }
            if (object instanceof String) {
                return this.add(new ListItem((String)object));
            }
        }
        return false;
    }

    public static int[] getGreekValue(int n, boolean bl) {
        if (n < 1) {
            return new int[0];
        }
        --n;
        int n2 = 1;
        int n3 = 0;
        int n4 = 24;
        while (n >= n4 + n3) {
            ++n2;
            n3 += n4;
            n4 *= 24;
        }
        int n5 = n - n3;
        int[] nArray = new int[n2];
        while (n2 > 0) {
            nArray[--n2] = n5 % 24;
            if (nArray[n2] > 16) {
                int n6 = n2;
                nArray[n6] = nArray[n6] + 1;
            }
            int n7 = n2;
            nArray[n7] = nArray[n7] + (bl ? 945 : 913);
            n5 /= 24;
        }
        return nArray;
    }
}

