/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.calculators;

import cytoscape.CyNetwork;
import cytoscape.visual.NodeAppearance;
import cytoscape.visual.calculators.NodeCalculator;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.parsers.DoubleParser;
import giny.model.GraphObject;
import giny.model.Node;
import java.util.Properties;

abstract class AbstractNodeSizeCalculator
extends NodeCalculator {
    protected byte sizeType;
    protected String propertyLabel;
    protected String typename;
    protected int WIDTH = 1;
    protected int HEIGHT = 2;
    protected int SIZE = 4;

    public void set(byte b, String p, String n) {
        this.sizeType = b;
        this.propertyLabel = p;
        this.typename = n;
    }

    public abstract byte getType();

    public abstract String getPropertyLabel();

    public abstract String getTypeName();

    AbstractNodeSizeCalculator() {
    }

    public AbstractNodeSizeCalculator(String name, ObjectMapping m) {
        super(name, m, Number.class);
    }

    public AbstractNodeSizeCalculator(String name, Properties props, String baseKey) {
        super(name, props, baseKey, new DoubleParser(), new Double(0.0));
    }

    public abstract void apply(NodeAppearance var1, Node var2, CyNetwork var3);

    protected void apply(NodeAppearance appr, Node node, CyNetwork network, int type) {
        Object rangeValue = this.getRangeValue((GraphObject)node);
        if (rangeValue == null) {
            return;
        }
        double ret = ((Number)rangeValue).doubleValue();
        if (type == this.WIDTH) {
            appr.setJustWidth(ret);
        }
        if (type == this.HEIGHT) {
            appr.setJustHeight(ret);
        }
        if (type == this.SIZE) {
            appr.setSize(ret);
        }
    }
}

