/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.calculators.CalculatorFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalculatorIO {
    public static final String nodeColorBaseKey = "nodeColorCalculator";
    public static final String nodeSizeBaseKey = "nodeSizeCalculator";
    public static final String edgeArrowBaseKey = "edgeArrowCalculator";
    private static final String nodeFillColorBaseKey = CalculatorFactory.getPropertyLabel((byte)0);
    private static final String nodeBorderColorBaseKey = CalculatorFactory.getPropertyLabel((byte)1);
    private static final String nodeWidthBaseKey = CalculatorFactory.getPropertyLabel((byte)127);
    private static final String nodeHeightBaseKey = CalculatorFactory.getPropertyLabel((byte)126);
    private static final String nodeUniformSizeBaseKey = CalculatorFactory.getPropertyLabel((byte)4);
    private static final String edgeSourceArrowBaseKey = CalculatorFactory.getPropertyLabel((byte)10);
    private static final String edgeTargetArrowBaseKey = CalculatorFactory.getPropertyLabel((byte)11);
    private static final String nodeAppearanceBaseKey = "nodeAppearanceCalculator";
    private static final String edgeAppearanceBaseKey = "edgeAppearanceCalculator";
    private static final String globalAppearanceBaseKey = "globalAppearanceCalculator";
    public static final String dirHeader = "cytoscape.visual.calculators.";
    public static final String nodeColorClassName = "NodeColorCalculator";
    public static final String nodeLineTypeBaseKey = "nodeLineTypeCalculator";
    public static final String nodeLineTypeClassName = "NodeLineTypeCalculator";
    public static final String nodeShapeBaseKey = "nodeShapeCalculator";
    public static final String nodeShapeClassName = "NodeShapeCalculator";
    public static final String nodeSizeClassName = "NodeSizeCalculator";
    public static final String nodeLabelBaseKey = "nodeLabelCalculator";
    public static final String nodeLabelClassName = "NodeLabelCalculator";
    public static final String nodeToolTipBaseKey = "nodeToolTipCalculator";
    public static final String nodeToolTipClassName = "NodeToolTipCalculator";
    public static final String nodeFontFaceBaseKey = "nodeFontFaceCalculator";
    public static final String nodeFontFaceClassName = "NodeFontFaceCalculator";
    public static final String nodeFontSizeBaseKey = "nodeFontSizeCalculator";
    public static final String nodeFontSizeClassName = "NodeFontSizeCalculator";
    public static final String edgeColorBaseKey = "edgeColorCalculator";
    public static final String edgeColorClassName = "EdgeColorCalculator";
    public static final String edgeLineTypeBaseKey = "edgeLineTypeCalculator";
    public static final String edgeLineTypeClassName = "EdgeLineTypeCalculator";
    public static final String edgeArrowClassName = "EdgeArrowCalculator";
    public static final String edgeLabelBaseKey = "edgeLabelCalculator";
    public static final String edgeLabelClassName = "EdgeLabelCalculator";
    public static final String edgeToolTipBaseKey = "edgeToolTipCalculator";
    public static final String edgeToolTipClassName = "EdgeToolTipCalculator";
    public static final String edgeFontFaceBaseKey = "edgeFontFaceCalculator";
    public static final String edgeFontFaceClassName = "EdgeFontFaceCalculator";
    public static final String edgeFontSizeBaseKey = "edgeFontSizeCalculator";
    public static final String edgeFontSizeClassName = "EdgeFontSizeCalculator";

    public static void storeCatalog(CalculatorCatalog catalog, File outFile) {
        try {
            String lineSep = System.getProperty("line.separator");
            StringBuffer header = new StringBuffer();
            header.append("This file specifies visual mappings for Cytoscape");
            header.append(" and has been automatically generated.").append(lineSep);
            header.append("# WARNING: any changes you make to this file while");
            header.append(" Cytoscape is running may be overwritten.").append(lineSep);
            header.append("# Any changes may make these visual mappings unreadable.");
            header.append(lineSep);
            header.append("# Please make sure you know what you are doing before");
            header.append(" modifying this file by hand.").append(lineSep);
            BufferedWriter writer = new BufferedWriter(new FileWriter(outFile));
            Properties props = CalculatorIO.getProperties(catalog);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            props.store(buffer, header.toString());
            String theData = buffer.toString();
            BufferedReader reader = new BufferedReader(new StringReader(theData));
            ArrayList<String> headerLines = new ArrayList<String>();
            ArrayList<String> lines = new ArrayList<String>();
            String oneLine = reader.readLine();
            while (oneLine != null) {
                if (oneLine.startsWith("#")) {
                    headerLines.add(oneLine);
                } else {
                    lines.add(oneLine);
                }
                oneLine = reader.readLine();
            }
            Collections.sort(lines);
            for (String theLine : headerLines) {
                writer.write(theLine, 0, theLine.length());
                writer.newLine();
            }
            for (String theLine : lines) {
                writer.write(theLine, 0, theLine.length());
                writer.newLine();
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Properties getProperties(CalculatorCatalog catalog) {
        Properties newProps = new Properties();
        for (Calculator c : catalog.getCalculators()) {
            newProps.putAll((Map<?, ?>)c.getProperties());
        }
        Set visualStyleNames = catalog.getVisualStyleNames();
        for (String name : visualStyleNames) {
            VisualStyle vs = catalog.getVisualStyle(name);
            try {
                Properties styleProps = new Properties();
                NodeAppearanceCalculator nac = vs.getNodeAppearanceCalculator();
                String nacBaseKey = "nodeAppearanceCalculator." + name;
                Properties nacProps = nac.getProperties(nacBaseKey);
                styleProps.putAll((Map<?, ?>)nacProps);
                EdgeAppearanceCalculator eac = vs.getEdgeAppearanceCalculator();
                String eacBaseKey = "edgeAppearanceCalculator." + name;
                Properties eacProps = eac.getProperties(eacBaseKey);
                styleProps.putAll((Map<?, ?>)eacProps);
                GlobalAppearanceCalculator gac = vs.getGlobalAppearanceCalculator();
                String gacBaseKey = "globalAppearanceCalculator." + name;
                Properties gacProps = gac.getProperties(gacBaseKey);
                styleProps.putAll((Map<?, ?>)gacProps);
                newProps.putAll((Map<?, ?>)styleProps);
            }
            catch (Exception e) {
                String s = "Exception while saving visual style " + name;
                System.err.println(s);
                System.err.println(e.getMessage());
            }
        }
        return newProps;
    }

    public static void loadCalculators(Properties props, CalculatorCatalog catalog) {
        CalculatorIO.loadCalculators(props, catalog, true);
    }

    public static void loadCalculators(Properties props, CalculatorCatalog catalog, boolean overWrite) {
        HashMap<String, Map<String, Properties>> calcNames = new HashMap<String, Map<String, Properties>>();
        Enumeration<?> eI = props.propertyNames();
        while (eI.hasMoreElements()) {
            String key = (String)eI.nextElement();
            if (key.startsWith("nodeColorCalculator.")) {
                key = CalculatorIO.updateLegacyKey(key, props, nodeColorBaseKey, nodeFillColorBaseKey, "cytoscape.visual.calculators.GenericNodeFillColorCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                key = CalculatorIO.updateLegacyKey(key, props, nodeFillColorBaseKey, nodeBorderColorBaseKey, "cytoscape.visual.calculators.GenericNodeBorderColorCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                continue;
            }
            if (key.startsWith("nodeSizeCalculator.")) {
                key = CalculatorIO.updateLegacyKey(key, props, nodeSizeBaseKey, nodeUniformSizeBaseKey, "cytoscape.visual.calculators.GenericNodeUniformSizeCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                key = CalculatorIO.updateLegacyKey(key, props, nodeUniformSizeBaseKey, nodeWidthBaseKey, "cytoscape.visual.calculators.GenericNodeWidthCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                key = CalculatorIO.updateLegacyKey(key, props, nodeWidthBaseKey, nodeHeightBaseKey, "cytoscape.visual.calculators.GenericNodeHeightCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                continue;
            }
            if (key.startsWith("edgeArrowCalculator.")) {
                key = CalculatorIO.updateLegacyKey(key, props, edgeArrowBaseKey, edgeSourceArrowBaseKey, "cytoscape.visual.calculators.GenericEdgeSourceArrowCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                key = CalculatorIO.updateLegacyKey(key, props, edgeSourceArrowBaseKey, edgeTargetArrowBaseKey, "cytoscape.visual.calculators.GenericEdgeTargetArrowCalculator");
                CalculatorIO.storeKey(key, props, calcNames);
                continue;
            }
            CalculatorIO.storeKey(key, props, calcNames);
        }
        for (String calcTypeKey : calcNames.keySet()) {
            CalculatorIO.handleCalculators((Map)calcNames.get(calcTypeKey), catalog, overWrite, calcTypeKey);
        }
        HashMap<String, VisualStyle> visualStyles = new HashMap<String, VisualStyle>();
        Map nacNames = (Map)calcNames.get(nodeAppearanceBaseKey);
        for (String name : nacNames.keySet()) {
            Properties nacProps = (Properties)nacNames.get(name);
            String apprType = "nodeAppearanceCalculator." + name;
            NodeAppearanceCalculator nac = new NodeAppearanceCalculator(name, nacProps, apprType, catalog);
            VisualStyle vs = (VisualStyle)visualStyles.get(name);
            if (vs == null) {
                vs = new VisualStyle(name);
                visualStyles.put(name, vs);
            }
            vs.setNodeAppearanceCalculator(nac);
        }
        Map eacNames = (Map)calcNames.get(edgeAppearanceBaseKey);
        for (String name : eacNames.keySet()) {
            Properties eacProps = (Properties)eacNames.get(name);
            String apprType = "edgeAppearanceCalculator." + name;
            EdgeAppearanceCalculator eac = new EdgeAppearanceCalculator(name, eacProps, apprType, catalog);
            VisualStyle vs = (VisualStyle)visualStyles.get(name);
            if (vs == null) {
                vs = new VisualStyle(name);
                visualStyles.put(name, vs);
            }
            vs.setEdgeAppearanceCalculator(eac);
        }
        Map gacNames = (Map)calcNames.get(globalAppearanceBaseKey);
        for (String name : gacNames.keySet()) {
            Properties gacProps = (Properties)gacNames.get(name);
            String apprType = "globalAppearanceCalculator." + name;
            GlobalAppearanceCalculator gac = new GlobalAppearanceCalculator(name, gacProps, apprType, catalog);
            VisualStyle vs = (VisualStyle)visualStyles.get(name);
            if (vs == null) {
                vs = new VisualStyle(name);
                visualStyles.put(name, vs);
            }
            vs.setGlobalAppearanceCalculator(gac);
        }
        for (VisualStyle vs : visualStyles.values()) {
            catalog.addVisualStyle(vs);
        }
    }

    private static void storeKey(String key, Properties props, Map<String, Map<String, Properties>> calcNames) {
        String name;
        String calcTypeKey = CalculatorIO.extractCalcType(key);
        if (calcTypeKey == null) {
            System.err.println("couldn't parse calcTypeKey from '" + key + "'");
            return;
        }
        Map<String, Properties> name2props = calcNames.get(calcTypeKey);
        if (name2props == null) {
            name2props = new HashMap<String, Properties>();
            calcNames.put(calcTypeKey, name2props);
        }
        if ((name = CalculatorIO.extractName(key)) != null) {
            Properties calcProps = name2props.get(name);
            if (calcProps == null) {
                calcProps = new Properties();
                name2props.put(name, calcProps);
            }
            calcProps.setProperty(key, props.getProperty(key));
        }
    }

    private static String extractName(String key) {
        if (key == null) {
            return null;
        }
        int dot1 = key.indexOf(".");
        if (dot1 == -1 || dot1 >= key.length() - 1) {
            return null;
        }
        int dot2 = key.indexOf(".", dot1 + 1);
        if (dot2 == -1) {
            return null;
        }
        return key.substring(dot1 + 1, dot2);
    }

    private static String extractCalcType(String key) {
        if (key == null) {
            return null;
        }
        int dot1 = key.indexOf(".");
        if (dot1 == -1 || dot1 >= key.length() - 1) {
            return null;
        }
        return key.substring(0, dot1);
    }

    private static void handleCalculators(Map<String, Properties> nameMap, CalculatorCatalog catalog, boolean overWrite, String calcTypeKey) {
        for (String name : nameMap.keySet()) {
            String keyString;
            Properties calcProps;
            Calculator c = CalculatorFactory.newCalculator(name, calcProps = nameMap.get(name), keyString = calcTypeKey + "." + name);
            if (c == null) continue;
            if (overWrite) {
                catalog.removeCalculator(c);
            } else {
                CalculatorIO.renameAsNeeded(c, catalog);
            }
            catalog.addCalculator(c);
        }
    }

    public static void renameAsNeeded(Calculator c, CalculatorCatalog catalog) {
        String name = ((Object)c).toString();
        String newName = catalog.checkCalculatorName(c.getType(), name);
        if (!newName.equals(name)) {
            c.setName(newName);
        }
    }

    private static String updateLegacyKey(String key, Properties props, String oldKey, String newKey, String newClass) {
        String value = props.getProperty(key);
        if ((key = key.replace(oldKey, newKey)).endsWith(".class")) {
            props.setProperty(key, newClass);
        } else {
            props.setProperty(key, value);
        }
        return key;
    }

    public static void removeDuplicate(Calculator c, CalculatorCatalog catalog) {
        catalog.removeCalculator(c);
    }
}

