/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.synonyms;

import cytoscape.Cytoscape;
import cytoscape.data.synonyms.AliasType;
import cytoscape.data.synonyms.Aliases;
import giny.model.Node;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;

public class AliasesTest
extends TestCase {
    Aliases al;
    List<String> sampleData;

    protected void setUp() throws Exception {
        super.setUp();
        this.sampleData = new ArrayList<String>();
        this.sampleData.add("alias1");
        this.sampleData.add("alias2");
        this.sampleData.add("alias3");
        this.al = new Aliases(AliasType.NODE);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.al = null;
    }

    public void testAdd() {
        Iterator it = Cytoscape.getRootGraph().nodesIterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            String name = node.getIdentifier();
            this.al.add(name, this.sampleData);
            this.al.add(name, "testAlias");
            AliasesTest.assertTrue((boolean)this.al.getAliases(name).contains("alias2"));
            AliasesTest.assertEquals((int)4, (int)this.al.getAliases(name).size());
        }
    }

    public void testRemove() {
        Iterator it = Cytoscape.getRootGraph().nodesIterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            String name = node.getIdentifier();
            this.al.add(name, this.sampleData);
            AliasesTest.assertEquals((int)3, (int)this.al.getAliases(name).size());
            this.al.remove(name, "alias3");
            AliasesTest.assertEquals((int)2, (int)this.al.getAliases(name).size());
            AliasesTest.assertTrue((boolean)this.al.getAliases(name).contains("alias2"));
            AliasesTest.assertFalse((boolean)this.al.getAliases(name).contains("alias3"));
        }
    }
}

