/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.servers.ui;

import cytoscape.util.CyFileFilter;
import cytoscape.util.FileUtil;
import cytoscape.util.OpenBrowser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.layout.GroupLayout;

public class OboPanel
extends JPanel {
    private static final String defaultOboSource = "http://www.geneontology.org/ontology/gene_ontology.obo";
    private final String LS = System.getProperty("line.separator");
    private File oboFile;
    private JEditorPane headerEditorPane;
    private JScrollPane headerScrollPane1;
    private JSeparator jSeparator1;
    private JEditorPane messageEditorPane;
    private JScrollPane messageScrollPane;
    private JTextField oboFileNameTextField;
    private JButton selectButton;
    private JLabel titleLabel;

    public OboPanel() {
        this.initComponents();
    }

    private void initComponents() {
        String message = "<html><body>Please select an ontology data file in <a href=\"http://www.geneontology.org/GO.downloads.shtml#ont\">OBO format</a>:</body></html>";
        this.oboFileNameTextField = new JTextField();
        this.selectButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.titleLabel = new JLabel();
        this.headerScrollPane1 = new JScrollPane();
        this.headerEditorPane = new JEditorPane();
        this.messageScrollPane = new JScrollPane();
        this.messageEditorPane = new JEditorPane("text/html", message);
        this.oboFileNameTextField.setToolTipText("Select or type local OBO file name...");
        this.oboFileNameTextField.setBorder(BorderFactory.createTitledBorder(null, "OBO File", 0, 0, new Font("Serif", 1, 10)));
        this.oboFileNameTextField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                OboPanel.this.oboFileNameTextFieldPropertyChange(evt);
            }
        });
        this.oboFileNameTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OboPanel.this.oboFileNameTextFieldActionPerformed(evt);
            }
        });
        this.selectButton.setText("Select");
        this.selectButton.setActionCommand("selectOboButton");
        this.selectButton.setMargin(new Insets(2, 2, 2, 2));
        this.titleLabel.setFont(new Font("Serif", 1, 14));
        this.titleLabel.setText("Select Ontology File");
        this.headerScrollPane1.setBorder(BorderFactory.createTitledBorder("Header Preview"));
        this.headerEditorPane.setEditable(false);
        this.headerScrollPane1.setViewportView(this.headerEditorPane);
        this.messageScrollPane.setBorder(null);
        this.messageEditorPane.setBackground(new Color(204, 204, 204));
        this.messageEditorPane.setBorder(null);
        this.messageEditorPane.setEditable(false);
        this.messageEditorPane.setFont(new Font("Serif", 1, 12));
        this.messageEditorPane.setToolTipText("Click hyperlink to visit GO web site...");
        this.messageEditorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                OboPanel.this.messageEditorPaneHyperlinkUpdate(evt);
            }
        });
        this.messageScrollPane.setViewportView(this.messageEditorPane);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSeparator1, -1, 325, Short.MAX_VALUE).add((Component)this.titleLabel, -1, 325, Short.MAX_VALUE).add(2, (Component)this.messageScrollPane).add((Component)this.oboFileNameTextField, -1, 325, Short.MAX_VALUE).add(2, (Component)this.headerScrollPane1, -1, 325, Short.MAX_VALUE).add(2, (Component)this.selectButton, -2, 96, -2)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.titleLabel).addPreferredGap(0).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((Component)this.messageScrollPane, -2, -1, -2).addPreferredGap(0).add((Component)this.oboFileNameTextField, -2, -1, -2).addPreferredGap(0).add((Component)this.headerScrollPane1, -1, 122, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.selectButton).addContainerGap()));
    }

    private void messageEditorPaneHyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            OpenBrowser.openURL(evt.getURL().toString());
        }
    }

    protected void selectButtonActionPerformed() {
        CyFileFilter oboFilter = new CyFileFilter();
        oboFilter.addExtension("obo");
        oboFilter.setDescription("OBO files");
        File originalFile = this.oboFile;
        this.oboFile = FileUtil.getFile("Import OBO File", FileUtil.LOAD, new CyFileFilter[]{oboFilter});
        if (this.oboFile != null && this.oboFile.canRead()) {
            this.oboFileNameTextField.setText(this.oboFile.getAbsolutePath());
            this.oboFileNameTextField.setToolTipText(this.oboFile.getAbsolutePath());
            try {
                BufferedReader br = new BufferedReader(new FileReader(this.oboFile));
                this.headerEditorPane.setText(this.getHeader(br));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (originalFile == null || !originalFile.canRead()) {
            if (this.oboFile != null) {
                this.oboFileNameTextField.setText(this.oboFile.getAbsolutePath());
            }
            this.headerEditorPane.setText("This is not a valid OBO file!!");
        }
    }

    private void oboFileNameTextFieldPropertyChange(PropertyChangeEvent evt) {
    }

    private void oboFileNameTextFieldActionPerformed(ActionEvent evt) {
        System.out.println("VC!!!");
    }

    private String getHeader(BufferedReader br) throws IOException {
        String line;
        String header = "";
        while ((line = br.readLine()) != null && !line.startsWith("[Term]")) {
            header = header + line + this.LS;
        }
        return header.trim();
    }

    protected File getOboFile() {
        return this.oboFile;
    }

    protected void setOboFileName(String text) {
        this.oboFileNameTextField.setText(text);
    }

    protected void setPreviewPane(String text) {
        this.messageEditorPane.setText(text);
    }

    protected void addButtonActionListener(ActionListener l) {
        this.selectButton.addActionListener(l);
    }
}

