/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.Cytoscape;
import cytoscape.generated2.Att;
import cytoscape.generated2.Graphics;
import cytoscape.visual.Arrow;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.LineType;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.ShapeNodeRealizer;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.calculators.GenericEdgeColorCalculator;
import cytoscape.visual.calculators.GenericEdgeFontFaceCalculator;
import cytoscape.visual.calculators.GenericEdgeLabelCalculator;
import cytoscape.visual.calculators.GenericEdgeLineTypeCalculator;
import cytoscape.visual.calculators.GenericEdgeSourceArrowCalculator;
import cytoscape.visual.calculators.GenericEdgeTargetArrowCalculator;
import cytoscape.visual.calculators.GenericNodeBorderColorCalculator;
import cytoscape.visual.calculators.GenericNodeFillColorCalculator;
import cytoscape.visual.calculators.GenericNodeFontFaceCalculator;
import cytoscape.visual.calculators.GenericNodeHeightCalculator;
import cytoscape.visual.calculators.GenericNodeLabelCalculator;
import cytoscape.visual.calculators.GenericNodeLineTypeCalculator;
import cytoscape.visual.calculators.GenericNodeShapeCalculator;
import cytoscape.visual.calculators.GenericNodeWidthCalculator;
import cytoscape.visual.mappings.DiscreteMapping;
import cytoscape.visual.mappings.PassThroughMapping;
import java.awt.Color;
import java.awt.Font;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class VisualStyleBuilder {
    protected static final byte DEFAULT_SHAPE = 8;
    protected static final Color DEFAULT_COLOR = Color.WHITE;
    protected static final Color DEFAULT_BORDER_COLOR = Color.BLACK;
    protected static final int DEFAULT_LINE_WIDTH = 1;
    private String styleName;
    private VisualStyle xgmmlStyle;
    private NodeAppearanceCalculator nac;
    private EdgeAppearanceCalculator eac;
    private GlobalAppearanceCalculator gac;
    private CalculatorCatalog catalog;
    private HashMap nodeGraphics;
    private HashMap edgeGraphics;
    private HashMap globalGraphics;

    public VisualStyleBuilder() {
        this.initialize();
    }

    public VisualStyleBuilder(String newName, Map nodeGraphics, Map edgeGraphics, Map globalGraphics) {
        this.initialize();
        this.nodeGraphics = (HashMap)nodeGraphics;
        this.edgeGraphics = (HashMap)edgeGraphics;
        this.globalGraphics = (HashMap)globalGraphics;
        this.styleName = newName;
    }

    private void initialize() {
        this.nac = new NodeAppearanceCalculator();
        this.eac = new EdgeAppearanceCalculator();
        this.gac = new GlobalAppearanceCalculator();
        this.nac.setNodeSizeLocked(false);
    }

    public void buildStyle() {
        VisualMappingManager vizmapper = Cytoscape.getVisualMappingManager();
        this.catalog = vizmapper.getCalculatorCatalog();
        this.setNodeMaps(vizmapper);
        this.setEdgeMaps(vizmapper);
        this.gac.setDefaultBackgroundColor(new Color(255, 255, 204));
        this.xgmmlStyle = new VisualStyle(this.styleName, this.nac, this.eac, this.gac);
        this.catalog.addVisualStyle(this.xgmmlStyle);
        vizmapper.setVisualStyle(this.xgmmlStyle);
    }

    protected void setNodeMaps(VisualMappingManager vizmapper) {
        String cName = "XGMML Labels";
        Calculator nlc = this.catalog.getCalculator((byte)5, cName);
        if (nlc == null) {
            PassThroughMapping m = new PassThroughMapping((Object)"", "ID");
            nlc = new GenericNodeLabelCalculator(cName, m);
        }
        this.nac.setCalculator(nlc);
        DiscreteMapping nodeShapeMapping = new DiscreteMapping(new Byte(8), "ID", 1);
        nodeShapeMapping.setControllingAttributeName("ID", vizmapper.getNetwork(), false);
        DiscreteMapping nodeColorMapping = new DiscreteMapping(DEFAULT_COLOR, 1);
        nodeColorMapping.setControllingAttributeName("ID", vizmapper.getNetwork(), true);
        DiscreteMapping nodeBorderColorMapping = new DiscreteMapping(DEFAULT_BORDER_COLOR, 1);
        nodeBorderColorMapping.setControllingAttributeName("ID", vizmapper.getNetwork(), true);
        Double defaultWidth = new Double(this.nac.getDefaultAppearance().getWidth());
        DiscreteMapping nodeWMapping = new DiscreteMapping(defaultWidth, 1);
        nodeWMapping.setControllingAttributeName("ID", vizmapper.getNetwork(), true);
        Double defaultHeight = new Double(this.nac.getDefaultAppearance().getHeight());
        DiscreteMapping nodeHMapping = new DiscreteMapping(defaultHeight, 1);
        nodeHMapping.setControllingAttributeName("ID", vizmapper.getNetwork(), true);
        DiscreteMapping nodeBorderTypeMapping = new DiscreteMapping(LineType.LINE_1, 1);
        nodeBorderTypeMapping.setControllingAttributeName("ID", vizmapper.getNetwork(), false);
        Font defaultNodeFont = this.nac.getDefaultAppearance().getFont();
        DiscreteMapping nodeLabelFontMapping = new DiscreteMapping(defaultNodeFont, 1);
        nodeLabelFontMapping.setControllingAttributeName("ID", vizmapper.getNetwork(), true);
        for (String key : this.nodeGraphics.keySet()) {
            LineType lt;
            Double h;
            Double w;
            Color nodeBorderColor;
            Color nodeColor;
            Byte shapeValue;
            Font nodeFont = null;
            Graphics curGraphics = (Graphics)this.nodeGraphics.get(key);
            List<Att> localNodeGraphics = null;
            Iterator<Object> localIt = null;
            if (curGraphics != null && (localNodeGraphics = curGraphics.getAtt()) != null) {
                Att lg = localNodeGraphics.get(0);
                localIt = lg.getContent().iterator();
            }
            if (curGraphics != null && curGraphics.getType() != null) {
                shapeValue = ShapeNodeRealizer.parseNodeShapeTextIntoByte(curGraphics.getType().value());
                nodeColor = this.getColor(curGraphics.getFill());
                nodeBorderColor = this.getColor(curGraphics.getOutline());
                w = new Double(curGraphics.getW());
                h = new Double(curGraphics.getH());
                BigInteger lineWidth = curGraphics.getWidth();
                lt = lineWidth != null ? VisualStyleBuilder.getLineType(lineWidth.intValue()) : LineType.LINE_1;
                while (localIt.hasNext()) {
                    Att nodeAttr = null;
                    Object curObj = localIt.next();
                    if (!curObj.getClass().equals(Att.class)) continue;
                    nodeAttr = (Att)curObj;
                    if (nodeAttr.getName().equals("nodeLabelFont")) {
                        String nodeLabelFont = nodeAttr.getValue();
                        String[] fontString = nodeLabelFont.split("-");
                        nodeFont = new Font(fontString[0], Integer.parseInt(fontString[1]), Integer.parseInt(fontString[2]));
                        continue;
                    }
                    if (!nodeAttr.getName().equals("borderLineType")) continue;
                }
            } else {
                shapeValue = new Byte(8);
                nodeColor = DEFAULT_COLOR;
                nodeBorderColor = DEFAULT_BORDER_COLOR;
                w = defaultWidth;
                h = defaultHeight;
                lt = LineType.LINE_1;
                nodeFont = new Font("Default", 0, 10);
            }
            nodeShapeMapping.putMapValue(key, shapeValue);
            nodeColorMapping.putMapValue(key, nodeColor);
            nodeBorderColorMapping.putMapValue(key, nodeBorderColor);
            nodeWMapping.putMapValue(key, w);
            nodeHMapping.putMapValue(key, h);
            nodeBorderTypeMapping.putMapValue(key, lt);
            nodeLabelFontMapping.putMapValue(key, nodeFont);
        }
        GenericNodeShapeCalculator shapeCalculator = new GenericNodeShapeCalculator("XGMML Node Shape", nodeShapeMapping);
        this.nac.setCalculator(shapeCalculator);
        GenericNodeFillColorCalculator nodeColorCalculator = new GenericNodeFillColorCalculator("XGMML Node Color", nodeColorMapping);
        this.nac.setCalculator(nodeColorCalculator);
        GenericNodeBorderColorCalculator nodeBorderColorCalculator = new GenericNodeBorderColorCalculator("XGMML Node Border Color", nodeBorderColorMapping);
        this.nac.setCalculator(nodeBorderColorCalculator);
        GenericNodeWidthCalculator nodeSizeCalculatorW = new GenericNodeWidthCalculator("XGMML Node Width", nodeWMapping);
        this.nac.setCalculator(nodeSizeCalculatorW);
        GenericNodeHeightCalculator nodeSizeCalculatorH = new GenericNodeHeightCalculator("XGMML Node Height", nodeHMapping);
        this.nac.setCalculator(nodeSizeCalculatorH);
        GenericNodeLineTypeCalculator nodeBoderTypeCalculator = new GenericNodeLineTypeCalculator("XGMML Node Border", nodeBorderTypeMapping);
        this.nac.setCalculator(nodeBoderTypeCalculator);
        GenericNodeFontFaceCalculator nodeFontCalculator = new GenericNodeFontFaceCalculator("XGMML Node Label Font", nodeLabelFontMapping);
        this.nac.setCalculator(nodeFontCalculator);
    }

    protected void setEdgeMaps(VisualMappingManager vizmapper) {
        String cName = "XGMML Labels";
        Calculator elc = this.catalog.getCalculator((byte)12, cName);
        if (elc == null) {
            PassThroughMapping m = new PassThroughMapping((Object)"", "ID");
            elc = new GenericEdgeLabelCalculator(cName, m);
        }
        this.eac.setCalculator(elc);
        DiscreteMapping edgeColorMapping = new DiscreteMapping(DEFAULT_COLOR, 0);
        edgeColorMapping.setControllingAttributeName("ID", vizmapper.getNetwork(), true);
        DiscreteMapping edgeLineTypeMapping = new DiscreteMapping(LineType.LINE_4, 0);
        edgeLineTypeMapping.setControllingAttributeName("ID", vizmapper.getNetwork(), true);
        Font defaultEdgeFont = this.eac.getDefaultAppearance().getFont();
        DiscreteMapping edgeLabelFontMapping = new DiscreteMapping(defaultEdgeFont, 0);
        edgeLabelFontMapping.setControllingAttributeName("ID", vizmapper.getNetwork(), true);
        DiscreteMapping edgeSourceArrowMapping = new DiscreteMapping(this.eac.getDefaultAppearance().getSourceArrow(), 0);
        edgeSourceArrowMapping.setControllingAttributeName("ID", vizmapper.getNetwork(), true);
        DiscreteMapping edgeTargetArrowMapping = new DiscreteMapping(this.eac.getDefaultAppearance().getTargetArrow(), 0);
        edgeTargetArrowMapping.setControllingAttributeName("ID", vizmapper.getNetwork(), true);
        for (String key : this.edgeGraphics.keySet()) {
            Color edgeColor;
            Font edgeFont = null;
            LineType edgeLineType = null;
            Arrow source = null;
            Arrow target = null;
            Graphics curGraphics = (Graphics)this.edgeGraphics.get(key);
            List<Att> localEdgeGraphics = null;
            Iterator<Object> localIt = null;
            if (curGraphics != null) {
                localEdgeGraphics = curGraphics.getAtt();
                localIt = null;
                if (localEdgeGraphics != null && localEdgeGraphics.size() != 0) {
                    Att lg = localEdgeGraphics.get(0);
                    localIt = lg.getContent().iterator();
                }
            }
            if (curGraphics != null) {
                edgeColor = this.getColor(curGraphics.getFill());
                Color sourceColor = null;
                Color targetColor = null;
                String sourceType = null;
                String targetType = null;
                if (localIt != null) {
                    while (localIt.hasNext()) {
                        Att edgeAttr = null;
                        Object curObj = localIt.next();
                        if (!curObj.getClass().equals(Att.class)) continue;
                        edgeAttr = (Att)curObj;
                        String edgeLabelFont = null;
                        if (edgeAttr.getName().equals("edgeLabelFont")) {
                            edgeLabelFont = edgeAttr.getValue();
                            String[] fontString = edgeLabelFont.split("-");
                            edgeFont = new Font(fontString[0], Integer.parseInt(fontString[1]), Integer.parseInt(fontString[2]));
                            continue;
                        }
                        if (edgeAttr.getName().equals("edgeLineType")) {
                            edgeLineType = LineType.parseLineTypeText(edgeAttr.getValue());
                            continue;
                        }
                        if (edgeAttr.getName().equals("sourceArrow")) {
                            sourceType = edgeAttr.getValue();
                            continue;
                        }
                        if (edgeAttr.getName().equals("targetArrow")) {
                            targetType = edgeAttr.getValue();
                            continue;
                        }
                        if (edgeAttr.getName().equals("sourceArrowColor")) {
                            sourceColor = this.getColor(edgeAttr.getValue());
                            continue;
                        }
                        if (!edgeAttr.getName().equals("targetArrowColor")) continue;
                        targetColor = this.getColor(edgeAttr.getValue());
                    }
                    if (sourceColor != null && sourceType != null) {
                        source = this.arrowBuilder(sourceType, sourceColor);
                    }
                    if (targetColor != null && targetType != null) {
                        target = this.arrowBuilder(targetType, targetColor);
                    }
                }
            } else {
                edgeColor = DEFAULT_COLOR;
                edgeLineType = LineType.LINE_1;
                edgeFont = new Font("Default", 0, 10);
                source = Arrow.NONE;
                target = Arrow.NONE;
            }
            edgeColorMapping.putMapValue(key, edgeColor);
            edgeLineTypeMapping.putMapValue(key, edgeLineType);
            edgeLabelFontMapping.putMapValue(key, edgeFont);
            edgeSourceArrowMapping.putMapValue(key, source);
            edgeTargetArrowMapping.putMapValue(key, target);
        }
        GenericEdgeColorCalculator edgeColorCalculator = new GenericEdgeColorCalculator("XGMML Edge Color", edgeColorMapping);
        this.eac.setCalculator(edgeColorCalculator);
        GenericEdgeLineTypeCalculator edgeLineTypeCalculator = new GenericEdgeLineTypeCalculator("XGMML Edge Line Type", edgeLineTypeMapping);
        this.eac.setCalculator(edgeLineTypeCalculator);
        GenericEdgeFontFaceCalculator edgeFontCalculator = new GenericEdgeFontFaceCalculator("XGMML Edge Label Font", edgeLabelFontMapping);
        this.eac.setCalculator(edgeFontCalculator);
        GenericEdgeSourceArrowCalculator edgeSourceArrowCalculator = new GenericEdgeSourceArrowCalculator("XGMML Source Edge Arrow", edgeSourceArrowMapping);
        this.eac.setCalculator(edgeSourceArrowCalculator);
        GenericEdgeTargetArrowCalculator edgeTargetArrowCalculator = new GenericEdgeTargetArrowCalculator("XGMML Target Edge Arrow", edgeTargetArrowMapping);
        this.eac.setCalculator(edgeTargetArrowCalculator);
    }

    private Color getColor(String colorString) {
        return new Color(Integer.parseInt(colorString.substring(1), 16));
    }

    private static LineType getLineType(int width) {
        if (width == 1) {
            return LineType.LINE_1;
        }
        if (width == 2) {
            return LineType.LINE_2;
        }
        if (width == 3) {
            return LineType.LINE_3;
        }
        if (width == 4) {
            return LineType.LINE_4;
        }
        if (width == 5) {
            return LineType.LINE_5;
        }
        if (width == 6) {
            return LineType.LINE_6;
        }
        if (width == 7) {
            return LineType.LINE_7;
        }
        return LineType.LINE_1;
    }

    private Arrow arrowBuilder(String type, Color color) {
        Arrow ar = Arrow.NONE;
        int intType = Integer.parseInt(type);
        if (intType == 7) {
            ar = Arrow.WHITE_DIAMOND;
        } else if (intType == 8) {
            ar = Arrow.BLACK_DIAMOND;
        } else if (intType == 9) {
            ar = Arrow.COLOR_DIAMOND;
        } else if (intType == 1) {
            ar = Arrow.WHITE_DELTA;
        } else if (intType == 2) {
            ar = Arrow.BLACK_DELTA;
        } else if (intType == 3) {
            ar = Arrow.COLOR_DELTA;
        } else if (intType == 4) {
            ar = Arrow.WHITE_ARROW;
        } else if (intType == 5) {
            ar = Arrow.BLACK_ARROW;
        } else if (intType == 6) {
            ar = Arrow.COLOR_ARROW;
        } else if (intType == 13) {
            ar = Arrow.WHITE_T;
        } else if (intType == 14) {
            ar = Arrow.BLACK_T;
        } else if (intType == 15) {
            ar = Arrow.COLOR_T;
        } else if (intType == 10) {
            ar = Arrow.WHITE_CIRCLE;
        } else if (intType == 11) {
            ar = Arrow.BLACK_CIRCLE;
        } else if (intType == 12) {
            ar = Arrow.COLOR_CIRCLE;
        }
        return ar;
    }
}

