/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.data.readers.GraphReader;
import cytoscape.util.CyNetworkNaming;
import giny.model.RootGraph;
import giny.view.GraphView;
import giny.view.NodeView;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;

public abstract class AbstractGraphReader
implements GraphReader {
    protected String fileName;

    public AbstractGraphReader(String fileName) {
        this.fileName = fileName;
    }

    public abstract void read() throws IOException;

    public void read(boolean canonicalizeNodeNames) throws IOException {
        this.read();
    }

    public RootGraph getRootGraph() {
        return Cytoscape.getRootGraph();
    }

    public CyAttributes getNodeAttributes() {
        return Cytoscape.getNodeAttributes();
    }

    public CyAttributes getEdgeAttributes() {
        return Cytoscape.getEdgeAttributes();
    }

    public void layout(GraphView view) {
        double distanceBetweenNodes = 80.0;
        int columns = (int)Math.sqrt(view.nodeCount());
        Iterator nodeViews = view.getNodeViewsIterator();
        double currX = 0.0;
        double currY = 0.0;
        int count = 0;
        while (nodeViews.hasNext()) {
            NodeView nView = (NodeView)nodeViews.next();
            nView.setOffset(currX, currY);
            if (++count == columns) {
                count = 0;
                currX = 0.0;
                currY += distanceBetweenNodes;
                continue;
            }
            currX += distanceBetweenNodes;
        }
    }

    public int[] getNodeIndicesArray() {
        return null;
    }

    public int[] getEdgeIndicesArray() {
        return null;
    }

    public String getNetworkName() {
        String t = "";
        if (this.fileName != null) {
            File tempFile = new File(this.fileName);
            t = tempFile.getName();
        }
        return CyNetworkNaming.getSuggestedNetworkTitle(t);
    }

    public void doPostProcessing(CyNetwork network) {
    }
}

