/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.data.mRNAMeasurement;
import cytoscape.task.TaskMonitor;
import cytoscape.util.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class ExpressionData
implements Serializable {
    private TaskMonitor taskMonitor;
    public static final int MAX_LINE_SIZE = 8192;
    public static final int PVAL = 0;
    public static final int LAMBDA = 1;
    public static final int NONE = 2;
    public static final int UNKNOWN = 3;
    private static final String DEFAULT_KEY_ATTRIBUTE = "ID";
    protected int significanceType = 3;
    String keyAttributeName = "ID";
    private boolean mappingByAttribute = false;
    String filename;
    int numGenes;
    int numConds;
    int extraTokens;
    boolean haveSigValues;
    Vector geneNames;
    Vector geneDescripts;
    Vector condNames;
    Hashtable geneNameToIndex;
    Hashtable condNameToIndex;
    double minExp;
    double maxExp;
    double minSig;
    double maxSig;
    Vector allMeasurements;

    public ExpressionData() {
        this.filename = null;
        this.keyAttributeName = DEFAULT_KEY_ATTRIBUTE;
        this.numGenes = 0;
        this.numConds = 0;
        this.extraTokens = 0;
        this.haveSigValues = false;
        this.initDataStructures();
    }

    public ExpressionData(String filename) throws IOException {
        this.filename = null;
        this.numGenes = 0;
        this.numConds = 0;
        this.extraTokens = 0;
        this.haveSigValues = false;
        this.initDataStructures();
        this.loadData(filename, DEFAULT_KEY_ATTRIBUTE);
    }

    public ExpressionData(String filename, String keyAttributeName) throws IOException {
        this.filename = null;
        this.numGenes = 0;
        this.numConds = 0;
        this.extraTokens = 0;
        this.haveSigValues = false;
        this.initDataStructures();
        this.loadData(filename, keyAttributeName);
    }

    public ExpressionData(String filename, TaskMonitor taskMonitor) throws IOException {
        this.taskMonitor = taskMonitor;
        this.filename = null;
        this.numGenes = 0;
        this.numConds = 0;
        this.extraTokens = 0;
        this.haveSigValues = false;
        this.initDataStructures();
        this.loadData(filename, DEFAULT_KEY_ATTRIBUTE);
    }

    public ExpressionData(String filename, String keyAttributeName, TaskMonitor taskMonitor) throws IOException {
        this.taskMonitor = taskMonitor;
        this.filename = null;
        this.numGenes = 0;
        this.numConds = 0;
        this.extraTokens = 0;
        this.haveSigValues = false;
        this.initDataStructures();
        this.loadData(filename, keyAttributeName);
    }

    public String getFileName() {
        return this.filename;
    }

    public File getFullPath() {
        File file = new File(this.filename);
        return file.getAbsoluteFile();
    }

    private void initDataStructures() {
        int expand = 1000;
        if (this.geneNames != null) {
            this.geneNames.clear();
        }
        this.geneNames = new Vector(0, expand);
        if (this.geneDescripts != null) {
            this.geneDescripts.clear();
        }
        this.geneDescripts = new Vector(0, expand);
        if (this.condNames != null) {
            this.condNames.clear();
        }
        this.condNames = new Vector();
        if (this.geneNameToIndex != null) {
            this.geneNameToIndex.clear();
        }
        this.geneNameToIndex = new Hashtable();
        if (this.condNameToIndex != null) {
            this.condNameToIndex.clear();
        }
        this.condNameToIndex = new Hashtable();
        this.minExp = Double.MAX_VALUE;
        this.maxExp = Double.MIN_VALUE;
        this.minSig = Double.MAX_VALUE;
        this.maxSig = Double.MIN_VALUE;
        if (this.allMeasurements != null) {
            this.allMeasurements.clear();
        }
        this.allMeasurements = new Vector(0, expand);
    }

    public boolean loadData(String filename, String keyAttributeName) throws IOException {
        int i;
        int numberOfConditions;
        StringTokenizer headerTok;
        int numTokens;
        String headerLine;
        Hashtable attributeToId = new Hashtable();
        if (filename == null) {
            return false;
        }
        boolean mappingByKeyAttribute = false;
        if (!keyAttributeName.equals(DEFAULT_KEY_ATTRIBUTE)) {
            mappingByKeyAttribute = true;
            attributeToId = this.getAttributeToIdList(keyAttributeName);
        }
        String rawText = FileUtil.getInputString(filename);
        String[] lines = rawText.split(System.getProperty("line.separator"));
        int lineCount = 0;
        if ((headerLine = lines[lineCount++]) == null || headerLine.length() == 0) {
            return false;
        }
        if (this.isHeaderLineMTXHeader(headerLine)) {
            this.significanceType = 1;
            headerLine = lines[lineCount++];
        }
        boolean expectPvals = this.doesHeaderLineHaveDuplicates(headerLine);
        if (this.significanceType != 1 && !expectPvals) {
            this.significanceType = 2;
        }
        if ((numTokens = (headerTok = new StringTokenizer(headerLine)).countTokens()) < 3 || numTokens < 4 && expectPvals) {
            StringBuffer msg = new StringBuffer("Invalid header format in data file.");
            msg.append("\nNumber of tokens parsed: " + numTokens);
            for (int i2 = 0; i2 < numTokens; ++i2) {
                msg.append("\nToken " + i2 + ": " + headerTok.nextToken());
            }
            throw new IOException(msg.toString());
        }
        double tmpF = (double)numTokens / 2.0;
        int tmpI = (int)Math.rint(tmpF);
        int haveExtraTokens = 0;
        if (expectPvals) {
            if ((double)tmpI == tmpF) {
                numberOfConditions = (numTokens - 2) / 2;
                haveExtraTokens = 0;
            } else {
                numberOfConditions = (numTokens - 3) / 2;
                haveExtraTokens = 1;
            }
        } else {
            numberOfConditions = numTokens - 2;
        }
        headerTok.nextToken();
        headerTok.nextToken();
        Vector<String> cNames = new Vector<String>(numberOfConditions);
        for (i = 0; i < numberOfConditions; ++i) {
            cNames.add(headerTok.nextToken());
        }
        if (expectPvals) {
            for (i = 0; i < numberOfConditions; ++i) {
                String title = headerTok.nextToken();
                if (title.equals(cNames.get(i))) continue;
                StringBuffer msg = new StringBuffer();
                msg.append("Expecting both ratios and p-values.\n");
                msg.append("Condition name mismatch in header line of data file " + filename + ": " + cNames.get(i) + " vs. " + title);
                throw new IOException(msg.toString());
            }
        }
        this.filename = filename;
        this.numConds = numberOfConditions;
        this.extraTokens = haveExtraTokens;
        this.haveSigValues = expectPvals;
        this.initDataStructures();
        this.condNames = cNames;
        for (i = 0; i < this.numConds; ++i) {
            this.condNameToIndex.put(this.condNames.get(i), new Integer(i));
        }
        if (this.taskMonitor != null) {
            this.taskMonitor.setStatus("Reading in Data...");
        }
        for (int ii = lineCount; ii < lines.length; ++ii) {
            if (this.taskMonitor != null) {
                double percentComplete = (double)ii / (double)lines.length * 100.0;
                this.taskMonitor.setPercentCompleted((int)percentComplete);
            }
            this.parseOneLine(lines[ii], ii, expectPvals, mappingByKeyAttribute, attributeToId);
        }
        this.numGenes = this.geneNames.size();
        for (i = 0; i < this.geneNames.size(); ++i) {
            if (this.geneNames.get(i) == null) continue;
            this.geneNameToIndex.put(this.geneNames.get(i), new Integer(i));
        }
        this.geneNames.trimToSize();
        this.geneDescripts.trimToSize();
        this.allMeasurements.trimToSize();
        return true;
    }

    private Object getAttributeValue(byte type, String id, String att) {
        if (type == 3) {
            return Cytoscape.getNodeAttributes().getIntegerAttribute(id, att);
        }
        if (type == 2) {
            return Cytoscape.getNodeAttributes().getDoubleAttribute(id, att);
        }
        if (type == 1) {
            return Cytoscape.getNodeAttributes().getBooleanAttribute(id, att);
        }
        if (type == 4) {
            return Cytoscape.getNodeAttributes().getStringAttribute(id, att);
        }
        if (type == -2) {
            return Cytoscape.getNodeAttributes().getListAttribute(id, att);
        }
        if (type == -3) {
            return Cytoscape.getNodeAttributes().getMapAttribute(id, att);
        }
        return null;
    }

    private Hashtable getAttributeToIdList(String keyAttributeName) {
        Hashtable attributeToIdList = new Hashtable();
        List allNodes = Cytoscape.getCyNodesList();
        byte attributeType = Cytoscape.getNodeAttributes().getType(keyAttributeName);
        for (CyNode node : allNodes) {
            String attributeValue;
            String nodeName = node.getIdentifier();
            Object attrValue = this.getAttributeValue(attributeType, nodeName, keyAttributeName);
            if (attrValue == null || (attributeValue = this.getAttributeValue(attributeType, nodeName, keyAttributeName).toString()) == null) continue;
            if (!attributeToIdList.contains(attributeValue)) {
                ArrayList<String> newGeneList = new ArrayList<String>();
                newGeneList.add(nodeName);
                attributeToIdList.put(attributeValue, newGeneList);
                continue;
            }
            ArrayList genesThisAttribute = (ArrayList)attributeToIdList.get(attributeValue);
            genesThisAttribute.add(nodeName);
        }
        return attributeToIdList;
    }

    private boolean doesHeaderLineHaveDuplicates(String hline) {
        boolean retval = false;
        StringTokenizer headerTok = new StringTokenizer(hline);
        int numTokens = headerTok.countTokens();
        if (numTokens < 3) {
            retval = false;
        } else {
            headerTok.nextToken();
            headerTok.nextToken();
            HashMap<String, String> names = new HashMap<String, String>();
            while (!retval && headerTok.hasMoreTokens()) {
                String title = headerTok.nextToken();
                String titleObject = title;
                if (names.get(titleObject) == null) {
                    names.put(titleObject, titleObject);
                    continue;
                }
                retval = true;
            }
        }
        return retval;
    }

    private boolean isHeaderLineNull(String hline, BufferedReader input, String filename) throws IOException {
        if (hline == null) {
            throw new IOException("Could not read header line from data file: " + filename);
        }
        return false;
    }

    private boolean isHeaderLineMTXHeader(String hline) {
        boolean b = false;
        String pattern = "\t+RATIOS\t+LAMBDAS";
        b = hline.matches(pattern);
        return b;
    }

    private String readOneLine(BufferedReader f) {
        String s = null;
        try {
            s = f.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return s;
    }

    private void parseOneLine(String oneLine, int lineCount, boolean sig_vals, boolean mappingByAttribute, Hashtable attributeToId) throws IOException {
        int i;
        StringTokenizer strtok = new StringTokenizer(oneLine);
        int numTokens = strtok.countTokens();
        if (numTokens == 0) {
            return;
        }
        String firstToken = strtok.nextToken();
        if (firstToken.startsWith("NumSigGenes")) {
            return;
        }
        if (sig_vals && numTokens < 2 * this.numConds + 2 || !sig_vals && numTokens < this.numConds + 2) {
            throw new IOException("Warning: parse error on line " + lineCount + "  tokens read: " + numTokens);
        }
        String geneDescript = strtok.nextToken();
        String[] expData = new String[this.numConds];
        for (int i2 = 0; i2 < this.numConds; ++i2) {
            expData[i2] = strtok.nextToken();
        }
        String[] sigData = new String[this.numConds];
        if (sig_vals) {
            for (i = 0; i < this.numConds; ++i) {
                sigData[i] = strtok.nextToken();
            }
        } else {
            for (i = 0; i < this.numConds; ++i) {
                sigData[i] = expData[i];
            }
        }
        ArrayList gNames = new ArrayList();
        if (mappingByAttribute) {
            if (attributeToId.containsKey(firstToken)) {
                gNames = (ArrayList)attributeToId.get(firstToken);
            }
        } else {
            gNames = new ArrayList();
            gNames.add(firstToken);
        }
        for (int ii = 0; ii < gNames.size(); ++ii) {
            this.geneNames.add(gNames.get(ii));
            this.geneDescripts.add(geneDescript);
            Vector<mRNAMeasurement> measurements = new Vector<mRNAMeasurement>(this.numConds);
            for (int jj = 0; jj < this.numConds; ++jj) {
                mRNAMeasurement m = new mRNAMeasurement(expData[jj], sigData[jj]);
                measurements.add(m);
                double ratio = m.getRatio();
                double signif = m.getSignificance();
                if (ratio < this.minExp) {
                    this.minExp = ratio;
                }
                if (ratio > this.maxExp) {
                    this.maxExp = ratio;
                }
                if (signif < this.minSig) {
                    this.minSig = signif;
                }
                if (!(signif > this.maxSig)) continue;
                this.maxSig = signif;
                if (this.significanceType == 1 || !sig_vals || !(this.maxSig > 1.0)) continue;
                this.significanceType = 1;
            }
            if (this.significanceType != 1 && sig_vals && this.minSig > 0.0) {
                this.significanceType = 0;
            }
            this.allMeasurements.add(measurements);
        }
    }

    public void convertLambdasToPvals() {
        for (Vector v : this.allMeasurements) {
            for (mRNAMeasurement m : v) {
                double pval = ExpressionData.getPvalueFromLambda(m.getSignificance());
                m.setSignificance(pval);
            }
        }
    }

    public static double getPvalueFromLambda(double lambda) {
        double x = StrictMath.sqrt(lambda) / 2.0;
        double t = 1.0 / (1.0 + 0.3275911 * x);
        double erfc = StrictMath.exp(-(x * x)) * (0.254829592 * t + -0.284496736 * StrictMath.pow(t, 2.0) + 1.421413741 * StrictMath.pow(t, 3.0) + -1.453152027 * StrictMath.pow(t, 4.0) + 1.061405429 * StrictMath.pow(t, 5.0));
        if ((erfc /= 2.0) < 0.0 || erfc > 1.0) {
            throw new IllegalStateException("The calculated pvalue for lambda = " + lambda + " is " + erfc);
        }
        return erfc;
    }

    public int getSignificanceType() {
        return this.significanceType;
    }

    public String getDescription() {
        String lineSep = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        File file = new File(this.filename);
        sb.append("Data read from: " + file.getName() + lineSep);
        sb.append(lineSep);
        sb.append("Number of genes = " + this.getNumberOfGenes() + lineSep);
        sb.append("Number of conditions = " + this.getNumberOfConditions() + lineSep);
        sb.append("Significance values: ");
        if (this.haveSigValues) {
            sb.append("yes");
        } else {
            sb.append("no");
        }
        sb.append(lineSep).append(lineSep);
        sb.append("MinExp: " + this.minExp + "    MaxExp: " + this.maxExp + lineSep);
        if (this.haveSigValues) {
            sb.append("MinSig: " + this.minSig + "    MaxSig: " + this.maxSig + lineSep);
            String sigType = null;
            if (this.significanceType == 3) {
                sigType = "unknown";
            } else if (this.significanceType == 1) {
                sigType = "lambda values";
            } else if (this.significanceType == 0) {
                sigType = "p-values";
            } else if (this.significanceType == 2) {
                sigType = "none";
            }
            sb.append("Type of significance: " + sigType + lineSep);
        }
        return sb.toString();
    }

    public void setGeneNames(Vector newNames) {
        this.geneNames = newNames;
        this.geneNameToIndex.clear();
        for (int i = 0; i < this.geneNames.size(); ++i) {
            this.geneNameToIndex.put(this.geneNames.get(i), new Integer(i));
        }
    }

    public String[] getGeneDescriptors() {
        return this.geneDescripts.toArray(new String[0]);
    }

    public Vector getGeneDescriptorsVector() {
        return this.geneDescripts;
    }

    public void setGeneDescriptors(Vector newDescripts) {
        this.geneDescripts = newDescripts;
    }

    public String[] getConditionNames() {
        return this.condNames.toArray(new String[0]);
    }

    public int getConditionIndex(String condition) {
        return (Integer)this.condNameToIndex.get(condition);
    }

    public String getGeneDescriptor(String gene) {
        Integer geneIndex = (Integer)this.geneNameToIndex.get(gene);
        if (geneIndex == null) {
            return null;
        }
        return (String)this.geneDescripts.get(geneIndex);
    }

    public boolean hasSignificanceValues() {
        return this.haveSigValues;
    }

    public Vector getAllMeasurements() {
        return this.allMeasurements;
    }

    public String[] getGeneNames() {
        return this.geneNames.toArray(new String[0]);
    }

    public Vector getGeneNamesVector() {
        return this.geneNames;
    }

    public int getNumberOfConditions() {
        return this.numConds;
    }

    public int getNumberOfGenes() {
        return this.numGenes;
    }

    public double[][] getExtremeValues() {
        double[][] maxVals = new double[2][2];
        maxVals[0][0] = this.minExp;
        maxVals[0][1] = this.maxExp;
        maxVals[1][0] = this.minSig;
        maxVals[1][1] = this.maxSig;
        return maxVals;
    }

    public Vector getMeasurements(String gene) {
        if (gene == null) {
            return null;
        }
        Integer geneIndex = (Integer)this.geneNameToIndex.get(gene);
        if (geneIndex == null) {
            return null;
        }
        Vector measurements = (Vector)this.getAllMeasurements().get(geneIndex);
        return measurements;
    }

    public mRNAMeasurement getMeasurement(String gene, String condition) {
        Integer condIndex = (Integer)this.condNameToIndex.get(condition);
        if (condIndex == null) {
            return null;
        }
        Vector measurements = this.getMeasurements(gene);
        if (measurements == null) {
            return null;
        }
        mRNAMeasurement returnVal = (mRNAMeasurement)measurements.get(condIndex);
        return returnVal;
    }

    public void copyToAttribs(CyAttributes nodeAttribs, TaskMonitor taskMonitor) {
        String[] condNames = this.getConditionNames();
        for (int condNum = 0; condNum < condNames.length; ++condNum) {
            String condName = condNames[condNum];
            String eStr = condName + "exp";
            String sStr = condName + "sig";
            for (int i = 0; i < this.geneNames.size(); ++i) {
                String canName = (String)this.geneNames.get(i);
                mRNAMeasurement mm = this.getMeasurement(canName, condName);
                if (mm != null) {
                    nodeAttribs.setAttribute(canName, eStr, new Double(mm.getRatio()));
                    nodeAttribs.setAttribute(canName, sStr, new Double(mm.getSignificance()));
                }
                if (taskMonitor == null) continue;
                int currentCoordinate = condNum * this.geneNames.size() + i;
                int matrixSize = condNames.length * this.geneNames.size();
                double percent = (double)currentCoordinate / (double)matrixSize * 100.0;
                taskMonitor.setPercentCompleted((int)percent);
            }
        }
    }
}

