/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.view;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.view.CyNetworkView;
import giny.view.EdgeView;
import giny.view.NodeView;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class CytoscapeViewTests
extends TestCase {
    CyNetwork network;
    CyNode node1;
    CyNode node2;
    CyEdge edge1;
    CyEdge edge2;
    CyNetworkView view;
    NodeView nodeView1;
    NodeView nodeView2;
    EdgeView edgeView1;
    EdgeView edgeView2;

    public CytoscapeViewTests(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.node1 = Cytoscape.getCyNode("node1", true);
        this.node2 = Cytoscape.getCyNode("node2", true);
        this.edge1 = Cytoscape.getCyEdge("node1", "node1 (pp) node2", "node2", "pp");
        this.edge2 = Cytoscape.getCyEdge("node2", "node2 (pp) node1", "node1", "pp");
        int[] nodeArray = new int[]{this.node1.getRootGraphIndex(), this.node2.getRootGraphIndex()};
        int[] edgeArray = new int[]{this.edge1.getRootGraphIndex(), this.edge2.getRootGraphIndex()};
        this.network = Cytoscape.createNetwork(nodeArray, edgeArray, null);
        this.view = Cytoscape.createNetworkView(this.network);
        this.nodeView1 = this.view.getNodeView(this.node1);
        this.nodeView2 = this.view.getNodeView(this.node2);
        this.edgeView1 = this.view.getEdgeView(this.edge1);
        this.edgeView2 = this.view.getEdgeView(this.edge2);
    }

    public void tearDown() throws Exception {
    }

    public void testFilterToView() throws Exception {
        this.checkState(false, false, false, false);
        this.network.setFlagged(this.node1, true);
        this.checkState(true, false, false, false);
        this.network.setFlagged(this.edge2, true);
        this.checkState(true, false, false, true);
        this.network.flagAllNodes();
        this.checkState(true, true, false, true);
        this.network.flagAllEdges();
        this.checkState(true, true, true, true);
        this.network.setFlagged(this.node2, false);
        this.checkState(true, false, true, true);
        this.network.setFlagged(this.edge1, false);
        this.checkState(true, false, false, true);
        this.network.unFlagAllEdges();
        this.checkState(true, false, false, false);
        this.network.unFlagAllNodes();
        this.checkState(false, false, false, false);
    }

    public void testViewToFilter() throws Exception {
        this.checkState(false, false, false, false);
        this.nodeView1.setSelected(true);
        this.checkState(true, false, false, false);
        this.edgeView2.setSelected(true);
        this.checkState(true, false, false, true);
        this.nodeView2.setSelected(true);
        this.checkState(true, true, false, true);
        this.edgeView1.setSelected(true);
        this.checkState(true, true, true, true);
        this.nodeView2.setSelected(false);
        this.checkState(true, false, true, true);
        this.edgeView1.setSelected(false);
        this.checkState(true, false, false, true);
        this.edgeView2.setSelected(false);
        this.checkState(true, false, false, false);
        this.nodeView1.setSelected(false);
        this.checkState(false, false, false, false);
    }

    public void checkState(boolean n1, boolean n2, boolean e1, boolean e2) {
        CytoscapeViewTests.assertTrue((this.network.isFlagged(this.node1) == n1 ? 1 : 0) != 0);
        CytoscapeViewTests.assertTrue((this.network.isFlagged(this.node2) == n2 ? 1 : 0) != 0);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(CytoscapeViewTests.class));
        Cytoscape.exit(0);
    }
}

