/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.data.attr.CountedIterator;
import cytoscape.dialogs.GinyEdgeControlDialog;
import cytoscape.view.CyNetworkView;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class EdgeManipulationAction
extends AbstractAction {
    CyNetworkView networkView;

    public EdgeManipulationAction(CyNetworkView networkView) {
        super("Edge select or hide by attributes...");
        this.networkView = networkView;
    }

    public void actionPerformed(ActionEvent e) {
        CyAttributes edgeAtts = Cytoscape.getEdgeAttributes();
        String[] edgeAttributeNames = edgeAtts.getAttributeNames();
        HashMap<String, String[]> attributesTree = new HashMap<String, String[]>();
        for (int i = 0; i < edgeAttributeNames.length; ++i) {
            String att = edgeAttributeNames[i];
            if (edgeAtts.getType(att) != 4) continue;
            CountedIterator it = edgeAtts.getMultiHashMap().getObjectKeys(att);
            HashSet<String> nameSet = new HashSet<String>();
            while (it.hasNext()) {
                String edgeId = (String)it.next();
                nameSet.add(edgeAtts.getStringAttribute(edgeId, att));
            }
            attributesTree.put(att, nameSet.toArray(new String[nameSet.size()]));
        }
        if (attributesTree.size() > 0) {
            GinyEdgeControlDialog dialog = new GinyEdgeControlDialog(this.networkView, attributesTree, "Edge Selection Control");
            dialog.pack();
            dialog.setLocationRelativeTo(this.networkView.getComponent());
            dialog.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(null, "There are no String edge attributes suitable for controlling edge display");
        }
    }
}

