/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.xml;

import java.io.IOException;
import java.io.PrintWriter;

public class FastXMLWriter {
    private PrintWriter writer;
    private boolean isOpeningTag = false;

    public FastXMLWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public void openTag(String qName) throws IOException {
        if (this.isOpeningTag) {
            this.writer.print('>');
        }
        this.writer.print('<');
        this.writer.print(qName);
        this.isOpeningTag = true;
    }

    public void attribute(String qName, String value) throws IOException {
        if (!this.isOpeningTag) {
            throw new IOException("attributes must follow an openTag");
        }
        this.writer.print(' ');
        this.writer.print(qName);
        this.writer.print("=\"");
        this.printAttributeValue(value);
        this.writer.print('\"');
    }

    public void closeTag(String qName) throws IOException {
        if (this.isOpeningTag) {
            this.writer.println(" />");
        } else {
            this.writer.print("</");
            this.writer.print(qName);
            this.writer.print('>');
        }
        this.isOpeningTag = false;
    }

    public void println(String data) throws IOException {
        if (this.isOpeningTag) {
            this.writer.println('>');
            this.isOpeningTag = false;
        }
        this.printChars(data);
        this.writer.println();
    }

    public void print(String data) throws IOException {
        if (this.isOpeningTag) {
            this.writer.print('>');
            this.isOpeningTag = false;
        }
        this.printChars(data);
    }

    public void printRaw(String data) throws IOException {
        this.writer.println(data);
    }

    protected void printChars(String data) throws IOException {
        if (data == null) {
            this.printChars("null");
            return;
        }
        for (int pos = 0; pos < data.length(); ++pos) {
            char c = data.charAt(pos);
            if (c == '<' || c == '>' || c == '&') {
                this.numericalEntity(c);
                continue;
            }
            this.writer.write(c);
        }
    }

    protected void printAttributeValue(String data) throws IOException {
        if (data == null) {
            this.printAttributeValue("null");
            return;
        }
        for (int pos = 0; pos < data.length(); ++pos) {
            char c = data.charAt(pos);
            if (c == '<' || c == '>' || c == '&' || c == '\"') {
                this.numericalEntity(c);
                continue;
            }
            this.writer.write(c);
        }
    }

    protected void numericalEntity(char c) throws IOException {
        this.writer.print("&#");
        this.writer.print((int)c);
        this.writer.print(';');
    }
}

