/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.stax;

import java.util.ArrayList;
import java.util.List;
import org.biojava.utils.stax.DelegationManager;
import org.biojava.utils.stax.StAXContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SAX2StAXAdaptor
extends DefaultHandler {
    private List stack = new ArrayList();
    private HandlerBinding current;

    public SAX2StAXAdaptor(StAXContentHandler rootHandler) {
        this.current = new HandlerBinding(rootHandler);
        this.stack.add(this.current);
    }

    public void startDocument() throws SAXException {
        this.current.handler.startTree();
    }

    public void endDocument() throws SAXException {
        this.current.handler.endTree();
    }

    public void characters(char[] ch, int start, int end) throws SAXException {
        this.current.handler.characters(ch, start, end);
    }

    public void ignorableWhitespace(char[] ch, int start, int end) throws SAXException {
        this.current.handler.ignorableWhitespace(ch, start, end);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.current.handler.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.current.handler.endPrefixMapping(prefix);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.current.handler.processingInstruction(target, data);
    }

    public void setDocumentLocator(Locator locator) {
        this.current.handler.setDocumentLocator(locator);
    }

    public void skippedEntity(String name) throws SAXException {
        this.current.handler.skippedEntity(name);
    }

    public void startElement(String nsURI, String localName, String qName, Attributes attrs) throws SAXException {
        S2SDelegationManager dm = new S2SDelegationManager();
        this.current.handler.startElement(nsURI, localName, qName, attrs, dm);
        if (dm.getDelegate() != null) {
            this.current = new HandlerBinding(dm.getDelegate());
            this.stack.add(this.current);
            this.current.handler.startTree();
            this.startElement(nsURI, localName, qName, attrs);
        } else {
            ++this.current.count;
        }
    }

    public void endElement(String nsURI, String localName, String qName) throws SAXException {
        this.current.handler.endElement(nsURI, localName, qName, null);
        --this.current.count;
        while (this.current.count == 0 && this.stack.size() > 1) {
            StAXContentHandler oldHandler = this.current.handler;
            this.current.handler.endTree();
            this.stack.remove(this.stack.size() - 1);
            this.current = (HandlerBinding)this.stack.get(this.stack.size() - 1);
            this.current.handler.endElement(nsURI, localName, qName, oldHandler);
        }
    }

    private class HandlerBinding {
        public StAXContentHandler handler;
        public int count;

        private HandlerBinding(StAXContentHandler handler) {
            this.handler = handler;
            this.count = 0;
        }
    }

    private static class S2SDelegationManager
    implements DelegationManager {
        private StAXContentHandler delegate;

        private S2SDelegationManager() {
        }

        public void delegate(StAXContentHandler handler) throws SAXException {
            if (this.delegate != null) {
                throw new SAXException("Tried to multiply delegate a single StAX element");
            }
            this.delegate = handler;
        }

        private StAXContentHandler getDelegate() {
            return this.delegate;
        }
    }
}

