/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.projection;

import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.projection.ProjectionUtils;
import org.biojava.bio.seq.projection.ReparentContext;
import org.biojava.bio.symbol.Location;

public class TranslateFlipContext
extends ReparentContext {
    private final int translation;
    private final boolean oppositeStrand;

    public TranslateFlipContext(FeatureHolder parent, FeatureHolder wrapped, int translate, boolean oppositeStrand) {
        super(parent, wrapped);
        this.translation = translate;
        this.oppositeStrand = oppositeStrand;
    }

    public TranslateFlipContext(FeatureHolder parent, FeatureHolder wrapped, int min, int max) {
        super(parent, wrapped);
        if (min > max) {
            throw new IllegalArgumentException("Max must not be less than min: " + min + "," + max);
        }
        this.translation = min + max;
        this.oppositeStrand = true;
    }

    public TranslateFlipContext(FeatureHolder parent, FeatureHolder wrapped, int translation) {
        super(parent, wrapped);
        this.translation = translation;
        this.oppositeStrand = false;
    }

    public final int getTranslation() {
        return this.translation;
    }

    public final boolean isOppositeStrand() {
        return this.oppositeStrand;
    }

    public Location projectLocation(Location oldLoc) {
        return oldLoc.newInstance(ProjectionUtils.transformLocation(oldLoc, this.translation, this.oppositeStrand));
    }

    public final Location revertLocation(Location oldLoc) {
        return oldLoc.newInstance(ProjectionUtils.revertLocation(oldLoc, this.translation, this.oppositeStrand));
    }

    public final StrandedFeature.Strand projectStrand(StrandedFeature.Strand strand) {
        if (this.oppositeStrand) {
            return strand.flip();
        }
        return strand;
    }

    public final StrandedFeature.Strand revertStrand(StrandedFeature.Strand strand) {
        return this.projectStrand(strand);
    }

    protected FilterUtils.FilterTransformer getTransformer() {
        final FilterUtils.FilterTransformer delegate = super.getTransformer();
        return new FilterUtils.FilterTransformer(){

            public FeatureFilter transform(FeatureFilter ff) {
                if ((ff = delegate.transform(ff)) instanceof FeatureFilter.OverlapsLocation) {
                    return new FeatureFilter.OverlapsLocation(TranslateFlipContext.this.projectLocation(((FeatureFilter.OverlapsLocation)ff).getLocation()));
                }
                if (ff instanceof FeatureFilter.ContainedByLocation) {
                    return new FeatureFilter.ContainedByLocation(TranslateFlipContext.this.projectLocation(((FeatureFilter.ContainedByLocation)ff).getLocation()));
                }
                if (ff instanceof FeatureFilter.StrandFilter) {
                    return new FeatureFilter.StrandFilter(TranslateFlipContext.this.projectStrand(((FeatureFilter.StrandFilter)ff).getStrand()));
                }
                return ff;
            }
        };
    }

    protected FilterUtils.FilterTransformer getReverter() {
        final FilterUtils.FilterTransformer delegate = super.getReverter();
        return new FilterUtils.FilterTransformer(){

            public FeatureFilter transform(FeatureFilter ff) {
                if ((ff = delegate.transform(ff)) instanceof FeatureFilter.OverlapsLocation) {
                    return new FeatureFilter.OverlapsLocation(TranslateFlipContext.this.revertLocation(((FeatureFilter.OverlapsLocation)ff).getLocation()));
                }
                if (ff instanceof FeatureFilter.ContainedByLocation) {
                    return new FeatureFilter.ContainedByLocation(TranslateFlipContext.this.revertLocation(((FeatureFilter.ContainedByLocation)ff).getLocation()));
                }
                if (ff instanceof FeatureFilter.StrandFilter) {
                    return new FeatureFilter.StrandFilter(TranslateFlipContext.this.revertStrand(((FeatureFilter.StrandFilter)ff).getStrand()));
                }
                return ff;
            }
        };
    }
}

