/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.jce.provider.X509CRLParser;
import org.bouncycastle.jce.provider.X509CertParser;
import org.bouncycastle.util.StreamParsingException;

public class PdfPKCS7 {
    private byte[] sigAttr;
    private byte[] digestAttr;
    private int version;
    private int signerversion;
    private Set digestalgos;
    private Collection certs;
    private Collection crls;
    private X509Certificate signCert;
    private byte[] digest;
    private MessageDigest messageDigest;
    private String digestAlgorithm;
    private String digestEncryptionAlgorithm;
    private Signature sig;
    private transient PrivateKey privKey;
    private byte[] RSAdata;
    private boolean verified;
    private boolean verifyResult;
    private byte[] externalDigest;
    private byte[] externalRSAdata;
    private static final String ID_PKCS7_DATA = "1.2.840.113549.1.7.1";
    private static final String ID_PKCS7_SIGNED_DATA = "1.2.840.113549.1.7.2";
    private static final String ID_MD5 = "1.2.840.113549.2.5";
    private static final String ID_MD2 = "1.2.840.113549.2.2";
    private static final String ID_SHA1 = "1.3.14.3.2.26";
    private static final String ID_RSA = "1.2.840.113549.1.1.1";
    private static final String ID_DSA = "1.2.840.10040.4.1";
    private static final String ID_CONTENT_TYPE = "1.2.840.113549.1.9.3";
    private static final String ID_MESSAGE_DIGEST = "1.2.840.113549.1.9.4";
    private static final String ID_SIGNING_TIME = "1.2.840.113549.1.9.5";
    private static final String ID_MD2RSA = "1.2.840.113549.1.1.2";
    private static final String ID_MD5RSA = "1.2.840.113549.1.1.4";
    private static final String ID_SHA1RSA = "1.2.840.113549.1.1.5";
    private String reason;
    private String location;
    private Calendar signDate;
    private String signName;

    public PdfPKCS7(byte[] byArray, byte[] byArray2, String string) throws SecurityException, InvalidKeyException, CertificateException, NoSuchProviderException, NoSuchAlgorithmException, IOException {
        CertificateFactory certificateFactory = string == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", string);
        if (string == null) {
            this.certs = certificateFactory.generateCertificates(new ByteArrayInputStream(byArray2));
        }
        this.signCert = (X509Certificate)this.certs.iterator().next();
        this.crls = new ArrayList();
        ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(byArray));
        this.digest = ((DEROctetString)aSN1InputStream.readObject()).getOctets();
        this.sig = string == null ? Signature.getInstance("SHA1withRSA") : Signature.getInstance("SHA1withRSA", string);
        this.sig.initVerify(this.signCert.getPublicKey());
    }

    public PdfPKCS7(byte[] byArray, String string) throws SecurityException, CRLException, InvalidKeyException, CertificateException, NoSuchProviderException, NoSuchAlgorithmException, StreamParsingException {
        X509Certificate x509Certificate;
        DERObjectIdentifier dERObjectIdentifier;
        ASN1Sequence aSN1Sequence;
        DERObject dERObject;
        ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(byArray));
        try {
            dERObject = aSN1InputStream.readObject();
        }
        catch (IOException iOException) {
            throw new SecurityException("can't decode PKCS7SignedData object");
        }
        if (!(dERObject instanceof ASN1Sequence)) {
            throw new SecurityException("Not a valid PKCS#7 object - not a sequence");
        }
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)dERObject;
        DERObjectIdentifier dERObjectIdentifier2 = (DERObjectIdentifier)aSN1Sequence2.getObjectAt(0);
        if (!dERObjectIdentifier2.getId().equals(ID_PKCS7_SIGNED_DATA)) {
            throw new SecurityException("Not a valid PKCS#7 object - not signed data");
        }
        ASN1Sequence aSN1Sequence3 = (ASN1Sequence)((DERTaggedObject)aSN1Sequence2.getObjectAt(1)).getObject();
        this.version = ((DERInteger)aSN1Sequence3.getObjectAt(0)).getValue().intValue();
        this.digestalgos = new HashSet();
        Enumeration enumeration = ((ASN1Set)aSN1Sequence3.getObjectAt(1)).getObjects();
        while (enumeration.hasMoreElements()) {
            aSN1Sequence = (ASN1Sequence)enumeration.nextElement();
            dERObjectIdentifier = (DERObjectIdentifier)aSN1Sequence.getObjectAt(0);
            this.digestalgos.add(dERObjectIdentifier.getId());
        }
        aSN1Sequence = new X509CertParser();
        aSN1Sequence.engineInit((InputStream)new ByteArrayInputStream(byArray));
        this.certs = aSN1Sequence.engineReadAll();
        dERObjectIdentifier = new X509CRLParser();
        dERObjectIdentifier.engineInit((InputStream)new ByteArrayInputStream(byArray));
        this.crls = dERObjectIdentifier.engineReadAll();
        ASN1Sequence aSN1Sequence4 = (ASN1Sequence)aSN1Sequence3.getObjectAt(2);
        if (aSN1Sequence4.size() > 1) {
            DEROctetString dEROctetString = (DEROctetString)((DERTaggedObject)aSN1Sequence4.getObjectAt(1)).getObject();
            this.RSAdata = dEROctetString.getOctets();
        }
        int n = 3;
        while (aSN1Sequence3.getObjectAt(n) instanceof DERTaggedObject) {
            ++n;
        }
        ASN1Set aSN1Set = (ASN1Set)aSN1Sequence3.getObjectAt(n);
        if (aSN1Set.size() != 1) {
            throw new SecurityException("This PKCS#7 object has multiple SignerInfos - only one is supported at this time");
        }
        ASN1Sequence aSN1Sequence5 = (ASN1Sequence)aSN1Set.getObjectAt(0);
        this.signerversion = ((DERInteger)aSN1Sequence5.getObjectAt(0)).getValue().intValue();
        ASN1Sequence aSN1Sequence6 = (ASN1Sequence)aSN1Sequence5.getObjectAt(1);
        BigInteger bigInteger = ((DERInteger)aSN1Sequence6.getObjectAt(1)).getValue();
        ASN1TaggedObject aSN1TaggedObject = this.certs.iterator();
        while (aSN1TaggedObject.hasNext()) {
            x509Certificate = (X509Certificate)aSN1TaggedObject.next();
            if (!bigInteger.equals(x509Certificate.getSerialNumber())) continue;
            this.signCert = x509Certificate;
            break;
        }
        if (this.signCert == null) {
            throw new SecurityException("Can't find signing certificate with serial " + bigInteger.toString(16));
        }
        this.digestAlgorithm = ((DERObjectIdentifier)((ASN1Sequence)aSN1Sequence5.getObjectAt(2)).getObjectAt(0)).getId();
        n = 3;
        if (aSN1Sequence5.getObjectAt(n) instanceof ASN1TaggedObject) {
            aSN1TaggedObject = (ASN1TaggedObject)aSN1Sequence5.getObjectAt(n);
            x509Certificate = (ASN1Sequence)aSN1TaggedObject.getObject();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
            try {
                ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                for (int i = 0; i < x509Certificate.size(); ++i) {
                    aSN1EncodableVector.add(x509Certificate.getObjectAt(i));
                }
                aSN1OutputStream.writeObject((Object)new DERSet((DEREncodableVector)aSN1EncodableVector));
                aSN1OutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.sigAttr = byteArrayOutputStream.toByteArray();
            for (int i = 0; i < x509Certificate.size(); ++i) {
                ASN1Sequence aSN1Sequence7 = (ASN1Sequence)x509Certificate.getObjectAt(i);
                if (!((DERObjectIdentifier)aSN1Sequence7.getObjectAt(0)).getId().equals(ID_MESSAGE_DIGEST)) continue;
                ASN1Set aSN1Set2 = (ASN1Set)aSN1Sequence7.getObjectAt(1);
                this.digestAttr = ((DEROctetString)aSN1Set2.getObjectAt(0)).getOctets();
                break;
            }
            if (this.digestAttr == null) {
                throw new SecurityException("Authenticated attribute is missing the digest.");
            }
        }
        int n2 = ++n;
        this.digestEncryptionAlgorithm = ((DERObjectIdentifier)((ASN1Sequence)aSN1Sequence5.getObjectAt(n2)).getObjectAt(0)).getId();
        this.digest = ((DEROctetString)aSN1Sequence5.getObjectAt(++n)).getOctets();
        if (this.RSAdata != null || this.digestAttr != null) {
            this.messageDigest = string == null || string.startsWith("SunPKCS11") ? MessageDigest.getInstance(this.getHashAlgorithm()) : MessageDigest.getInstance(this.getHashAlgorithm(), string);
        }
        this.sig = string == null ? Signature.getInstance(this.getDigestAlgorithm()) : Signature.getInstance(this.getDigestAlgorithm(), string);
        this.sig.initVerify(this.signCert.getPublicKey());
    }

    public PdfPKCS7(PrivateKey privateKey, Certificate[] certificateArray, CRL[] cRLArray, String string, String string2, boolean bl) throws SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        int n;
        this.privKey = privateKey;
        if (string.equals("MD5")) {
            this.digestAlgorithm = ID_MD5;
        } else if (string.equals("MD2")) {
            this.digestAlgorithm = ID_MD2;
        } else if (string.equals("SHA")) {
            this.digestAlgorithm = ID_SHA1;
        } else if (string.equals("SHA1")) {
            this.digestAlgorithm = ID_SHA1;
        } else {
            throw new NoSuchAlgorithmException("Unknown Hash Algorithm " + string);
        }
        this.signerversion = 1;
        this.version = 1;
        this.certs = new ArrayList();
        this.crls = new ArrayList();
        this.digestalgos = new HashSet();
        this.digestalgos.add(this.digestAlgorithm);
        this.signCert = (X509Certificate)certificateArray[0];
        for (n = 0; n < certificateArray.length; ++n) {
            this.certs.add(certificateArray[n]);
        }
        if (cRLArray != null) {
            for (n = 0; n < cRLArray.length; ++n) {
                this.crls.add(cRLArray[n]);
            }
        }
        if (privateKey != null) {
            this.digestEncryptionAlgorithm = privateKey.getAlgorithm();
            if (this.digestEncryptionAlgorithm.equals("RSA")) {
                this.digestEncryptionAlgorithm = ID_RSA;
            } else if (this.digestEncryptionAlgorithm.equals("DSA")) {
                this.digestEncryptionAlgorithm = ID_DSA;
            } else {
                throw new NoSuchAlgorithmException("Unknown Key Algorithm " + this.digestEncryptionAlgorithm);
            }
        }
        if (bl) {
            this.RSAdata = new byte[0];
            this.messageDigest = string2 == null || string2.startsWith("SunPKCS11") ? MessageDigest.getInstance(this.getHashAlgorithm()) : MessageDigest.getInstance(this.getHashAlgorithm(), string2);
        }
        if (privateKey != null) {
            this.sig = string2 == null ? Signature.getInstance(this.getDigestAlgorithm()) : Signature.getInstance(this.getDigestAlgorithm(), string2);
            this.sig.initSign(privateKey);
        }
    }

    public void update(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.RSAdata != null || this.digestAttr != null) {
            this.messageDigest.update(byArray, n, n2);
        } else {
            this.sig.update(byArray, n, n2);
        }
    }

    public boolean verify() throws SignatureException {
        if (this.verified) {
            return this.verifyResult;
        }
        if (this.sigAttr != null) {
            this.sig.update(this.sigAttr);
            if (this.RSAdata != null) {
                byte[] byArray = this.messageDigest.digest();
                this.messageDigest.update(byArray);
            }
            this.verifyResult = Arrays.equals(this.messageDigest.digest(), this.digestAttr) && this.sig.verify(this.digest);
        } else {
            if (this.RSAdata != null) {
                this.sig.update(this.messageDigest.digest());
            }
            this.verifyResult = this.sig.verify(this.digest);
        }
        this.verified = true;
        return this.verifyResult;
    }

    public Certificate[] getCertificates() {
        return this.certs.toArray(new X509Certificate[this.certs.size()]);
    }

    public Collection getCRLs() {
        return this.crls;
    }

    public X509Certificate getSigningCertificate() {
        return this.signCert;
    }

    public int getVersion() {
        return this.version;
    }

    public int getSigningInfoVersion() {
        return this.signerversion;
    }

    public String getDigestAlgorithm() {
        String string = this.digestEncryptionAlgorithm;
        if (this.digestEncryptionAlgorithm.equals(ID_RSA) || this.digestEncryptionAlgorithm.equals(ID_MD5RSA) || this.digestEncryptionAlgorithm.equals(ID_MD2RSA) || this.digestEncryptionAlgorithm.equals(ID_SHA1RSA)) {
            string = "RSA";
        } else if (this.digestEncryptionAlgorithm.equals(ID_DSA)) {
            string = "DSA";
        }
        return this.getHashAlgorithm() + "with" + string;
    }

    public String getHashAlgorithm() {
        String string = this.digestAlgorithm;
        if (this.digestAlgorithm.equals(ID_MD5) || this.digestAlgorithm.equals(ID_MD5RSA)) {
            string = "MD5";
        } else if (this.digestAlgorithm.equals(ID_MD2) || this.digestAlgorithm.equals(ID_MD2RSA)) {
            string = "MD2";
        } else if (this.digestAlgorithm.equals(ID_SHA1) || this.digestAlgorithm.equals(ID_SHA1RSA)) {
            string = "SHA1";
        }
        return string;
    }

    public static KeyStore loadCacertsKeyStore() {
        return PdfPKCS7.loadCacertsKeyStore(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeyStore loadCacertsKeyStore(String string) {
        KeyStore keyStore2;
        File file = new File(System.getProperty("java.home"), "lib");
        file = new File(file, "security");
        file = new File(file, "cacerts");
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
                KeyStore keyStore = string == null ? KeyStore.getInstance("JKS") : KeyStore.getInstance("JKS", string);
                keyStore.load(fileInputStream, null);
                keyStore2 = keyStore;
                Object var6_6 = null;
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (fileInputStream == null) throw throwable;
                fileInputStream.close();
                throw throwable;
            }
            catch (Exception exception2) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {
            // empty catch block
            return keyStore2;
        }
        if (fileInputStream == null) return keyStore2;
        fileInputStream.close();
        return keyStore2;
    }

    public static String verifyCertificate(X509Certificate x509Certificate, Collection collection, Calendar calendar) {
        if (calendar == null) {
            calendar = new GregorianCalendar();
        }
        if (x509Certificate.hasUnsupportedCriticalExtension()) {
            return "Has unsupported critical extension";
        }
        try {
            x509Certificate.checkValidity(calendar.getTime());
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (!((CRL)iterator.next()).isRevoked(x509Certificate)) continue;
                return "Certificate revoked";
            }
        }
        return null;
    }

    /*
     * Loose catch block
     */
    public static Object[] verifyCertificates(Certificate[] certificateArray, KeyStore keyStore, Collection collection, Calendar calendar) {
        if (calendar == null) {
            calendar = new GregorianCalendar();
        }
        for (int i = 0; i < certificateArray.length; ++i) {
            int n;
            Object object;
            X509Certificate x509Certificate = (X509Certificate)certificateArray[i];
            String string = PdfPKCS7.verifyCertificate(x509Certificate, collection, calendar);
            if (string != null) {
                return new Object[]{x509Certificate, string};
            }
            try {
                Enumeration<String> enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    if (!keyStore.isCertificateEntry((String)object)) continue;
                    X509Certificate x509Certificate2 = (X509Certificate)keyStore.getCertificate((String)object);
                    if (PdfPKCS7.verifyCertificate(x509Certificate2, collection, calendar) != null) continue;
                    {
                        catch (Exception exception) {}
                    }
                    try {
                        x509Certificate.verify(x509Certificate2.getPublicKey());
                        return null;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (n = 0; n < certificateArray.length; ++n) {
                if (n == i) continue;
                object = (X509Certificate)certificateArray[n];
                try {
                    x509Certificate.verify(((Certificate)object).getPublicKey());
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (n != certificateArray.length) continue;
            return new Object[]{x509Certificate, "Cannot be verified against the KeyStore or the certificate chain"};
        }
        return new Object[]{null, "Invalid state. Possible circular certificate chain"};
    }

    private static DERObject getIssuer(byte[] byArray) {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(byArray));
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
            return (DERObject)aSN1Sequence.getObjectAt(aSN1Sequence.getObjectAt(0) instanceof DERTaggedObject ? 3 : 2);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    private static DERObject getSubject(byte[] byArray) {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(byArray));
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
            return (DERObject)aSN1Sequence.getObjectAt(aSN1Sequence.getObjectAt(0) instanceof DERTaggedObject ? 5 : 4);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public static X509Name getIssuerFields(X509Certificate x509Certificate) {
        try {
            return new X509Name((ASN1Sequence)PdfPKCS7.getIssuer(x509Certificate.getTBSCertificate()));
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static X509Name getSubjectFields(X509Certificate x509Certificate) {
        try {
            return new X509Name((ASN1Sequence)PdfPKCS7.getSubject(x509Certificate.getTBSCertificate()));
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public byte[] getEncodedPKCS1() {
        try {
            this.digest = this.externalDigest != null ? this.externalDigest : this.sig.sign();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
            aSN1OutputStream.writeObject((Object)new DEROctetString(this.digest));
            aSN1OutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public void setExternalDigest(byte[] byArray, byte[] byArray2, String string) {
        this.externalDigest = byArray;
        this.externalRSAdata = byArray2;
        if (string != null) {
            if (string.equals("RSA")) {
                this.digestEncryptionAlgorithm = ID_RSA;
            } else if (string.equals("DSA")) {
                this.digestEncryptionAlgorithm = ID_DSA;
            } else {
                throw new ExceptionConverter(new NoSuchAlgorithmException("Unknown Key Algorithm " + string));
            }
        }
    }

    public byte[] getEncodedPKCS7() {
        return this.getEncodedPKCS7(null, null);
    }

    public byte[] getEncodedPKCS7(byte[] byArray, Calendar calendar) {
        try {
            Object object;
            ASN1EncodableVector aSN1EncodableVector;
            ASN1EncodableVector aSN1EncodableVector2;
            ASN1EncodableVector aSN1EncodableVector3;
            ASN1EncodableVector aSN1EncodableVector4;
            if (this.externalDigest != null) {
                this.digest = this.externalDigest;
                if (this.RSAdata != null) {
                    this.RSAdata = this.externalRSAdata;
                }
            } else if (this.externalRSAdata != null && this.RSAdata != null) {
                this.RSAdata = this.externalRSAdata;
                this.sig.update(this.RSAdata);
                this.digest = this.sig.sign();
            } else {
                if (this.RSAdata != null) {
                    this.RSAdata = this.messageDigest.digest();
                    this.sig.update(this.RSAdata);
                }
                this.digest = this.sig.sign();
            }
            DERConstructedSet dERConstructedSet = new DERConstructedSet();
            ASN1EncodableVector aSN1EncodableVector5 = this.digestalgos.iterator();
            while (aSN1EncodableVector5.hasNext()) {
                aSN1EncodableVector4 = new ASN1EncodableVector();
                aSN1EncodableVector4.add((DEREncodable)new DERObjectIdentifier((String)aSN1EncodableVector5.next()));
                aSN1EncodableVector4.add((DEREncodable)new DERNull());
                dERConstructedSet.addObject((DEREncodable)new DERSequence((DEREncodableVector)aSN1EncodableVector4));
            }
            aSN1EncodableVector5 = new ASN1EncodableVector();
            aSN1EncodableVector5.add((DEREncodable)new DERObjectIdentifier(ID_PKCS7_DATA));
            if (this.RSAdata != null) {
                aSN1EncodableVector5.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)new DEROctetString(this.RSAdata)));
            }
            aSN1EncodableVector4 = new DERSequence((DEREncodableVector)aSN1EncodableVector5);
            aSN1EncodableVector5 = new ASN1EncodableVector();
            DERSet dERSet = this.certs.iterator();
            while (dERSet.hasNext()) {
                aSN1EncodableVector3 = new ASN1InputStream((InputStream)new ByteArrayInputStream(((X509Certificate)dERSet.next()).getEncoded()));
                aSN1EncodableVector5.add((DEREncodable)aSN1EncodableVector3.readObject());
            }
            dERSet = new DERSet((DEREncodableVector)aSN1EncodableVector5);
            aSN1EncodableVector3 = new ASN1EncodableVector();
            aSN1EncodableVector3.add((DEREncodable)new DERInteger(this.signerversion));
            aSN1EncodableVector5 = new ASN1EncodableVector();
            aSN1EncodableVector5.add((DEREncodable)PdfPKCS7.getIssuer(this.signCert.getTBSCertificate()));
            aSN1EncodableVector5.add((DEREncodable)new DERInteger(this.signCert.getSerialNumber()));
            aSN1EncodableVector3.add((DEREncodable)new DERSequence((DEREncodableVector)aSN1EncodableVector5));
            aSN1EncodableVector5 = new ASN1EncodableVector();
            aSN1EncodableVector5.add((DEREncodable)new DERObjectIdentifier(this.digestAlgorithm));
            aSN1EncodableVector5.add((DEREncodable)new DERNull());
            aSN1EncodableVector3.add((DEREncodable)new DERSequence((DEREncodableVector)aSN1EncodableVector5));
            if (byArray != null && calendar != null) {
                aSN1EncodableVector2 = new ASN1EncodableVector();
                aSN1EncodableVector5 = new ASN1EncodableVector();
                aSN1EncodableVector5.add((DEREncodable)new DERObjectIdentifier(ID_CONTENT_TYPE));
                aSN1EncodableVector5.add((DEREncodable)new DERSet((DEREncodable)new DERObjectIdentifier(ID_PKCS7_DATA)));
                aSN1EncodableVector2.add((DEREncodable)new DERSequence((DEREncodableVector)aSN1EncodableVector5));
                aSN1EncodableVector5 = new ASN1EncodableVector();
                aSN1EncodableVector5.add((DEREncodable)new DERObjectIdentifier(ID_SIGNING_TIME));
                aSN1EncodableVector5.add((DEREncodable)new DERSet((DEREncodable)new DERUTCTime(calendar.getTime())));
                aSN1EncodableVector2.add((DEREncodable)new DERSequence((DEREncodableVector)aSN1EncodableVector5));
                aSN1EncodableVector5 = new ASN1EncodableVector();
                aSN1EncodableVector5.add((DEREncodable)new DERObjectIdentifier(ID_MESSAGE_DIGEST));
                aSN1EncodableVector5.add((DEREncodable)new DERSet((DEREncodable)new DEROctetString(byArray)));
                aSN1EncodableVector2.add((DEREncodable)new DERSequence((DEREncodableVector)aSN1EncodableVector5));
                aSN1EncodableVector3.add((DEREncodable)new DERTaggedObject(false, 0, (DEREncodable)new DERSet((DEREncodableVector)aSN1EncodableVector2)));
            }
            aSN1EncodableVector5 = new ASN1EncodableVector();
            aSN1EncodableVector5.add((DEREncodable)new DERObjectIdentifier(this.digestEncryptionAlgorithm));
            aSN1EncodableVector5.add((DEREncodable)new DERNull());
            aSN1EncodableVector3.add((DEREncodable)new DERSequence((DEREncodableVector)aSN1EncodableVector5));
            aSN1EncodableVector3.add((DEREncodable)new DEROctetString(this.digest));
            aSN1EncodableVector2 = new ASN1EncodableVector();
            aSN1EncodableVector2.add((DEREncodable)new DERInteger(this.version));
            aSN1EncodableVector2.add((DEREncodable)dERConstructedSet);
            aSN1EncodableVector2.add((DEREncodable)aSN1EncodableVector4);
            aSN1EncodableVector2.add((DEREncodable)new DERTaggedObject(false, 0, (DEREncodable)dERSet));
            if (!this.crls.isEmpty()) {
                aSN1EncodableVector5 = new ASN1EncodableVector();
                aSN1EncodableVector = this.crls.iterator();
                while (aSN1EncodableVector.hasNext()) {
                    object = new ASN1InputStream((InputStream)new ByteArrayInputStream(((X509CRL)aSN1EncodableVector.next()).getEncoded()));
                    aSN1EncodableVector5.add((DEREncodable)object.readObject());
                }
                aSN1EncodableVector = new DERSet((DEREncodableVector)aSN1EncodableVector5);
                aSN1EncodableVector2.add((DEREncodable)new DERTaggedObject(false, 1, (DEREncodable)aSN1EncodableVector));
            }
            aSN1EncodableVector2.add((DEREncodable)new DERSet((DEREncodable)new DERSequence((DEREncodableVector)aSN1EncodableVector3)));
            aSN1EncodableVector = new ASN1EncodableVector();
            aSN1EncodableVector.add((DEREncodable)new DERObjectIdentifier(ID_PKCS7_SIGNED_DATA));
            aSN1EncodableVector.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)new DERSequence((DEREncodableVector)aSN1EncodableVector2)));
            object = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)object);
            aSN1OutputStream.writeObject((Object)new DERSequence((DEREncodableVector)aSN1EncodableVector));
            aSN1OutputStream.close();
            return ((ByteArrayOutputStream)object).toByteArray();
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public byte[] getAuthenticatedAttributeBytes(byte[] byArray, Calendar calendar) {
        try {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
            aSN1EncodableVector2.add((DEREncodable)new DERObjectIdentifier(ID_CONTENT_TYPE));
            aSN1EncodableVector2.add((DEREncodable)new DERSet((DEREncodable)new DERObjectIdentifier(ID_PKCS7_DATA)));
            aSN1EncodableVector.add((DEREncodable)new DERSequence((DEREncodableVector)aSN1EncodableVector2));
            aSN1EncodableVector2 = new ASN1EncodableVector();
            aSN1EncodableVector2.add((DEREncodable)new DERObjectIdentifier(ID_SIGNING_TIME));
            aSN1EncodableVector2.add((DEREncodable)new DERSet((DEREncodable)new DERUTCTime(calendar.getTime())));
            aSN1EncodableVector.add((DEREncodable)new DERSequence((DEREncodableVector)aSN1EncodableVector2));
            aSN1EncodableVector2 = new ASN1EncodableVector();
            aSN1EncodableVector2.add((DEREncodable)new DERObjectIdentifier(ID_MESSAGE_DIGEST));
            aSN1EncodableVector2.add((DEREncodable)new DERSet((DEREncodable)new DEROctetString(byArray)));
            aSN1EncodableVector.add((DEREncodable)new DERSequence((DEREncodableVector)aSN1EncodableVector2));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
            aSN1OutputStream.writeObject((Object)new DERSet((DEREncodableVector)aSN1EncodableVector));
            aSN1OutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String string) {
        this.reason = string;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public Calendar getSignDate() {
        return this.signDate;
    }

    public void setSignDate(Calendar calendar) {
        this.signDate = calendar;
    }

    public String getSignName() {
        return this.signName;
    }

    public void setSignName(String string) {
        this.signName = string;
    }

    public static class X509NameTokenizer {
        private String oid;
        private int index;
        private StringBuffer buf = new StringBuffer();

        public X509NameTokenizer(String string) {
            this.oid = string;
            this.index = -1;
        }

        public boolean hasMoreTokens() {
            return this.index != this.oid.length();
        }

        public String nextToken() {
            int n;
            if (this.index == this.oid.length()) {
                return null;
            }
            boolean bl = false;
            boolean bl2 = false;
            this.buf.setLength(0);
            for (n = this.index + 1; n != this.oid.length(); ++n) {
                char c = this.oid.charAt(n);
                if (c == '\"') {
                    if (!bl2) {
                        bl = !bl;
                    } else {
                        this.buf.append(c);
                    }
                    bl2 = false;
                    continue;
                }
                if (bl2 || bl) {
                    this.buf.append(c);
                    bl2 = false;
                    continue;
                }
                if (c == '\\') {
                    bl2 = true;
                    continue;
                }
                if (c == ',') break;
                this.buf.append(c);
            }
            this.index = n;
            return this.buf.toString().trim();
        }
    }

    public static class X509Name {
        public static final DERObjectIdentifier C = new DERObjectIdentifier("2.5.4.6");
        public static final DERObjectIdentifier O = new DERObjectIdentifier("2.5.4.10");
        public static final DERObjectIdentifier OU = new DERObjectIdentifier("2.5.4.11");
        public static final DERObjectIdentifier T = new DERObjectIdentifier("2.5.4.12");
        public static final DERObjectIdentifier CN = new DERObjectIdentifier("2.5.4.3");
        public static final DERObjectIdentifier SN = new DERObjectIdentifier("2.5.4.5");
        public static final DERObjectIdentifier L = new DERObjectIdentifier("2.5.4.7");
        public static final DERObjectIdentifier ST = new DERObjectIdentifier("2.5.4.8");
        public static final DERObjectIdentifier SURNAME = new DERObjectIdentifier("2.5.4.4");
        public static final DERObjectIdentifier GIVENNAME = new DERObjectIdentifier("2.5.4.42");
        public static final DERObjectIdentifier INITIALS = new DERObjectIdentifier("2.5.4.43");
        public static final DERObjectIdentifier GENERATION = new DERObjectIdentifier("2.5.4.44");
        public static final DERObjectIdentifier UNIQUE_IDENTIFIER = new DERObjectIdentifier("2.5.4.45");
        public static final DERObjectIdentifier EmailAddress;
        public static final DERObjectIdentifier E;
        public static final DERObjectIdentifier DC;
        public static final DERObjectIdentifier UID;
        public static HashMap DefaultSymbols;
        public HashMap values = new HashMap();

        public X509Name(ASN1Sequence aSN1Sequence) {
            Enumeration enumeration = aSN1Sequence.getObjects();
            while (enumeration.hasMoreElements()) {
                ASN1Set aSN1Set = (ASN1Set)enumeration.nextElement();
                for (int i = 0; i < aSN1Set.size(); ++i) {
                    ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Set.getObjectAt(i);
                    String string = (String)DefaultSymbols.get(aSN1Sequence2.getObjectAt(0));
                    if (string == null) continue;
                    ArrayList<String> arrayList = (ArrayList<String>)this.values.get(string);
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                        this.values.put(string, arrayList);
                    }
                    arrayList.add(((DERString)aSN1Sequence2.getObjectAt(1)).getString());
                }
            }
        }

        public X509Name(String string) {
            X509NameTokenizer x509NameTokenizer = new X509NameTokenizer(string);
            while (x509NameTokenizer.hasMoreTokens()) {
                String string2 = x509NameTokenizer.nextToken();
                int n = string2.indexOf(61);
                if (n == -1) {
                    throw new IllegalArgumentException("badly formated directory string");
                }
                String string3 = string2.substring(0, n).toUpperCase();
                String string4 = string2.substring(n + 1);
                ArrayList<String> arrayList = (ArrayList<String>)this.values.get(string3);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    this.values.put(string3, arrayList);
                }
                arrayList.add(string4);
            }
        }

        public String getField(String string) {
            ArrayList arrayList = (ArrayList)this.values.get(string);
            return arrayList == null ? null : (String)arrayList.get(0);
        }

        public ArrayList getFieldArray(String string) {
            ArrayList arrayList = (ArrayList)this.values.get(string);
            return arrayList == null ? null : arrayList;
        }

        public HashMap getFields() {
            return this.values;
        }

        public String toString() {
            return this.values.toString();
        }

        static {
            E = EmailAddress = new DERObjectIdentifier("1.2.840.113549.1.9.1");
            DC = new DERObjectIdentifier("0.9.2342.19200300.100.1.25");
            UID = new DERObjectIdentifier("0.9.2342.19200300.100.1.1");
            DefaultSymbols = new HashMap();
            DefaultSymbols.put(C, "C");
            DefaultSymbols.put(O, "O");
            DefaultSymbols.put(T, "T");
            DefaultSymbols.put(OU, "OU");
            DefaultSymbols.put(CN, "CN");
            DefaultSymbols.put(L, "L");
            DefaultSymbols.put(ST, "ST");
            DefaultSymbols.put(SN, "SN");
            DefaultSymbols.put(EmailAddress, "E");
            DefaultSymbols.put(DC, "DC");
            DefaultSymbols.put(UID, "UID");
            DefaultSymbols.put(SURNAME, "SURNAME");
            DefaultSymbols.put(GIVENNAME, "GIVENNAME");
            DefaultSymbols.put(INITIALS, "INITIALS");
            DefaultSymbols.put(GENERATION, "GENERATION");
        }
    }
}

