/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.html.Markup;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class FontFactoryImp {
    private Properties trueTypeFonts = new Properties();
    private static String[] TTFamilyOrder = new String[]{"3", "1", "1033", "3", "0", "1033", "1", "0", "0", "0", "3", "0"};
    private Hashtable fontFamilies = new Hashtable();
    public String defaultEncoding = "Cp1252";
    public boolean defaultEmbedding = false;

    public FontFactoryImp() {
        this.trueTypeFonts.setProperty("Courier".toLowerCase(), "Courier");
        this.trueTypeFonts.setProperty("Courier-Bold".toLowerCase(), "Courier-Bold");
        this.trueTypeFonts.setProperty("Courier-Oblique".toLowerCase(), "Courier-Oblique");
        this.trueTypeFonts.setProperty("Courier-BoldOblique".toLowerCase(), "Courier-BoldOblique");
        this.trueTypeFonts.setProperty("Helvetica".toLowerCase(), "Helvetica");
        this.trueTypeFonts.setProperty("Helvetica-Bold".toLowerCase(), "Helvetica-Bold");
        this.trueTypeFonts.setProperty("Helvetica-Oblique".toLowerCase(), "Helvetica-Oblique");
        this.trueTypeFonts.setProperty("Helvetica-BoldOblique".toLowerCase(), "Helvetica-BoldOblique");
        this.trueTypeFonts.setProperty("Symbol".toLowerCase(), "Symbol");
        this.trueTypeFonts.setProperty("Times-Roman".toLowerCase(), "Times-Roman");
        this.trueTypeFonts.setProperty("Times-Bold".toLowerCase(), "Times-Bold");
        this.trueTypeFonts.setProperty("Times-Italic".toLowerCase(), "Times-Italic");
        this.trueTypeFonts.setProperty("Times-BoldItalic".toLowerCase(), "Times-BoldItalic");
        this.trueTypeFonts.setProperty("ZapfDingbats".toLowerCase(), "ZapfDingbats");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Courier");
        arrayList.add("Courier-Bold");
        arrayList.add("Courier-Oblique");
        arrayList.add("Courier-BoldOblique");
        this.fontFamilies.put("Courier".toLowerCase(), arrayList);
        arrayList = new ArrayList();
        arrayList.add("Helvetica");
        arrayList.add("Helvetica-Bold");
        arrayList.add("Helvetica-Oblique");
        arrayList.add("Helvetica-BoldOblique");
        this.fontFamilies.put("Helvetica".toLowerCase(), arrayList);
        arrayList = new ArrayList();
        arrayList.add("Symbol");
        this.fontFamilies.put("Symbol".toLowerCase(), arrayList);
        arrayList = new ArrayList();
        arrayList.add("Times-Roman");
        arrayList.add("Times-Bold");
        arrayList.add("Times-Italic");
        arrayList.add("Times-BoldItalic");
        this.fontFamilies.put("Times".toLowerCase(), arrayList);
        this.fontFamilies.put("Times-Roman".toLowerCase(), arrayList);
        arrayList = new ArrayList();
        arrayList.add("ZapfDingbats");
        this.fontFamilies.put("ZapfDingbats".toLowerCase(), arrayList);
    }

    public Font getFont(String string, String string2, boolean bl, float f, int n, Color color) {
        return this.getFont(string, string2, bl, f, n, color, true);
    }

    public Font getFont(String string, String string2, boolean bl, float f, int n, Color color, boolean bl2) {
        if (string == null) {
            return new Font(-1, f, n, color);
        }
        String string3 = string.toLowerCase();
        ArrayList arrayList = (ArrayList)this.fontFamilies.get(string3);
        if (arrayList != null) {
            int n2 = n == -1 ? 0 : n;
            int n3 = 0;
            boolean bl3 = false;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                String string5 = string4.toLowerCase();
                n3 = 0;
                if (string5.toLowerCase().indexOf("bold") != -1) {
                    n3 |= 1;
                }
                if (string5.toLowerCase().indexOf("italic") != -1 || string5.toLowerCase().indexOf("oblique") != -1) {
                    n3 |= 2;
                }
                if ((n2 & 3) != n3) continue;
                string = string4;
                bl3 = true;
                break;
            }
            if (n != -1 && bl3) {
                n &= ~n3;
            }
        }
        BaseFont baseFont = null;
        try {
            try {
                baseFont = BaseFont.createFont(string, string2, bl, bl2, null, null);
            }
            catch (DocumentException documentException) {
                string = this.trueTypeFonts.getProperty(string.toLowerCase());
                if (string == null) {
                    return new Font(-1, f, n, color);
                }
                baseFont = BaseFont.createFont(string, string2, bl, bl2, null, null);
            }
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
        catch (IOException iOException) {
            return new Font(-1, f, n, color);
        }
        catch (NullPointerException nullPointerException) {
            return new Font(-1, f, n, color);
        }
        return new Font(baseFont, f, n, color);
    }

    public Font getFont(Properties properties) {
        Object object;
        Object object2;
        Object object3;
        String string = null;
        String string2 = this.defaultEncoding;
        boolean bl = this.defaultEmbedding;
        float f = -1.0f;
        int n = 0;
        Color color = null;
        String string3 = (String)properties.remove("style");
        if (string3 != null && string3.length() > 0) {
            object3 = Markup.parseAttributes(string3);
            if (((Properties)object3).size() == 0) {
                properties.put("style", string3);
            } else {
                string = (String)((Properties)object3).remove("font-family");
                if (string != null) {
                    while (string.indexOf(44) != -1) {
                        object2 = string.substring(0, string.indexOf(44));
                        if (this.isRegistered((String)object2)) {
                            string = object2;
                            continue;
                        }
                        string = string.substring(string.indexOf(44) + 1);
                    }
                }
                if ((string3 = (String)((Properties)object3).remove("font-size")) != null) {
                    f = Markup.parseLength(string3);
                }
                if ((string3 = (String)((Properties)object3).remove("font-weight")) != null) {
                    n |= Font.getStyleValue(string3);
                }
                if ((string3 = (String)((Properties)object3).remove("font-style")) != null) {
                    n |= Font.getStyleValue(string3);
                }
                if ((string3 = (String)((Properties)object3).remove("color")) != null) {
                    color = Markup.decodeColor(string3);
                }
                properties.putAll((Map<?, ?>)object3);
                object2 = ((Properties)object3).keys();
                while (object2.hasMoreElements()) {
                    object = object2.nextElement();
                    properties.put(object, ((Properties)object3).get(object));
                }
            }
        }
        if ((string3 = (String)properties.remove("encoding")) != null) {
            string2 = string3;
        }
        if ("true".equals(properties.remove("embedded"))) {
            bl = true;
        }
        if ((string3 = (String)properties.remove("font")) != null) {
            string = string3;
        }
        if ((string3 = (String)properties.remove("size")) != null) {
            f = Float.parseFloat(string3 + "f");
        }
        if ((string3 = (String)properties.remove("style")) != null) {
            n |= Font.getStyleValue(string3);
        }
        if ((string3 = (String)properties.remove("fontstyle")) != null) {
            n |= Font.getStyleValue(string3);
        }
        object3 = (String)properties.remove("red");
        object2 = (String)properties.remove("green");
        object = (String)properties.remove("blue");
        if (object3 != null || object2 != null || object != null) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            if (object3 != null) {
                n2 = Integer.parseInt((String)object3);
            }
            if (object2 != null) {
                n3 = Integer.parseInt((String)object2);
            }
            if (object != null) {
                n4 = Integer.parseInt(object);
            }
            color = new Color(n2, n3, n4);
        } else {
            string3 = (String)properties.remove("color");
            if (string3 != null) {
                color = Markup.decodeColor(string3);
            }
        }
        if (string == null) {
            return this.getFont(null, string2, bl, f, n, color);
        }
        return this.getFont(string, string2, bl, f, n, color);
    }

    public Font getFont(String string, String string2, boolean bl, float f, int n) {
        return this.getFont(string, string2, bl, f, n, null);
    }

    public Font getFont(String string, String string2, boolean bl, float f) {
        return this.getFont(string, string2, bl, f, -1, null);
    }

    public Font getFont(String string, String string2, boolean bl) {
        return this.getFont(string, string2, bl, -1.0f, -1, null);
    }

    public Font getFont(String string, String string2, float f, int n, Color color) {
        return this.getFont(string, string2, this.defaultEmbedding, f, n, color);
    }

    public Font getFont(String string, String string2, float f, int n) {
        return this.getFont(string, string2, this.defaultEmbedding, f, n, null);
    }

    public Font getFont(String string, String string2, float f) {
        return this.getFont(string, string2, this.defaultEmbedding, f, -1, null);
    }

    public Font getFont(String string, String string2) {
        return this.getFont(string, string2, this.defaultEmbedding, -1.0f, -1, null);
    }

    public Font getFont(String string, float f, int n, Color color) {
        return this.getFont(string, this.defaultEncoding, this.defaultEmbedding, f, n, color);
    }

    public Font getFont(String string, float f, int n) {
        return this.getFont(string, this.defaultEncoding, this.defaultEmbedding, f, n, null);
    }

    public Font getFont(String string, float f) {
        return this.getFont(string, this.defaultEncoding, this.defaultEmbedding, f, -1, null);
    }

    public Font getFont(String string) {
        return this.getFont(string, this.defaultEncoding, this.defaultEmbedding, -1.0f, -1, null);
    }

    public void registerFamily(String string, String string2, String string3) {
        ArrayList<String> arrayList;
        if (string3 != null) {
            this.trueTypeFonts.setProperty(string2, string3);
        }
        if ((arrayList = (ArrayList<String>)this.fontFamilies.get(string)) == null) {
            arrayList = new ArrayList<String>();
            arrayList.add(string2);
            this.fontFamilies.put(string, arrayList);
        } else {
            int n = string2.length();
            boolean bl = false;
            for (int i = 0; i < arrayList.size(); ++i) {
                if (((String)arrayList.get(i)).length() < n) continue;
                arrayList.add(i, string2);
                bl = true;
                break;
            }
            if (!bl) {
                arrayList.add(string2);
            }
        }
    }

    public void register(String string) {
        this.register(string, null);
    }

    public void register(String string, String string2) {
        try {
            if (string.toLowerCase().endsWith(".ttf") || string.toLowerCase().endsWith(".otf") || string.toLowerCase().indexOf(".ttc,") > 0) {
                int n;
                Object[] objectArray = BaseFont.getAllFontNames(string, "Cp1252", null);
                this.trueTypeFonts.setProperty(((String)objectArray[0]).toLowerCase(), string);
                if (string2 != null) {
                    this.trueTypeFonts.setProperty(string2.toLowerCase(), string);
                }
                String[][] stringArray = (String[][])objectArray[2];
                for (int i = 0; i < stringArray.length; ++i) {
                    this.trueTypeFonts.setProperty(stringArray[i][3].toLowerCase(), string);
                }
                String string3 = null;
                String string4 = null;
                stringArray = (String[][])objectArray[1];
                block4: for (int i = 0; i < TTFamilyOrder.length; i += 3) {
                    for (n = 0; n < stringArray.length; ++n) {
                        if (!TTFamilyOrder[i].equals(stringArray[n][0]) || !TTFamilyOrder[i + 1].equals(stringArray[n][1]) || !TTFamilyOrder[i + 2].equals(stringArray[n][2])) continue;
                        string4 = stringArray[n][3].toLowerCase();
                        i = TTFamilyOrder.length;
                        continue block4;
                    }
                }
                if (string4 != null) {
                    String string5 = "";
                    stringArray = (String[][])objectArray[2];
                    block6: for (n = 0; n < stringArray.length; ++n) {
                        for (int i = 0; i < TTFamilyOrder.length; i += 3) {
                            if (!TTFamilyOrder[i].equals(stringArray[n][0]) || !TTFamilyOrder[i + 1].equals(stringArray[n][1]) || !TTFamilyOrder[i + 2].equals(stringArray[n][2]) || (string3 = stringArray[n][3]).equals(string5)) continue;
                            string5 = string3;
                            this.registerFamily(string4, string3, null);
                            continue block6;
                        }
                    }
                }
            } else if (string.toLowerCase().endsWith(".ttc")) {
                if (string2 != null) {
                    System.err.println("class FontFactory: You can't define an alias for a true type collection.");
                }
                String[] stringArray = BaseFont.enumerateTTCNames(string);
                for (int i = 0; i < stringArray.length; ++i) {
                    this.register(string + "," + i);
                }
            } else if (string.toLowerCase().endsWith(".afm") || string.toLowerCase().endsWith(".pfm")) {
                BaseFont baseFont = BaseFont.createFont(string, "Cp1252", false);
                String string6 = baseFont.getFullFontName()[0][3].toLowerCase();
                String string7 = baseFont.getFamilyFontName()[0][3].toLowerCase();
                String string8 = baseFont.getPostscriptFontName().toLowerCase();
                this.registerFamily(string7, string6, null);
                this.trueTypeFonts.setProperty(string8, string);
                this.trueTypeFonts.setProperty(string6, string);
            }
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public int registerDirectory(String string) {
        int n = 0;
        try {
            File file = new File(string);
            if (!file.exists() || !file.isDirectory()) {
                return 0;
            }
            String[] stringArray = file.list();
            if (stringArray == null) {
                return 0;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    file = new File(string, stringArray[i]);
                    String string2 = file.getPath().toLowerCase();
                    if (!string2.endsWith(".ttf") && !string2.endsWith(".otf") && !string2.endsWith(".afm") && !string2.endsWith(".pfm") && !string2.endsWith(".ttc")) continue;
                    this.register(file.getPath(), null);
                    ++n;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public int registerDirectories() {
        int n = 0;
        n += this.registerDirectory("c:/windows/fonts");
        n += this.registerDirectory("c:/winnt/fonts");
        n += this.registerDirectory("d:/windows/fonts");
        n += this.registerDirectory("d:/winnt/fonts");
        n += this.registerDirectory("/usr/X/lib/X11/fonts/TrueType");
        n += this.registerDirectory("/usr/openwin/lib/X11/fonts/TrueType");
        n += this.registerDirectory("/usr/share/fonts/default/TrueType");
        n += this.registerDirectory("/usr/X11R6/lib/X11/fonts/ttf");
        n += this.registerDirectory("/Library/Fonts");
        return n += this.registerDirectory("/System/Library/Fonts");
    }

    public Set getRegisteredFonts() {
        return Chunk.getKeySet(this.trueTypeFonts);
    }

    public Set getRegisteredFamilies() {
        return Chunk.getKeySet(this.fontFamilies);
    }

    public boolean isRegistered(String string) {
        return this.trueTypeFonts.containsKey(string.toLowerCase());
    }
}

