/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.lola;

import java.io.File;

public class LolaParameterSet {
    private File profileFile = null;
    private File codonBiasFile = null;
    private boolean uniquePeptides;
    private File outputPath = null;
    private int logoStartIndex;
    private int logoHeight;
    private double logoTrimPercentage;
    private String logoImageFormat;
    private String logoColorStyle;

    public LolaParameterSet() {
        this.profileFile = null;
        this.codonBiasFile = null;
        this.uniquePeptides = true;
        this.outputPath = null;
        this.logoStartIndex = 1;
        this.logoHeight = 180;
        this.logoTrimPercentage = 0.1;
        this.logoImageFormat = "PDF";
        this.logoColorStyle = "WebLogo";
    }

    public LolaParameterSet(File profileFile, File biasFile, boolean uniquePeptides, File outputPath, int logoStartIndex, int logoHeight, double logoTrimPercentage, String logoImageFormat, String logoColorStyle) {
        this.profileFile = profileFile;
        this.codonBiasFile = biasFile;
        this.uniquePeptides = uniquePeptides;
        this.outputPath = outputPath;
        this.logoStartIndex = logoStartIndex;
        this.logoHeight = logoHeight;
        this.logoTrimPercentage = logoTrimPercentage;
        this.logoImageFormat = logoImageFormat;
        this.logoColorStyle = logoColorStyle;
    }

    public LolaParameterSet copy() {
        LolaParameterSet newParamSet = new LolaParameterSet(this.getProfileFile(), this.getCodonBiasFile(), this.getUniquePeptides(), this.getOutputPath(), this.getLogoStartIndex(), this.getLogoHeight(), this.getLogoTrimPercentage(), this.getLogoImageFileFormat(), this.getLogoColorStyle());
        return newParamSet;
    }

    public File getProfileFile() {
        return this.profileFile;
    }

    public void setProfileFile(File file) {
        this.profileFile = file;
    }

    public File getCodonBiasFile() {
        return this.codonBiasFile;
    }

    public void setCodonBiasFile(File file) {
        this.codonBiasFile = file;
    }

    public boolean getUniquePeptides() {
        return this.uniquePeptides;
    }

    public void setUniquePeptides(boolean value) {
        this.uniquePeptides = value;
    }

    public File getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(File path) {
        this.outputPath = path;
    }

    public int getLogoStartIndex() {
        return this.logoStartIndex;
    }

    public void setLogoStartIndex(int index) {
        this.logoStartIndex = index;
    }

    public int getLogoHeight() {
        return this.logoHeight;
    }

    public void setLogoHeight(int height) {
        this.logoHeight = height;
    }

    public double getLogoTrimPercentage() {
        return this.logoTrimPercentage;
    }

    public void setLogoTrimPercentage(double percentage) {
        this.logoTrimPercentage = percentage;
    }

    public String getLogoImageFileFormat() {
        return this.logoImageFormat;
    }

    public void setLogoImageFormat(String imageFormat) {
        this.logoImageFormat = imageFormat;
    }

    public String getLogoColorStyle() {
        return this.logoColorStyle;
    }

    public void setLogoColorStyle(String colorStyle) {
        this.logoColorStyle = colorStyle;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        sb.append("Profile File: " + this.profileFile.toString() + lineSep);
        return sb.toString();
    }
}

