/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.LabelAccessory;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JInternalFrame;

public class Split
extends AbstractTool {
    public Split() {
        FileArgument fileArgument = new FileArgument(this, "srcfile", "The file you want to split", false, new PdfFilter());
        fileArgument.setLabel(new LabelAccessory());
        this.arguments.add(fileArgument);
        this.arguments.add(new FileArgument(this, "destfile1", "The file to which the first part of the original PDF has to be written", true, new PdfFilter()));
        this.arguments.add(new FileArgument(this, "destfile2", "The file to which the second part of the original PDF has to be written", true, new PdfFilter()));
        this.arguments.add(new ToolArgument(this, "pagenumber", "The pagenumber where you want to split", String.class.getName()));
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Split", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Split OPENED ===");
    }

    public void execute() {
        try {
            int n;
            PdfImportedPage pdfImportedPage;
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File file = (File)this.getValue("srcfile");
            if (this.getValue("destfile1") == null) {
                throw new InstantiationException("You need to choose a destination file for the first part of the PDF");
            }
            File file2 = (File)this.getValue("destfile1");
            if (this.getValue("destfile2") == null) {
                throw new InstantiationException("You need to choose a destination file for the second part of the PDF");
            }
            File file3 = (File)this.getValue("destfile2");
            int n2 = Integer.parseInt((String)this.getValue("pagenumber"));
            PdfReader pdfReader = new PdfReader(file.getAbsolutePath());
            int n3 = pdfReader.getNumberOfPages();
            System.out.println("There are " + n3 + " pages in the original file.");
            if (n2 < 2 || n2 > n3) {
                throw new DocumentException("You can't split this document at page " + n2 + "; there is no such page.");
            }
            Document document = new Document(pdfReader.getPageSizeWithRotation(1));
            Document document2 = new Document(pdfReader.getPageSizeWithRotation(n2));
            PdfWriter pdfWriter = PdfWriter.getInstance(document, new FileOutputStream(file2));
            PdfWriter pdfWriter2 = PdfWriter.getInstance(document2, new FileOutputStream(file3));
            document.open();
            PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
            document2.open();
            PdfContentByte pdfContentByte2 = pdfWriter2.getDirectContent();
            int n4 = 0;
            while (n4 < n2 - 1) {
                document.setPageSize(pdfReader.getPageSizeWithRotation(++n4));
                document.newPage();
                pdfImportedPage = pdfWriter.getImportedPage(pdfReader, n4);
                n = pdfReader.getPageRotation(n4);
                if (n == 90 || n == 270) {
                    pdfContentByte.addTemplate(pdfImportedPage, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, pdfReader.getPageSizeWithRotation(n4).height());
                    continue;
                }
                pdfContentByte.addTemplate(pdfImportedPage, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            }
            while (n4 < n3) {
                document2.setPageSize(pdfReader.getPageSizeWithRotation(++n4));
                document2.newPage();
                pdfImportedPage = pdfWriter2.getImportedPage(pdfReader, n4);
                n = pdfReader.getPageRotation(n4);
                if (n == 90 || n == 270) {
                    pdfContentByte2.addTemplate(pdfImportedPage, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, pdfReader.getPageSizeWithRotation(n4).height());
                    continue;
                }
                pdfContentByte2.addTemplate(pdfImportedPage, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            }
            document.close();
            document2.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void valueHasChanged(ToolArgument toolArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        Split split = new Split();
        if (stringArray.length < 4) {
            System.err.println(split.getUsage());
        }
        split.setArguments(stringArray);
        split.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile1");
    }

    static {
        Split.addVersion("$Id: Split.java,v 1.10 2006/08/24 10:51:06 blowagie Exp $");
    }
}

