/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.LabelAccessory;
import com.lowagie.tools.arguments.OptionArgument;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class CompressDecompressPageContent
extends AbstractTool {
    public CompressDecompressPageContent() {
        FileArgument fileArgument = new FileArgument(this, "srcfile", "The file you want to compress/decompress", false, new PdfFilter());
        fileArgument.setLabel(new LabelAccessory());
        this.arguments.add(fileArgument);
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the compressed/decompressed PDF has to be written", true, new PdfFilter()));
        OptionArgument optionArgument = new OptionArgument(this, "compress", "compress");
        optionArgument.addOption("Compress page content", "true");
        optionArgument.addOption("Decompress page content", "false");
        this.arguments.add(optionArgument);
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Compress/Decompress", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Compress/Decompress OPENED ===");
    }

    public void valueHasChanged(ToolArgument toolArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        CompressDecompressPageContent compressDecompressPageContent = new CompressDecompressPageContent();
        if (stringArray.length < 2) {
            System.err.println(compressDecompressPageContent.getUsage());
        }
        compressDecompressPageContent.setArguments(stringArray);
        compressDecompressPageContent.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            boolean bl = "true".equals(this.getValue("compress"));
            PdfReader pdfReader = new PdfReader(((File)this.getValue("srcfile")).getAbsolutePath());
            PdfStamper pdfStamper = new PdfStamper(pdfReader, new FileOutputStream(this.getDestPathPDF()));
            ArrayList arrayList = this.arguments;
            synchronized (arrayList) {
                Document.compress = bl;
                int n = pdfReader.getNumberOfPages() + 1;
                for (int i = 1; i < n; ++i) {
                    pdfReader.setPageContent(i, pdfReader.getPageContent(i));
                }
                pdfStamper.close();
                Document.compress = true;
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.internalFrame, exception.getMessage(), exception.getClass().getName(), 0);
            System.err.println(exception.getMessage());
        }
    }

    static {
        CompressDecompressPageContent.addVersion("$Id: CompressDecompressPageContent.java,v 1.1 2007/03/16 12:15:15 blowagie Exp $");
    }
}

