/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.dialogs.GridBagGroup;
import cytoscape.dialogs.MiscGB;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.calculators.CalculatorFactory;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.ui.ValueDisplayer;
import cytoscape.visual.ui.VizMapTab;
import cytoscape.visual.ui.VizMapUI;
import cytoscape.visual.ui.VizUIUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VizMapAttrTab
extends VizMapTab {
    private CalculatorCatalog catalog;
    private VisualMappingManager VMM;
    private byte type;
    private Calculator currentCalculator;
    private VizMapUI mainUIDialog;
    private ValueDisplayer defaultValueDisplayer;
    private JComboBox calcComboBox;
    private GridBagGroup mapPanelGBG;
    private JPanel calcContainer;
    private JPanel calcPanel;
    protected CalculatorUIListener calcListener = new CalculatorUIListener();

    public VizMapAttrTab(VizMapUI mainUI, JTabbedPane tabContainer, int tabIndex, VisualMappingManager VMM, byte type) {
        super(new BorderLayout(), false);
        this.setName(CalculatorFactory.getTypeName(type));
        this.VMM = VMM;
        this.mainUIDialog = mainUI;
        this.catalog = VMM.getCalculatorCatalog();
        this.type = type;
        this.catalog.addChangeListener(new CatalogListener(), this.type);
        tabContainer.addChangeListener(new TabContainerListener(tabIndex));
    }

    public void visualStyleChanged() {
        Object defaultObj = VizUIUtilities.getDefault(this.VMM.getVisualStyle(), this.type);
        this.setCurrentCalculator(VizUIUtilities.getCurrentCalculator(this.VMM.getVisualStyle(), this.type));
        if (this.defaultValueDisplayer == null) {
            this.drawDefault(defaultObj);
            this.drawCalc();
        } else {
            this.rebuildCalcComboBox();
            this.defaultValueDisplayer.setObject(defaultObj);
        }
        this.refreshUI();
    }

    public void refreshUI() {
        if (this.calcPanel != null) {
            this.calcContainer.remove(this.calcPanel);
        }
        if (this.currentCalculator != null) {
            this.calcPanel = this.currentCalculator.getUI(this.mainUIDialog, this.VMM.getNetwork());
            this.calcContainer.add(this.calcPanel);
        } else {
            this.calcPanel = null;
        }
        this.validate();
        this.repaint();
        this.mainUIDialog.pack();
    }

    protected void setCurrentCalculator(Calculator newCalculator) {
        if (this.currentCalculator != null) {
            this.currentCalculator.removeChangeListener(this.calcListener);
        }
        this.currentCalculator = newCalculator;
        if (newCalculator != null) {
            newCalculator.addChangeListener(this.calcListener);
        }
    }

    protected void drawDefault(Object defaultObj) {
        JPanel outerDefPanel = new JPanel(false);
        outerDefPanel.setLayout(new BoxLayout(outerDefPanel, 0));
        JPanel defPanel = new JPanel(false);
        defPanel.setLayout(new BoxLayout(defPanel, 1));
        Box content = new Box(0);
        this.defaultValueDisplayer = ValueDisplayer.getDisplayFor(this.mainUIDialog, this.getName(), defaultObj);
        this.defaultValueDisplayer.addItemListener(new DefaultItemChangedListener());
        JButton defaultButton = new JButton("Change Default");
        defaultButton.addActionListener(this.defaultValueDisplayer.getInputListener());
        content.add(Box.createHorizontalGlue());
        content.add(defaultButton);
        content.add(Box.createHorizontalStrut(3));
        content.add(this.defaultValueDisplayer);
        content.add(Box.createHorizontalGlue());
        defPanel.add(Box.createVerticalStrut(3));
        defPanel.add(content);
        defPanel.add(Box.createVerticalStrut(3));
        Border defBorder = BorderFactory.createLineBorder(Color.BLACK);
        defPanel.setBorder(BorderFactory.createTitledBorder(defBorder, "Default", 2, 2));
        defPanel.validate();
        ImageIcon imageIcon = this.getImageIcon();
        if (imageIcon == null) {
            this.add((Component)defPanel, "North");
        } else {
            JButton tempB = new JButton();
            tempB.setIcon(imageIcon);
            outerDefPanel.add(tempB);
            outerDefPanel.add(defPanel);
            this.add((Component)outerDefPanel, "North");
        }
    }

    protected ImageIcon getImageIcon() {
        ImageIcon icon = null;
        if (this.type == 0) {
            String imageFile = "images/nodeColorWheel.jpg";
            icon = new ImageIcon(this.getClass().getResource(imageFile), "Node Color");
        } else if (this.type == 1) {
            String imageFile = "images/nodeBorderColorWheel.jpg";
            icon = new ImageIcon(this.getClass().getResource(imageFile), "Node Border Color");
        }
        return icon;
    }

    protected void rebuildCalcComboBox() {
        if (this.calcComboBox != null) {
            this.mapPanelGBG.panel.remove(this.calcComboBox);
        }
        Collection<Calculator> calculators = this.catalog.getCalculators(this.type);
        Vector<Object> comboCalcs = new Vector<Object>();
        if (calculators != null) {
            comboCalcs.addAll(calculators);
        }
        if (this.currentCalculator != null && !calculators.contains(this.currentCalculator)) {
            comboCalcs.add(this.currentCalculator);
        }
        comboCalcs.add(0, new String("None"));
        this.calcComboBox = new JComboBox(comboCalcs);
        this.calcComboBox.setName("calcComboBox");
        if (this.currentCalculator == null) {
            this.calcComboBox.setSelectedIndex(0);
        } else {
            this.calcComboBox.setSelectedItem(this.currentCalculator);
        }
        MiscGB.insert(this.mapPanelGBG, this.calcComboBox, 0, 0, 4, 1, 1, 0, 2);
        this.calcComboBox.addItemListener(new CalcComboSelectionListener());
    }

    void switchCalculator(Calculator calc) {
        if (calc != null && calc.equals(this.currentCalculator)) {
            return;
        }
        this.setCurrentCalculator(calc);
        VizUIUtilities.setCurrentCalculator(this.VMM.getVisualStyle(), this.type, calc);
        this.refreshUI();
    }

    protected void drawCalc() {
        this.mapPanelGBG = new GridBagGroup("Mapping");
        MiscGB.pad(this.mapPanelGBG.constraints, 2, 2);
        MiscGB.inset(this.mapPanelGBG.constraints, 3);
        this.calcContainer = new JPanel(new GridLayout(), false);
        this.rebuildCalcComboBox();
        JButton newCalc = new JButton("New");
        newCalc.addActionListener(new NewCalcListener());
        newCalc.setToolTipText("Create a new calculator");
        JButton dupeCalc = new JButton("Duplicate");
        dupeCalc.addActionListener(new DupeCalcListener());
        dupeCalc.setToolTipText("Create a copy of this calculator");
        JButton renCalc = new JButton("Rename");
        renCalc.addActionListener(new RenCalcListener());
        renCalc.setToolTipText("Rename this calculator");
        JButton rmCalc = new JButton("Delete");
        rmCalc.addActionListener(new RmCalcListener());
        rmCalc.setToolTipText("Permanently delete this calculator");
        JPanel btnPanel = new JPanel();
        btnPanel.add(newCalc);
        btnPanel.add(dupeCalc);
        btnPanel.add(renCalc);
        btnPanel.add(rmCalc);
        MiscGB.insert(this.mapPanelGBG, btnPanel, 0, 1, 1, 1, 1, 0, 2);
        MiscGB.insert(this.mapPanelGBG, this.calcContainer, 0, 2, 4, 1, 5, 5, 1);
        this.add((Component)this.mapPanelGBG.panel, "Center");
    }

    private Calculator duplicateCalculator(Calculator c) {
        Calculator clone = null;
        try {
            clone = (Calculator)c.clone();
        }
        catch (CloneNotSupportedException exc) {
            System.err.println("Fatal error - Calculator didn't support Cloneable");
            exc.printStackTrace();
            return null;
        }
        String newName = this.getCalculatorName(clone);
        if (newName == null) {
            return null;
        }
        clone.setName(newName);
        return clone;
    }

    private String getCalculatorName(Calculator c) {
        String newName;
        String suggestedName = null;
        if (c != null) {
            suggestedName = this.catalog.checkCalculatorName(((Object)c).toString(), this.type);
        }
        while (true) {
            String ret;
            if ((ret = (String)JOptionPane.showInputDialog(this.mainUIDialog, "New name for calculator", "Calculator Name Input", 3, null, null, suggestedName)) == null) {
                return null;
            }
            if (ret.length() == 0) {
                JOptionPane.showMessageDialog(this.mainUIDialog, "Please enter a name for the calculator.", "Calculator Name Input Error", 0);
                continue;
            }
            newName = this.catalog.checkCalculatorName(ret, this.type);
            if (newName.equals(ret)) {
                return ret;
            }
            int alt = JOptionPane.showConfirmDialog(this.mainUIDialog, "Calculator with name " + ret + " already exists,\nrename to " + newName + " okay?", "Duplicate calculator name", 0, 2, null);
            if (alt == 0) break;
        }
        return newName;
    }

    VizMapTab checkCalcSelected(Calculator c) {
        if (this.currentCalculator == c) {
            return this;
        }
        return null;
    }

    void setComboBox(Calculator c) {
        if (c == null) {
            this.calcComboBox.setSelectedIndex(0);
        } else {
            this.calcComboBox.setSelectedItem(c);
        }
    }

    protected class CalculatorUIListener
    implements ChangeListener {
        protected CalculatorUIListener() {
        }

        public void stateChanged(ChangeEvent e) {
            VizMapAttrTab.this.refreshUI();
            VizMapAttrTab.this.VMM.getNetworkView().redrawGraph(false, true);
        }
    }

    private class RmCalcListener
    extends AbstractAction {
        private RmCalcListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (VizMapAttrTab.this.currentCalculator == null) {
                return;
            }
            Vector conflicts = VizMapAttrTab.this.mainUIDialog.checkCalculatorUsage(VizMapAttrTab.this.currentCalculator);
            if (conflicts.size() != 0 && (conflicts.size() != 1 || ((Vector)conflicts.get(0)).size() != 2)) {
                StringBuffer errMsg = new StringBuffer("Calculator ");
                errMsg.append(((Object)VizMapAttrTab.this.currentCalculator).toString());
                errMsg.append(" currently in use by:<br><ul>");
                for (int i = 0; i < conflicts.size(); ++i) {
                    Vector subSelect = (Vector)conflicts.get(i);
                    errMsg.append("<li>");
                    errMsg.append(subSelect.get(0));
                    errMsg.append("<ul>");
                    for (int j = 1; j < subSelect.size(); ++j) {
                        errMsg.append("<li>");
                        errMsg.append(subSelect.get(j));
                    }
                    errMsg.append("</ul>");
                }
                errMsg.append("</ul><br>Do you still want to delete this calculator?");
                JEditorPane errPane = new JEditorPane("text/html", errMsg.toString());
                errPane.setEditable(false);
                errPane.setBackground(null);
                int conf = JOptionPane.showConfirmDialog(VizMapAttrTab.this.mainUIDialog, errPane, "Calculator In Use", 0, 2);
                if (conf == 1) {
                    return;
                }
            } else {
                String s = "Are you sure you want to permanently delete this calculator?";
                int conf = JOptionPane.showConfirmDialog(VizMapAttrTab.this.mainUIDialog, s, "Confirm Remove Calculator", 0);
                if (conf == 1) {
                    return;
                }
            }
            Calculator temp = VizMapAttrTab.this.currentCalculator;
            VizMapAttrTab.this.switchCalculator(null);
            VizMapAttrTab.this.catalog.removeCalculator(temp);
        }
    }

    private class RenCalcListener
    extends AbstractAction {
        private RenCalcListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String calcName = VizMapAttrTab.this.getCalculatorName(VizMapAttrTab.this.currentCalculator);
            if (calcName == null) {
                return;
            }
            VizMapAttrTab.this.catalog.renameCalculator(VizMapAttrTab.this.currentCalculator, calcName);
        }
    }

    private class DupeCalcListener
    extends AbstractAction {
        private DupeCalcListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Calculator clone = VizMapAttrTab.this.duplicateCalculator(VizMapAttrTab.this.currentCalculator);
            if (clone == null) {
                return;
            }
            VizMapAttrTab.this.switchCalculator(clone);
            VizMapAttrTab.this.catalog.addCalculator(clone);
        }
    }

    private class NewCalcListener
    extends AbstractAction {
        private NewCalcListener() {
        }

        public void actionPerformed(ActionEvent e) {
            byte mapType;
            Constructor mapperCon;
            Set mapperNames = VizMapAttrTab.this.catalog.getMappingNames();
            Object[] mapperArray = mapperNames.toArray();
            String selectedMapper = (String)JOptionPane.showInputDialog(VizMapAttrTab.this.mainUIDialog, "Choose a mapper", "New Calculator", 3, null, mapperArray, mapperArray[0]);
            if (selectedMapper == null) {
                return;
            }
            String calcName = VizMapAttrTab.this.getCalculatorName(null);
            if (calcName == null) {
                return;
            }
            Class mapperClass = VizMapAttrTab.this.catalog.getMapping(selectedMapper);
            Class[] conTypes = new Class[]{Object.class, Byte.TYPE};
            try {
                mapperCon = mapperClass.getConstructor(conTypes);
            }
            catch (NoSuchMethodException exc) {
                System.err.println("Invalid mapper " + mapperClass.getName());
                JOptionPane.showMessageDialog(VizMapAttrTab.this.mainUIDialog, "Mapper " + mapperClass.getName() + " does not have an acceptable constructor. See documentation for ObjectMapper.", "Invalid Mapper", 0);
                return;
            }
            switch (VizMapAttrTab.this.type) {
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 15: 
                case 124: 
                case 125: {
                    mapType = 0;
                    break;
                }
                default: {
                    mapType = 1;
                }
            }
            Object defaultObj = VizUIUtilities.getDefault(VizMapAttrTab.this.VMM.getVisualStyle(), VizMapAttrTab.this.type);
            Object[] invokeArgs = new Object[]{defaultObj, new Byte(mapType)};
            ObjectMapping mapper = null;
            try {
                mapper = (ObjectMapping)mapperCon.newInstance(invokeArgs);
            }
            catch (Exception exc) {
                System.err.println("Error creating mapping");
                JOptionPane.showMessageDialog(VizMapAttrTab.this.mainUIDialog, "Error creating mapping " + mapperClass.getName(), "Error", 0);
            }
            Calculator calc = CalculatorFactory.newDefaultCalculator(VizMapAttrTab.this.type, calcName, mapper);
            VizMapAttrTab.this.switchCalculator(calc);
            VizMapAttrTab.this.catalog.addCalculator(calc);
        }
    }

    private class CalcComboSelectionListener
    implements ItemListener {
        private CalcComboSelectionListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                if (VizMapAttrTab.this.calcComboBox.getSelectedIndex() == 0) {
                    VizMapAttrTab.this.switchCalculator(null);
                } else {
                    Object selected = VizMapAttrTab.this.calcComboBox.getSelectedItem();
                    VizMapAttrTab.this.switchCalculator((Calculator)selected);
                    VizMapAttrTab.this.refreshUI();
                }
            }
        }
    }

    private class DefaultItemChangedListener
    implements ItemListener {
        private DefaultItemChangedListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getItemSelectable() == VizMapAttrTab.this.defaultValueDisplayer && e.getStateChange() == 1) {
                Object newDefault = VizMapAttrTab.this.defaultValueDisplayer.getValue();
                VizUIUtilities.setDefault(VizMapAttrTab.this.VMM.getVisualStyle(), VizMapAttrTab.this.type, newDefault);
            }
        }
    }

    protected class TabContainerListener
    implements ChangeListener {
        protected int tabIndex;

        public TabContainerListener(int tabIndex) {
            this.tabIndex = tabIndex;
        }

        public void stateChanged(ChangeEvent e) {
            JTabbedPane source = (JTabbedPane)e.getSource();
            if (source.getModel().getSelectedIndex() == this.tabIndex) {
                VizMapAttrTab.this.refreshUI();
            }
        }
    }

    private class CatalogListener
    implements ChangeListener {
        private CatalogListener() {
        }

        public void stateChanged(ChangeEvent e) {
            VizMapAttrTab.this.rebuildCalcComboBox();
            VizMapAttrTab.this.validate();
            VizMapAttrTab.this.repaint();
        }
    }
}

