/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.document;

import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfMapper;
import com.lowagie.text.rtf.document.RtfDocumentHeader;
import com.lowagie.text.rtf.document.RtfDocumentSettings;
import com.lowagie.text.rtf.document.RtfInfoElement;
import com.lowagie.text.rtf.document.output.RtfDataCache;
import com.lowagie.text.rtf.document.output.RtfDiskCache;
import com.lowagie.text.rtf.document.output.RtfMemoryCache;
import com.lowagie.text.rtf.graphic.RtfImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class RtfDocument
extends RtfElement {
    private RtfDataCache data = new RtfMemoryCache();
    private RtfMapper mapper = new RtfMapper(this);
    private RtfDocumentHeader documentHeader = new RtfDocumentHeader(this);
    private ArrayList previousRandomInts = null;
    private boolean autogenerateTOCEntries = false;
    private RtfDocumentSettings documentSettings = null;
    private RtfBasicElement lastElementWritten = null;
    private static final byte[] RTF_DOCUMENT = "\\rtf1".getBytes();

    public RtfDocument() {
        super(null);
        this.documentHeader.init();
        this.previousRandomInts = new ArrayList();
        this.documentSettings = new RtfDocumentSettings(this);
    }

    public void writeDocument(OutputStream outputStream) {
        try {
            outputStream.write(OPEN_GROUP);
            outputStream.write(RTF_DOCUMENT);
            outputStream.write(this.documentHeader.write());
            this.data.writeTo(outputStream);
            outputStream.write(CLOSE_GROUP);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void open() {
        try {
            switch (this.documentSettings.getDataCacheStyle()) {
                case 2: {
                    this.data = new RtfMemoryCache();
                    break;
                }
                case 1: {
                    this.data = new RtfDiskCache();
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("Could not initialise disk cache. Using memory cache.");
            iOException.printStackTrace();
            this.data = new RtfMemoryCache();
        }
    }

    public void add(RtfBasicElement rtfBasicElement) {
        try {
            if (rtfBasicElement instanceof RtfInfoElement) {
                this.documentHeader.addInfoElement((RtfInfoElement)rtfBasicElement);
            } else {
                if (rtfBasicElement instanceof RtfImage) {
                    ((RtfImage)rtfBasicElement).setTopLevelElement(true);
                }
                this.data.getOutputStream().write(rtfBasicElement.write());
                this.lastElementWritten = rtfBasicElement;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public RtfMapper getMapper() {
        return this.mapper;
    }

    public int getRandomInt() {
        Integer n = null;
        while (this.previousRandomInts.contains(n = new Integer((int)(Math.random() * 2.147483647E9)))) {
        }
        this.previousRandomInts.add(n);
        return n;
    }

    public RtfDocumentHeader getDocumentHeader() {
        return this.documentHeader;
    }

    public String filterSpecialChar(String string, boolean bl, boolean bl2) {
        if (string == null) {
            return "";
        }
        int n = string.length();
        char c = 'z';
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 == '\\') {
                stringBuffer.append("\\\\");
                continue;
            }
            if (c2 == '\n') {
                if (bl2) {
                    stringBuffer.append("\\line ");
                    continue;
                }
                stringBuffer.append("\\par ");
                continue;
            }
            if (c2 == '\t') {
                stringBuffer.append("\\tab ");
                continue;
            }
            if (c2 > c && this.documentSettings.isAlwaysUseUnicode()) {
                if (bl) {
                    stringBuffer.append("\\'").append(Long.toHexString(c2));
                    continue;
                }
                stringBuffer.append("\\u").append((long)c2).append('?');
                continue;
            }
            stringBuffer.append(c2);
        }
        String string2 = stringBuffer.toString();
        if (string2.indexOf("$newpage$") >= 0) {
            String string3 = string2.substring(0, string2.indexOf("$newpage$"));
            String string4 = string2.substring(string2.indexOf("$newpage$") + 9);
            stringBuffer = new StringBuffer(string3);
            stringBuffer.append("\\page\\par ");
            stringBuffer.append(string4);
            return stringBuffer.toString();
        }
        return string2;
    }

    public void setAutogenerateTOCEntries(boolean bl) {
        this.autogenerateTOCEntries = bl;
    }

    public boolean getAutogenerateTOCEntries() {
        return this.autogenerateTOCEntries;
    }

    public RtfDocumentSettings getDocumentSettings() {
        return this.documentSettings;
    }

    public RtfBasicElement getLastElementWritten() {
        return this.lastElementWritten;
    }
}

