/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.util.FileUtil;
import cytoscape.util.ZipUtil;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.CalculatorIO;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.mappings.ContinuousMapping;
import cytoscape.visual.mappings.DiscreteMapping;
import cytoscape.visual.mappings.PassThroughMapping;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public abstract class CalculatorCatalogFactory {
    static Properties vizmapProps;
    static CalculatorCatalog calculatorCatalog;

    public static CalculatorCatalog loadCalculatorCatalog() {
        return CalculatorCatalogFactory.loadCalculatorCatalog(null);
    }

    public static CalculatorCatalog loadCalculatorCatalog(String vmName) {
        vizmapProps = CytoscapeInit.getVisualProperties();
        CalculatorCatalogFactory.initCatalog();
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(new VizMapListener());
        return calculatorCatalog;
    }

    private static void initCatalog() {
        calculatorCatalog.clear();
        calculatorCatalog.addMapping("Discrete Mapper", DiscreteMapping.class);
        calculatorCatalog.addMapping("Continuous Mapper", ContinuousMapping.class);
        calculatorCatalog.addMapping("Passthrough Mapper", PassThroughMapping.class);
        CalculatorIO.loadCalculators(vizmapProps, calculatorCatalog);
    }

    static {
        calculatorCatalog = new CalculatorCatalog();
    }

    private static class VizMapListener
    implements PropertyChangeListener {
        private VizMapListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName() == Cytoscape.SAVE_VIZMAP_PROPS) {
                File propertiesFile = null;
                propertiesFile = e.getNewValue() == null ? CytoscapeInit.getConfigFile("vizmap.props") : new File((String)e.getNewValue());
                if (propertiesFile != null) {
                    Set test = calculatorCatalog.getVisualStyleNames();
                    Iterator it = test.iterator();
                    System.out.println("Saving the following Visual Styles: ");
                    while (it.hasNext()) {
                        System.out.println("    - " + it.next().toString());
                    }
                    CalculatorIO.storeCatalog(calculatorCatalog, propertiesFile);
                    System.out.println("Vizmap saved to: " + propertiesFile);
                }
            } else if (e.getPropertyName() == Cytoscape.VIZMAP_RESTORED || e.getPropertyName() == Cytoscape.VIZMAP_LOADED) {
                if (e.getPropertyName() == Cytoscape.VIZMAP_RESTORED) {
                    vizmapProps.clear();
                }
                Object vizmapSource = e.getNewValue();
                System.out.println("vizmapSource: '" + vizmapSource.toString() + "'");
                try {
                    InputStream is = null;
                    if (vizmapSource.getClass() == URL.class) {
                        is = ((URL)vizmapSource).openStream();
                    } else if (vizmapSource.getClass() == String.class) {
                        is = e.getPropertyName() == Cytoscape.VIZMAP_RESTORED ? ZipUtil.readFile((String)vizmapSource, ".*vizmap.props") : FileUtil.getInputStream((String)vizmapSource);
                    }
                    if (is != null) {
                        vizmapProps.load(is);
                        is.close();
                    }
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                CalculatorCatalogFactory.initCatalog();
                System.out.println("Applying visual styles from: " + vizmapSource.toString());
                Cytoscape.getDesktop().setupVizMapper();
                Cytoscape.getDesktop().getVizMapUI().getStyleSelector().resetStyles();
                Cytoscape.getDesktop().getVizMapUI().getStyleSelector().repaint();
                Cytoscape.getDesktop().getVizMapUI().refreshUI();
                VisualMappingManager vmm = Cytoscape.getVisualMappingManager();
                vmm.setVisualStyle(vmm.getVisualStyle().getName());
                Cytoscape.getCurrentNetworkView().setVisualStyle(vmm.getVisualStyle().getName());
                Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
                Cytoscape.getDesktop().repaint();
            }
        }
    }
}

