/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.AllTests;
import cytoscape.util.MinMaxDouble;
import cytoscape.util.MinMaxInt;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class MinMaxTest
extends TestCase {
    public MinMaxTest(String name) {
        super(name);
    }

    public void testMinMaxDoubleVector() throws Exception {
        AllTests.standardOut("testMinMaxDoubleVector");
        double min = -888.88;
        double max = 123456.789;
        double[] input = new double[]{1.0, 23.2, 18.5, -100.232, max, min};
        MinMaxDouble minMax = new MinMaxDouble(input);
        MinMaxTest.assertTrue((minMax.getMin() == min ? 1 : 0) != 0);
        MinMaxTest.assertTrue((minMax.getMax() == max ? 1 : 0) != 0);
    }

    public void testMinMaxDoubleMatrix() throws Exception {
        AllTests.standardOut("testMinMaxDoubleMatrix");
        double min = -888.88;
        double max = 123456.789;
        double[][] input = new double[][]{{1.0, 23.2, 18.5, -100.232, max, min}, {8.7, 1.2, 1.2, 1.2, 1.2, -50.3}, {23.4, 2.1, 2.1, 2.1, 2.2, 0.0}};
        MinMaxDouble minMax = new MinMaxDouble(input);
        MinMaxTest.assertTrue((minMax.getMin() == min ? 1 : 0) != 0);
        MinMaxTest.assertTrue((minMax.getMax() == max ? 1 : 0) != 0);
    }

    public void testMinMaxIntVector() throws Exception {
        AllTests.standardOut("testMinMaxIntVector");
        int min = -888;
        int max = 123456;
        int[] input = new int[]{1, 232, 18, -100, max, min};
        MinMaxInt minMax = new MinMaxInt(input);
        MinMaxTest.assertTrue((minMax.getMin() == min ? 1 : 0) != 0);
        MinMaxTest.assertTrue((minMax.getMax() == max ? 1 : 0) != 0);
    }

    public void testMinMaxIntMatrix() throws Exception {
        AllTests.standardOut("testMinMaxIntMatrix");
        int min = -888;
        int max = 123456;
        int[][] input = new int[][]{{1, 23, 18, -100, max, min}, {8, 1, 1, 1, 1, -50}, {23, 2, 2, 2, 2, 0}};
        MinMaxInt minMax = new MinMaxInt(input);
        MinMaxTest.assertTrue((minMax.getMin() == min ? 1 : 0) != 0);
        MinMaxTest.assertTrue((minMax.getMax() == max ? 1 : 0) != 0);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(MinMaxTest.class));
    }
}

