/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import cytoscape.data.FlagFilter;
import giny.model.Edge;
import giny.model.Node;
import java.util.Set;

public class FlagEvent {
    public static final int SINGLE_NODE = 0;
    public static final int SINGLE_EDGE = 1;
    public static final int NODE_SET = 2;
    public static final int EDGE_SET = 3;
    private FlagFilter source;
    private Object target;
    private int targetType;
    private boolean selectOn = true;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FlagEvent(FlagFilter source, Object target, boolean selectOn) {
        this.source = source;
        this.target = target;
        this.selectOn = selectOn;
        if (target == null) {
            throw new IllegalArgumentException("Unexpected null target");
        }
        if (target instanceof Node) {
            this.targetType = 0;
            return;
        } else if (target instanceof Edge) {
            this.targetType = 1;
            return;
        } else {
            if (!(target instanceof Set)) throw new IllegalArgumentException("Unexpected target type");
            Set targetSet = (Set)target;
            if (targetSet.size() == 0) {
                throw new IllegalArgumentException("Unexpected empty target set");
            }
            Object first = targetSet.iterator().next();
            if (first instanceof Node) {
                this.targetType = 2;
                return;
            } else {
                if (!(first instanceof Edge)) throw new IllegalArgumentException("Unknown object type in target set");
                this.targetType = 3;
            }
        }
    }

    public FlagFilter getSource() {
        return this.source;
    }

    public Object getTarget() {
        return this.target;
    }

    public int getTargetType() {
        return this.targetType;
    }

    public boolean getEventType() {
        return this.selectOn;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        sb.append("FlagEvent:" + lineSep);
        sb.append("    target = " + this.getTarget() + lineSep);
        sb.append("    target type = ");
        switch (this.getTargetType()) {
            case 0: {
                sb.append("SINGLE_NODE");
                break;
            }
            case 1: {
                sb.append("SINGLE_EDGE");
                break;
            }
            case 2: {
                sb.append("NODE_SET");
                break;
            }
            case 3: {
                sb.append("EDGE_SET");
                break;
            }
            default: {
                sb.append(this.getTargetType());
            }
        }
        sb.append(lineSep);
        sb.append("    event type = ");
        if (this.getEventType()) {
            sb.append("ON");
        } else {
            sb.append("OFF");
        }
        sb.append(lineSep);
        return sb.toString();
    }
}

