/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.agave;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.agave.AGAVEBioSeqHandler;
import org.biojava.bio.seq.io.agave.AGAVECallbackItf;
import org.biojava.bio.seq.io.agave.AGAVEChromosomeHandler;
import org.biojava.bio.seq.io.agave.AGAVEComputationHandler;
import org.biojava.bio.seq.io.agave.AGAVEContigHandler;
import org.biojava.bio.seq.io.agave.DelegationManager;
import org.biojava.bio.seq.io.agave.ElementRecognizer;
import org.biojava.bio.seq.io.agave.StAXFeatureHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AGAVEHandler
extends StAXFeatureHandler
implements AGAVECallbackItf {
    private List sequenceSet = new ArrayList(1);

    public AGAVEHandler() {
        this.setHandlerCharacteristics("sciobj", true);
        super.addHandler(new ElementRecognizer.ByLocalName("bio_sequence"), AGAVEBioSeqHandler.AGAVE_BIO_SEQ_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("contig"), AGAVEContigHandler.AGAVE_CONTIG_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("computation"), AGAVEComputationHandler.AGAVE_COMPUTATION_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("chromosome"), AGAVEChromosomeHandler.AGAVE_CHROMOSOME_HANDLER_FACTORY);
    }

    public void reportSequence(Sequence sequence) {
        this.sequenceSet.add(sequence);
    }

    public Iterator getSequences() {
        return this.sequenceSet.iterator();
    }

    public void startElementHandler(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
        if (!localName.equals("sciobj")) {
            throw new SAXException("root element of file is not a sciobj element");
        }
        String version = attrs.getValue("version");
        if (!version.startsWith("2")) {
            throw new SAXException("AGAVE version is not 2.*,  we only support 2.* ");
        }
    }
}

