/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.CyEdge;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.visual.Arrow;
import cytoscape.visual.BypassHelper;
import cytoscape.visual.LabelPosition;
import cytoscape.visual.LineType;
import java.awt.Color;
import java.awt.Font;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class BypassHelperTest
extends TestCase {
    CyNode homer;
    CyNode marge;
    CyEdge lisa;
    CyAttributes nodeAttrs;
    CyAttributes edgeAttrs;
    String id;

    public BypassHelperTest(String name) {
        super(name);
    }

    public void setUp() {
        this.homer = Cytoscape.getCyNode("homer", true);
        this.marge = Cytoscape.getCyNode("marge", true);
        this.lisa = Cytoscape.getCyEdge(this.homer, this.marge, "interaction", "pp", true);
        this.nodeAttrs = Cytoscape.getNodeAttributes();
        this.edgeAttrs = Cytoscape.getEdgeAttributes();
        this.id = this.homer.getIdentifier();
        this.nodeAttrs.setAttribute(this.id, "node.fillColor", "25,31,244");
        this.nodeAttrs.setAttribute(this.id, "node.borderColor", "junk");
        this.nodeAttrs.setAttribute(this.id, "node.size", "22.0");
        this.nodeAttrs.setAttribute(this.id, "node.labelPosition", "NE,W,c,13,-1");
        this.nodeAttrs.setAttribute(this.id, "node.font", "SansSerif,italic,10");
        this.nodeAttrs.setAttribute(this.id, "node.lineType", "dashed2");
        this.nodeAttrs.setAttribute(this.id, "node.shape", "DIAMOND");
        this.edgeAttrs.setAttribute(this.lisa.getIdentifier(), "edge.sourceArrow", "WHITE_DELTA");
    }

    public void testGetBypass() {
        Object o = null;
        o = BypassHelper.getBypass(this.nodeAttrs, this.id, "node.fillColor", Color.class);
        System.out.println("id " + this.id);
        System.out.println("o " + o.toString());
        BypassHelperTest.assertTrue((String)"color equals", (boolean)((Color)o).equals(new Color(25, 31, 244)));
        o = BypassHelper.getBypass(this.nodeAttrs, this.id, "node.size", Double.class);
        BypassHelperTest.assertEquals((String)"size equals", (double)22.0, (double)((Double)o), (double)1.0E-4);
        o = BypassHelper.getBypass(this.nodeAttrs, this.id, "node.labelPosition", LabelPosition.class);
        System.out.println("lab pos " + o.toString());
        LabelPosition nlp = new LabelPosition(2, 3, 64, 13.0, -1.0);
        System.out.println("new lab pos " + nlp.toString());
        BypassHelperTest.assertTrue((String)"label position equals", (boolean)nlp.equals((LabelPosition)o));
        o = BypassHelper.getBypass(this.nodeAttrs, this.id, "node.font", Font.class);
        BypassHelperTest.assertTrue((String)"font equals", (boolean)new Font("SansSerif", 2, 10).equals((Font)o));
        o = BypassHelper.getBypass(this.nodeAttrs, this.id, "node.lineType", LineType.class);
        BypassHelperTest.assertTrue((String)"linetype equals", (boolean)LineType.DASHED_2.equals((LineType)o));
        o = BypassHelper.getBypass(this.nodeAttrs, this.id, "node.shape", Byte.class);
        BypassHelperTest.assertEquals((String)"shape equals", (byte)7, (byte)((Byte)o));
        o = BypassHelper.getBypass(this.edgeAttrs, this.lisa.getIdentifier(), "edge.sourceArrow", Arrow.class);
        BypassHelperTest.assertTrue((String)"arrow equals", (Arrow.WHITE_DELTA == (Arrow)o ? 1 : 0) != 0);
    }

    public void testGetColorBypass() {
        Color c = BypassHelper.getColorBypass(this.nodeAttrs, this.id, "node.fillColor");
        BypassHelperTest.assertTrue((String)"color equals", (boolean)c.equals(new Color(25, 31, 244)));
        c = BypassHelper.getColorBypass(this.nodeAttrs, this.id, "node.borderColor");
        System.out.print("should be null: ");
        System.out.println(c);
        BypassHelperTest.assertNull((String)"border color null ", (Object)c);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(BypassHelperTest.class));
    }
}

