/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.calculators;

import cytoscape.CyNetwork;
import cytoscape.visual.NodeAppearance;
import cytoscape.visual.calculators.AbstractNodeColorCalculator;
import cytoscape.visual.calculators.NodeColorCalculator;
import cytoscape.visual.mappings.ObjectMapping;
import giny.model.Node;
import java.awt.Color;
import java.util.Properties;

public class GenericNodeColorCalculator
extends AbstractNodeColorCalculator
implements NodeColorCalculator {
    public byte getType() {
        return this.colType;
    }

    public String getPropertyLabel() {
        return this.propertyLabel;
    }

    public String getTypeName() {
        return this.typename;
    }

    protected String getClassName() {
        if (this.colType == 0) {
            return "cytoscape.visual.calculators.GenericNodeFillColorCalculator";
        }
        if (this.colType == 1) {
            return "cytoscape.visual.calculators.GenericNodeBorderColorCalculator";
        }
        return this.getClass().getName();
    }

    GenericNodeColorCalculator() {
        this.set((byte)0, "nodeFillColorCalculator", "Node Color");
    }

    public GenericNodeColorCalculator(String name, ObjectMapping m) {
        super(name, m);
        this.set((byte)0, "nodeFillColorCalculator", "Node Color");
    }

    public GenericNodeColorCalculator(String name, Properties props, String baseKey) {
        super(name, props, baseKey);
        this.set((byte)0, "nodeFillColorCalculator", "Node Color");
    }

    public void apply(NodeAppearance appr, Node node, CyNetwork network) {
        if (this.colType == 0) {
            this.apply(appr, node, network, this.FILL);
        } else if (this.colType == 1) {
            this.apply(appr, node, network, this.BORDER);
        } else {
            System.err.println("don't know what kind of calculator this is!");
        }
    }

    public Color calculateNodeColor(Node e, CyNetwork n) {
        NodeAppearance ea = new NodeAppearance();
        this.apply(ea, e, n);
        if (this.colType == 0) {
            return ea.getFillColor();
        }
        if (this.colType == 1) {
            return ea.getBorderColor();
        }
        return Color.white;
    }
}

