/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.util.CytoscapeAction;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.JOptionPane;

public class CreateNetworkViewAction
extends CytoscapeAction
implements PropertyChangeListener {
    public CreateNetworkViewAction() {
        super("Create View");
        this.setPreferredMenu("Edit");
        this.setAcceleratorCombo(86, 8);
        super.setEnabled(false);
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(this);
    }

    public CreateNetworkViewAction(boolean label) {
    }

    public void actionPerformed(ActionEvent e) {
        CyNetwork cyNetwork = Cytoscape.getCurrentNetwork();
        CreateNetworkViewAction.createViewFromCurrentNetwork(cyNetwork);
    }

    public static void createViewFromCurrentNetwork(CyNetwork cyNetwork) {
        DecimalFormat formatter = new DecimalFormat("#,###,###");
        if (cyNetwork.getNodeCount() > Integer.parseInt(CytoscapeInit.getProperties().getProperty("secondaryViewThreshold"))) {
            int n = JOptionPane.showConfirmDialog(Cytoscape.getDesktop(), "Network contains " + formatter.format(cyNetwork.getNodeCount()) + " nodes and " + formatter.format(cyNetwork.getEdgeCount()) + " edges.  " + "\nRendering a network this size may take several " + "minutes.\n" + "Do you wish to proceed?", "Rendering Large Network", 0);
            if (n == 0) {
                Cytoscape.createNetworkView(cyNetwork);
            } else {
                JOptionPane.showMessageDialog(Cytoscape.getDesktop(), "Create View Request Cancelled by User.");
            }
        } else {
            Cytoscape.createNetworkView(cyNetwork);
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("NETWORK_VIEW_DESTROYED")) {
            super.setEnabled(true);
        }
    }
}

