/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.table;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import org.freehep.swing.table.SortableTableModel;
import org.freehep.swing.table.TableColumnHeaderListener;
import org.freehep.swing.table.TableHeaderCellRenderer;

public class TableSorter {
    private int sortOnColumn;
    private boolean sortAscending;
    private Icon downTriangle;
    private Icon upTriangle;
    private transient SortableTableModel model;
    private transient JTableHeader header;

    public TableSorter(JTable table) {
        this(table, -1);
    }

    public TableSorter(JTable table, int column) {
        this(table, column, true);
    }

    public TableSorter(JTable table, int column, boolean ascending) {
        this.sortOnColumn = column;
        this.sortAscending = ascending;
        try {
            this.model = (SortableTableModel)table.getModel();
            this.model.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent event) {
                    if (event.getFirstRow() == -1 && TableSorter.this.sortOnColumn != -1) {
                        int oldSort = TableSorter.this.sortOnColumn;
                        int type = event.getType();
                        int column = event.getColumn();
                        if (type == -1) {
                            if (column < TableSorter.this.sortOnColumn) {
                                TableSorter.this.sortOnColumn--;
                            } else if (column == TableSorter.this.sortOnColumn) {
                                TableSorter.this.sortOnColumn = -1;
                            }
                        } else if (type == 1 && column <= TableSorter.this.sortOnColumn) {
                            TableSorter.this.sortOnColumn++;
                        }
                        if (TableSorter.this.sortOnColumn != oldSort) {
                            TableSorter.this.header.resizeAndRepaint();
                        }
                    }
                }
            });
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(this.getClass() + ": table should have a SortableTableModel as TableModel.");
        }
        this.header = table.getTableHeader();
        this.header.addMouseListener(new TableColumnHeaderListener(){

            public void headerClicked(JTable table, int col) {
                if (col != TableSorter.this.sortOnColumn) {
                    TableSorter.this.sortOnColumn = col;
                    TableSorter.this.sortAscending = true;
                } else {
                    TableSorter.this.sortAscending = !TableSorter.this.sortAscending;
                }
                TableSorter.this.sort();
            }
        });
        this.downTriangle = new Triangle(false);
        this.upTriangle = new Triangle(true);
        this.header.setDefaultRenderer(new TableHeaderCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
                if (table.convertColumnIndexToModel(col) == TableSorter.this.sortOnColumn) {
                    if (TableSorter.this.sortAscending) {
                        label.setIcon(TableSorter.this.downTriangle);
                    } else {
                        label.setIcon(TableSorter.this.upTriangle);
                    }
                } else {
                    label.setIcon(null);
                }
                return label;
            }
        });
        if (this.sortOnColumn != -1) {
            this.sort();
        }
    }

    public int getSortOnColumn() {
        return this.sortOnColumn;
    }

    public void setSortOnColumn(int column) {
        if (column != this.sortOnColumn) {
            this.sortOnColumn = column;
            this.sort();
        }
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }

    public void setSortAscending(boolean ascending) {
        if (ascending != this.sortAscending) {
            this.sortAscending = ascending;
            this.sort();
        }
    }

    private void sort() {
        this.model.sort(this.sortOnColumn, this.sortAscending);
        this.header.resizeAndRepaint();
    }

    private static class Triangle
    implements Icon {
        private boolean up;
        private static final int size = 16;
        private static final int[] xxdown = new int[]{3, 12, 7};
        private static final int[] yydown = new int[]{5, 5, 10};
        private static final int[] xxup = new int[]{2, 12, 7};
        private static final int[] yyup = new int[]{10, 10, 4};

        Triangle(boolean up) {
            this.up = up;
        }

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            int[] xp = new int[3];
            int[] yp = new int[3];
            for (int i = 0; i < 3; ++i) {
                xp[i] = x + (this.up ? xxup[i] : xxdown[i]);
                yp[i] = y + (this.up ? yyup[i] : yydown[i]);
            }
            g.setColor(c.getForeground());
            g.fillPolygon(xp, yp, 3);
        }
    }
}

